/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.client;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.client.renderers.AccessoryRenderer;
import io.wispforest.accessories.api.client.renderers.BuiltinAccessoryRenderers;
import io.wispforest.accessories.api.client.renderers.DefaultAccessoryRenderer;
import io.wispforest.accessories.api.client.renderers.WrappedAccessoryRenderer;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryCustomRendererComponent;
import io.wispforest.accessories.api.core.AccessoryRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class AccessoriesRendererRegistry {
    public static final ResourceLocation NO_RENDERER_ID = Accessories.of("no_renderer");
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<Item, ResourceLocation> ITEM_TO_RENDERER = new HashMap<Item, ResourceLocation>();
    private static final Map<Item, ResourceLocation> DATA_LOADED_ITEM_TO_RENDERER = new HashMap<Item, ResourceLocation>();
    private static final Map<ResourceLocation, Supplier<AccessoryRenderer>> RENDERERS = new HashMap<ResourceLocation, Supplier<AccessoryRenderer>>();
    private static final BiMap<ResourceLocation, AccessoryRenderer> CACHED_RENDERERS = HashBiMap.create();

    public static void bindItemToRenderer(Item item, ResourceLocation rendererId) {
        ResourceLocation entry = ITEM_TO_RENDERER.putIfAbsent(item, rendererId);
        if (entry != null) {
            LOGGER.error("Unable to bind Item with the given Register as Item already has binding: [Item: {}, Renderer: {}]", (Object)item, (Object)rendererId);
        }
    }

    public static void bindItemToRenderer(Item item, ResourceLocation rendererId, Supplier<AccessoryRenderer> renderer) {
        AccessoriesRendererRegistry.bindItemToRenderer(item, rendererId);
        AccessoriesRendererRegistry.registerRenderer(rendererId, renderer);
    }

    public static void bindItemToEmptyRenderer(Item item) {
        AccessoriesRendererRegistry.bindItemToRenderer(item, NO_RENDERER_ID);
    }

    public static void bindItemToArmorRenderer(Item item) {
        AccessoriesRendererRegistry.bindItemToRenderer(item, BuiltinAccessoryRenderers.ARMOR_RENDERER_ID);
    }

    public static void registerRenderer(ResourceLocation location, Supplier<AccessoryRenderer> renderer) {
        RENDERERS.put(location, renderer);
    }

    public static boolean hasRenderer(Item item) {
        return AccessoriesRendererRegistry.getBoundRenderer(item) != null;
    }

    public static boolean hasRenderer(ResourceLocation rendererId) {
        return RENDERERS.containsKey(rendererId);
    }

    public static AccessoryRenderer getRenderer(ItemStack stack) {
        if (stack.has(AccessoriesDataComponents.CUSTOM_RENDERER) && !stack.is(Items.BUNDLE)) {
            AccessoryCustomRendererComponent data = (AccessoryCustomRendererComponent)stack.get(AccessoriesDataComponents.CUSTOM_RENDERER);
            if (data != null) {
                return BuiltinAccessoryRenderers.DATA_DRIVEN;
            }
            Boolean defaultRenderOverride = data.defaultRenderOverride();
            if (defaultRenderOverride != null) {
                if (defaultRenderOverride.booleanValue()) {
                    return DefaultAccessoryRenderer.INSTANCE;
                }
                if (AccessoryRegistry.isDefaultAccessory(stack)) {
                    return new BuiltinAccessoryRenderers.EmptyRenderer();
                }
            }
        }
        return AccessoriesRendererRegistry.getRenderer(stack.getItem());
    }

    public static AccessoryRenderer getRenderer(Item item) {
        AccessoryRenderer renderer;
        ResourceLocation id = AccessoriesRendererRegistry.getBoundRenderer(item);
        if (id != null) {
            renderer = AccessoriesRendererRegistry.getRenderer(id);
            if (renderer == null) {
                renderer = DefaultAccessoryRenderer.INSTANCE;
            }
        } else {
            renderer = DefaultAccessoryRenderer.INSTANCE;
        }
        if (renderer instanceof BuiltinAccessoryRenderers.EmptyRenderer && Accessories.config().clientOptions.forceNullRenderReplacement()) {
            renderer = DefaultAccessoryRenderer.INSTANCE;
        } else if (renderer == null) {
            renderer = new BuiltinAccessoryRenderers.EmptyRenderer();
        }
        return renderer == null ? new BuiltinAccessoryRenderers.EmptyRenderer() : renderer;
    }

    @Nullable
    public static AccessoryRenderer getRenderer(ResourceLocation rendererId) {
        if (rendererId.equals((Object)NO_RENDERER_ID)) {
            return new BuiltinAccessoryRenderers.EmptyRenderer();
        }
        return (AccessoryRenderer)CACHED_RENDERERS.get((Object)rendererId);
    }

    @Nullable
    public static ResourceLocation getRendererId(AccessoryRenderer renderer) {
        return (ResourceLocation)CACHED_RENDERERS.inverse().get((Object)renderer);
    }

    @Nullable
    public static ResourceLocation getBoundRenderer(Item item) {
        if (DATA_LOADED_ITEM_TO_RENDERER.containsKey(item)) {
            return DATA_LOADED_ITEM_TO_RENDERER.get(item);
        }
        return ITEM_TO_RENDERER.get(item);
    }

    @ApiStatus.Internal
    public static void setDataLoadedItemToRenderer(Map<Item, ResourceLocation> data) {
        DATA_LOADED_ITEM_TO_RENDERER.clear();
        DATA_LOADED_ITEM_TO_RENDERER.putAll(data);
    }

    @ApiStatus.Internal
    public static void onReload() {
        CACHED_RENDERERS.clear();
        RENDERERS.forEach((rendererId, supplier) -> {
            ResourceLocation otherRendererId;
            AccessoryRenderer renderer = (AccessoryRenderer)supplier.get();
            if (renderer == null) {
                LOGGER.warn("A given renderer [{}] was found to be returning a null renderer which is not advised as method to indicate no rendering!", rendererId);
                renderer = new BuiltinAccessoryRenderers.EmptyRenderer();
            }
            if ((otherRendererId = (ResourceLocation)CACHED_RENDERERS.inverse().get((Object)renderer)) != null) {
                LOGGER.warn("A given renderer [{}] was found to be shared by another renderer [{}], such will be wrapped to prevent crashing and should be reported!", rendererId, (Object)otherRendererId);
                renderer = new WrappedAccessoryRenderer(renderer);
            }
            CACHED_RENDERERS.put(rendererId, (Object)renderer);
        });
    }

    @Deprecated(forRemoval=true)
    public static ResourceLocation getRendererId(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item);
    }

    @Deprecated(forRemoval=true)
    public static void registerRenderer(Item item, Supplier<@NotNull AccessoryRenderer> renderer) {
        ResourceLocation rendererId = AccessoriesRendererRegistry.getRendererId(item);
        AccessoriesRendererRegistry.registerRenderer(rendererId, renderer);
        AccessoriesRendererRegistry.bindItemToRenderer(item, rendererId);
    }

    @Deprecated(forRemoval=true)
    public static void registerNoRenderer(Item item) {
        AccessoriesRendererRegistry.bindItemToRenderer(item, NO_RENDERER_ID);
    }

    @Deprecated(forRemoval=true)
    public static void registerArmorRendering(Item item) {
        if (!AccessoriesRendererRegistry.hasRenderer(item)) {
            ResourceLocation rendererId = AccessoriesRendererRegistry.getRendererId(item);
            AccessoriesRendererRegistry.registerRenderer(rendererId, () -> BuiltinAccessoryRenderers.ARMOR_RENDERER);
            AccessoriesRendererRegistry.bindItemToRenderer(item, rendererId);
        }
    }
}

