/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import io.wispforest.accessories.api.AccessoriesStorageLookup;
import io.wispforest.accessories.api.client.AccessoriesRenderStateKeys;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.client.AccessoryRenderState;
import io.wispforest.accessories.api.client.renderers.AccessoryRenderer;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryNestContainerContents;
import io.wispforest.accessories.api.slot.SlotPath;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public interface AccessoryNestRenderer
extends AccessoryRenderer {
    default public List<ItemStack> getInnerStacks(ItemStack holderStack) {
        AccessoryNestContainerContents data = (AccessoryNestContainerContents)holderStack.get(AccessoriesDataComponents.NESTED_ACCESSORIES);
        if (data == null) {
            return List.of();
        }
        return data.accessories();
    }

    @Override
    default public <S extends LivingEntityRenderState> void render(AccessoryRenderState accessoryState, S entityState, EntityModel<S> model, PoseStack matrices, SubmitNodeCollector collector) {
        List<AccessoryRenderState> innerStates = accessoryState.getStateData(AccessoriesRenderStateKeys.NESTED_ACCESSORY_RENDER_STATES);
        for (AccessoryRenderState innerState : innerStates) {
            if (innerState == null) continue;
            ItemStack innerStack = innerState.getStateData(AccessoriesRenderStateKeys.ITEM_STACK);
            AccessoryRenderer renderer = AccessoriesRendererRegistry.getRenderer(innerStack);
            matrices.pushPose();
            try {
                renderer.render(innerState, entityState, model, matrices, collector);
            }
            catch (Exception e) {
                throw new IllegalStateException("[AccessoryNestRenderer] Unable to render a given inner item stack due the following error: ", e);
            }
            finally {
                matrices.popPose();
            }
        }
    }

    @Override
    default public void extractRenderState(ItemStack stack, SlotPath path, AccessoriesStorageLookup storageLookup, LivingEntity entity, LivingEntityRenderState entityState, AccessoryRenderState accessoryState) {
        AccessoryRenderer.super.extractRenderState(stack, path, storageLookup, entity, entityState, accessoryState);
        ArrayList<@Nullable AccessoryRenderState> innerStates = new ArrayList<AccessoryRenderState>();
        List<ItemStack> innerStacks = this.getInnerStacks(stack);
        for (int i = 0; i < innerStacks.size(); ++i) {
            ItemStack innerStack = innerStacks.get(i);
            AccessoryRenderer renderer = AccessoriesRendererRegistry.getRenderer(innerStack);
            AccessoryRenderState state = renderer.createRenderState(innerStack, SlotPath.withInnerIndex(path, i), storageLookup, entity, entityState);
            innerStates.add(state);
        }
        accessoryState.setStateData(AccessoriesRenderStateKeys.NESTED_ACCESSORY_RENDER_STATES, innerStates);
    }

    @Override
    default public boolean shouldRender(ItemStack stack, SlotPath path, AccessoriesStorageLookup storageLookup, LivingEntity entity, LivingEntityRenderState renderState, boolean isRenderingEnabled) {
        List<ItemStack> innerStacks = this.getInnerStacks(stack);
        for (ItemStack innerStack : innerStacks) {
            AccessoryRenderer renderer = AccessoriesRendererRegistry.getRenderer(innerStack);
            if (!renderer.shouldRender(stack, path, storageLookup, entity, renderState, isRenderingEnabled)) continue;
            return true;
        }
        return AccessoryRenderer.super.shouldRender(stack, path, storageLookup, entity, renderState, isRenderingEnabled);
    }
}

