/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import com.mojang.math.Axis;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesStorageLookup;
import io.wispforest.accessories.api.client.AccessoriesRenderStateKeys;
import io.wispforest.accessories.api.client.AccessoryRenderState;
import io.wispforest.accessories.api.client.DefaultedContextKey;
import io.wispforest.accessories.api.client.renderers.AccessoryRenderer;
import io.wispforest.accessories.api.client.rendering.ModelTransformOps;
import io.wispforest.accessories.api.client.rendering.Side;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryCustomRendererComponent;
import io.wispforest.accessories.api.slot.SlotPath;
import io.wispforest.accessories.compat.config.RenderSlotTarget;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.joml.Quaternionfc;
import org.slf4j.Logger;

public class DefaultAccessoryRenderer
implements AccessoryRenderer {
    public static final ContextKey<Boolean> DISABLED_TRANSFORMATIONS = new DefaultedContextKey<Boolean>(Accessories.of("disabled_transformations"), () -> false);
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final DefaultAccessoryRenderer INSTANCE;
    private final Map<String, RenderHelper> slotToHelpers = new HashMap<String, RenderHelper>();
    private static final Map<String, RenderHelper> DEFAULT_HELPERS;

    public DefaultAccessoryRenderer() {
        this.slotToHelpers.putAll(DEFAULT_HELPERS);
    }

    public static void registerHelper(String slotType, RenderHelper helper) {
        Map<String, RenderHelper> helpers = DefaultAccessoryRenderer.INSTANCE.slotToHelpers;
        if (!helpers.containsKey(slotType)) {
            helpers.put(slotType, helper);
        } else {
            LOGGER.warn("[DefaultAccessoryRenderer] Unable to add to the main renderer instance due to a duplicate helper already exists!");
        }
    }

    @Override
    public <S extends LivingEntityRenderState> void render(AccessoryRenderState accessoryState, S entityState, EntityModel<S> model, PoseStack matrices, SubmitNodeCollector collector) {
        if (!(model instanceof HumanoidModel)) {
            return;
        }
        HumanoidModel humanoidModel = (HumanoidModel)model;
        ItemStackRenderState stackRenderState = accessoryState.getStateData(AccessoriesRenderStateKeys.ITEM_STACK_STATE);
        if (stackRenderState == null) {
            throw new IllegalStateException("Unable to render default accessory as the ItemStacks render state has not been setup!");
        }
        Integer light = (Integer)entityState.getStateData(AccessoriesRenderStateKeys.LIGHT);
        Consumer<PoseStack> renderCall = poseStack -> stackRenderState.submit(poseStack, collector, light.intValue(), OverlayTexture.NO_OVERLAY, entityState.outlineColor);
        if (!accessoryState.getStateData(DISABLED_TRANSFORMATIONS).booleanValue()) {
            SlotPath path = accessoryState.getStateData(AccessoriesRenderStateKeys.SLOT_PATH);
            ItemStack stack = accessoryState.getStateData(AccessoriesRenderStateKeys.ITEM_STACK);
            RenderHelper helper = this.slotToHelpers.get(path.slotName());
            if (helper == null) {
                return;
            }
            helper.render(stack, path, matrices, (HumanoidModel<? extends HumanoidRenderState>)humanoidModel, entityState, renderCall);
        } else {
            renderCall.accept(matrices);
        }
    }

    @Override
    public boolean shouldCreateStackRenderState() {
        return true;
    }

    @Override
    public boolean shouldRender(ItemStack stack, SlotPath path, AccessoriesStorageLookup storageLookup, LivingEntity entity, LivingEntityRenderState renderState, boolean isRenderingEnabled) {
        List<RenderSlotTarget> disabledTargetType = Accessories.config().clientOptions.disabledDefaultRenders();
        String slotName = path.slotName();
        for (RenderSlotTarget target : disabledTargetType) {
            if (!slotName.equals(target.slotType) || !target.targetType.isValid(stack.getItem())) continue;
            return false;
        }
        AccessoryCustomRendererComponent translationData = (AccessoryCustomRendererComponent)stack.getOrDefault(AccessoriesDataComponents.CUSTOM_RENDERER, (Object)AccessoryCustomRendererComponent.EMPTY);
        if (!translationData.disableDefaultTranslations() && this.slotToHelpers.get(path.slotName()) == null) {
            return false;
        }
        HumanoidArm arm = (HumanoidArm)renderState.getStateData(AccessoriesRenderStateKeys.ARM);
        if (arm != null) {
            return (slotName.equals("hand") || slotName.equals("wrist") || slotName.equals("ring")) && (path.index() % 2 == 0 ? arm == HumanoidArm.RIGHT : arm == HumanoidArm.LEFT);
        }
        return AccessoryRenderer.super.shouldRender(stack, path, storageLookup, entity, renderState, isRenderingEnabled);
    }

    static {
        DEFAULT_HELPERS = Map.ofEntries(Map.entry("face", new RenderHelper(){

            @Override
            public <S extends LivingEntityRenderState> void render(ItemStack stack, SlotPath path, PoseStack matrices, HumanoidModel<? extends HumanoidRenderState> humanoidModel, S renderState, Consumer<PoseStack> renderCall) {
                ModelTransformOps.transformToFace(matrices, renderState, humanoidModel, "head", Side.FRONT);
                renderCall.accept(matrices);
            }
        }), Map.entry("hat", new RenderHelper(){

            @Override
            public <S extends LivingEntityRenderState> void render(ItemStack stack, SlotPath path, PoseStack matrices, HumanoidModel<? extends HumanoidRenderState> humanoidModel, S renderState, Consumer<PoseStack> renderCall) {
                ModelTransformOps.transformToFace(matrices, renderState, humanoidModel, "head", Side.TOP);
                matrices.translate(0.0, 0.25, 0.0);
                for (int i = 0; i < stack.getCount(); ++i) {
                    renderCall.accept(matrices);
                    matrices.translate(0.0, 0.5, 0.0);
                }
            }
        }), Map.entry("back", new RenderHelper(){

            @Override
            public <S extends LivingEntityRenderState> void render(ItemStack stack, SlotPath path, PoseStack matrices, HumanoidModel<? extends HumanoidRenderState> humanoidModel, S renderState, Consumer<PoseStack> renderCall) {
                ModelTransformOps.transformToFace(matrices, renderState, humanoidModel, "body", Side.BACK);
                matrices.scale(1.5f, 1.5f, 1.5f);
                renderCall.accept(matrices);
            }
        }), Map.entry("necklace", new RenderHelper(){

            @Override
            public <S extends LivingEntityRenderState> void render(ItemStack stack, SlotPath path, PoseStack matrices, HumanoidModel<? extends HumanoidRenderState> humanoidModel, S renderState, Consumer<PoseStack> renderCall) {
                ModelTransformOps.transformToModelPart(matrices, renderState, humanoidModel, "body", 0, 1, 1);
                matrices.translate(0.0, -0.25, 0.0);
                renderCall.accept(matrices);
            }
        }), Map.entry("cape", new RenderHelper(){

            @Override
            public <S extends LivingEntityRenderState> void render(ItemStack stack, SlotPath path, PoseStack matrices, HumanoidModel<? extends HumanoidRenderState> humanoidModel, S renderState, Consumer<PoseStack> renderCall) {
                ModelTransformOps.transformToModelPart(matrices, renderState, humanoidModel, "body", 0, 1, -1);
                matrices.translate(0.0, -0.25, 0.0);
                renderCall.accept(matrices);
            }
        }), Map.entry("ring", new RenderHelper(){

            @Override
            public <S extends LivingEntityRenderState> void render(ItemStack stack, SlotPath path, PoseStack matrices, HumanoidModel<? extends HumanoidRenderState> humanoidModel, S renderState, Consumer<PoseStack> renderCall) {
                String modelTarget = path.index() % 2 == 0 ? "right_arm" : "left_arm";
                int xPercent = path.index() % 2 == 0 ? 1 : -1;
                ModelTransformOps.transformToModelPart(matrices, renderState, humanoidModel, modelTarget, xPercent, -1, 0);
                int offset = path.index() / 2;
                matrices.translate((double)((path.index() % 2 == 0 ? -1 : 1) * offset) * -1.0E-4, 0.25 * (double)(offset + 1), 0.0);
                matrices.scale(0.5f, 0.5f, 0.5f);
                matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
                for (int i = 0; i < stack.getCount(); ++i) {
                    renderCall.accept(matrices);
                    matrices.translate(0.0, 0.0, path.index() % 2 == 0 ? -0.5 : 0.5);
                }
            }
        }), Map.entry("wrist", new RenderHelper(){

            @Override
            public <S extends LivingEntityRenderState> void render(ItemStack stack, SlotPath path, PoseStack matrices, HumanoidModel<? extends HumanoidRenderState> humanoidModel, S renderState, Consumer<PoseStack> renderCall) {
                String modelTarget = path.index() % 2 == 0 ? "right_arm" : "left_arm";
                ModelTransformOps.transformToModelPart(matrices, renderState, humanoidModel, modelTarget, 0, -0.5, 0);
                matrices.scale(1.01f, 1.01f, 1.01f);
                matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
                renderCall.accept(matrices);
            }
        }), Map.entry("hand", new RenderHelper(){

            @Override
            public <S extends LivingEntityRenderState> void render(ItemStack stack, SlotPath path, PoseStack matrices, HumanoidModel<? extends HumanoidRenderState> humanoidModel, S renderState, Consumer<PoseStack> renderCall) {
                String modelTarget = path.index() % 2 == 0 ? "right_arm" : "left_arm";
                ModelTransformOps.transformToFace(matrices, renderState, humanoidModel, modelTarget, Side.BOTTOM);
                matrices.translate(0.0, 0.25, 0.0);
                matrices.scale(1.02f, 1.02f, 1.02f);
                matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
                renderCall.accept(matrices);
            }
        }), Map.entry("belt", new RenderHelper(){

            @Override
            public <S extends LivingEntityRenderState> void render(ItemStack stack, SlotPath path, PoseStack matrices, HumanoidModel<? extends HumanoidRenderState> humanoidModel, S renderState, Consumer<PoseStack> renderCall) {
                ModelTransformOps.transformToFace(matrices, renderState, humanoidModel, "body", Side.BOTTOM);
                matrices.scale(1.01f, 1.01f, 1.01f);
                renderCall.accept(matrices);
            }
        }), Map.entry("anklet", new RenderHelper(){

            @Override
            public <S extends LivingEntityRenderState> void render(ItemStack stack, SlotPath path, PoseStack matrices, HumanoidModel<? extends HumanoidRenderState> humanoidModel, S renderState, Consumer<PoseStack> renderCall) {
                String modelTarget = path.index() % 2 == 0 ? "right_leg" : "left_leg";
                ModelTransformOps.transformToModelPart(matrices, renderState, humanoidModel, modelTarget, 0, -0.5, 0);
                matrices.scale(1.01f, 1.01f, 1.01f);
                renderCall.accept(matrices);
            }
        }), Map.entry("shoes", new RenderHelper(){

            @Override
            public <S extends LivingEntityRenderState> void render(ItemStack stack, SlotPath path, PoseStack matrices, HumanoidModel<? extends HumanoidRenderState> humanoidModel, S renderState, Consumer<PoseStack> renderCall) {
                matrices.pushPose();
                ModelTransformOps.transformToFace(matrices, renderState, humanoidModel, "right_leg", Side.BOTTOM);
                matrices.translate(0.0, 0.25, 0.0);
                matrices.scale(1.02f, 1.02f, 1.02f);
                renderCall.accept(matrices);
                matrices.popPose();
                matrices.pushPose();
                ModelTransformOps.transformToFace(matrices, renderState, humanoidModel, "left_leg", Side.BOTTOM);
                matrices.translate(0.0, 0.25, 0.0);
                matrices.scale(1.02f, 1.02f, 1.02f);
                renderCall.accept(matrices);
                matrices.popPose();
            }
        }));
        INSTANCE = new DefaultAccessoryRenderer();
    }

    public static interface RenderHelper {
        public <S extends LivingEntityRenderState> void render(ItemStack var1, SlotPath var2, PoseStack var3, HumanoidModel<? extends HumanoidRenderState> var4, S var5, Consumer<PoseStack> var6);
    }
}

