/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import io.wispforest.accessories.api.client.AccessoriesRenderStateKeys;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.client.AccessoryRenderState;
import io.wispforest.accessories.api.client.renderers.AccessoryRenderer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.ItemStack;

public interface SimpleAccessoryRenderer
extends AccessoryRenderer {
    @Override
    default public <S extends LivingEntityRenderState> void render(AccessoryRenderState accessoryState, S entityState, EntityModel<S> model, PoseStack matrices, SubmitNodeCollector collector) {
        ItemStackRenderState stackRenderState = accessoryState.getStateData(AccessoriesRenderStateKeys.ITEM_STACK_STATE);
        if (stackRenderState == null) {
            throw new NullPointerException("Unable to get the required ItemStack render state to render a SimpleAccessoryRenderer: " + String.valueOf(AccessoriesRendererRegistry.getRendererId(this)));
        }
        this.align(accessoryState, entityState, model, matrices);
        Integer light = (Integer)entityState.getStateData(AccessoriesRenderStateKeys.LIGHT);
        ItemStack stack = accessoryState.getStateData(AccessoriesRenderStateKeys.ITEM_STACK);
        this.renderStack(accessoryState, entityState, model, matrices, collector, stack, stackRenderState, light);
    }

    default public <S extends LivingEntityRenderState> void renderStack(AccessoryRenderState accessoryState, S entityState, EntityModel<S> model, PoseStack matrices, SubmitNodeCollector collector, ItemStack stack, ItemStackRenderState stackRenderState, int light) {
        stackRenderState.submit(matrices, collector, ((Integer)entityState.getStateData(AccessoriesRenderStateKeys.LIGHT)).intValue(), OverlayTexture.NO_OVERLAY, 0);
    }

    @Override
    default public boolean shouldCreateStackRenderState() {
        return true;
    }

    public <S extends LivingEntityRenderState> void align(AccessoryRenderState var1, S var2, EntityModel<S> var3, PoseStack var4);
}

