/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.components;

import com.mojang.serialization.Codec;
import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.serialization.CodecUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public final class AccessoryMobEffectsComponent {
    public static final AccessoryMobEffectsComponent EMPTY = new AccessoryMobEffectsComponent(new ArrayList<MobEffectInstance>(), new HashMap<Integer, List<MobEffectInstance>>());
    private static final Endec<List<MobEffectInstance>> MOB_EFFECT_INSTANCES = CodecUtils.toEndecWithRegistries((Codec)MobEffectInstance.CODEC, (StreamCodec)MobEffectInstance.STREAM_CODEC).listOf();
    private static final Endec<Map<Integer, List<MobEffectInstance>>> MAP_ENDEC = StructEndecBuilder.of((StructField)Endec.INT.fieldOf("delay", Map.Entry::getKey), (StructField)MOB_EFFECT_INSTANCES.fieldOf("effect_instances", Map.Entry::getValue), Map::entry).listOf().xmap(entries -> entries.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (instances1, instances2) -> {
        ArrayList list = new ArrayList(instances1);
        list.addAll(instances2);
        return list;
    }, LinkedHashMap::new)), kvMap -> List.copyOf(kvMap.entrySet()));
    public static Endec<AccessoryMobEffectsComponent> ENDEC = StructEndecBuilder.of((StructField)MOB_EFFECT_INSTANCES.fieldOf("constant_effects", AccessoryMobEffectsComponent::constantMobEffects), (StructField)MAP_ENDEC.fieldOf("delayed_effects", AccessoryMobEffectsComponent::delayedMobEffects), AccessoryMobEffectsComponent::new);
    private final List<MobEffectInstance> constantMobEffects;
    private final Map<Integer, List<MobEffectInstance>> delayedMobEffects;
    private final Map<Integer, Long> delayToTimer = new HashMap<Integer, Long>();

    public AccessoryMobEffectsComponent(List<MobEffectInstance> constantMobEffects, Map<Integer, List<MobEffectInstance>> mobEffects) {
        this.constantMobEffects = constantMobEffects;
        this.delayedMobEffects = mobEffects;
    }

    public List<MobEffectInstance> constantMobEffects() {
        return Collections.unmodifiableList(this.constantMobEffects);
    }

    public Map<Integer, List<MobEffectInstance>> delayedMobEffects() {
        return Collections.unmodifiableMap(this.delayedMobEffects);
    }

    public AccessoryMobEffectsComponent addEffect(MobEffectInstance instance) {
        ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>(this.constantMobEffects);
        effects.add(instance);
        return new AccessoryMobEffectsComponent(effects, this.delayedMobEffects);
    }

    public AccessoryMobEffectsComponent addEffect(MobEffectInstance instance, int applyDelay) {
        HashMap<Integer, List<MobEffectInstance>> map = new HashMap<Integer, List<MobEffectInstance>>(this.delayedMobEffects);
        map.computeIfAbsent(applyDelay, integer -> new ArrayList()).add(instance);
        return new AccessoryMobEffectsComponent(this.constantMobEffects, map);
    }

    public void handleApplyingConstantEffects(LivingEntity livingEntity) {
        for (MobEffectInstance constantMobEffect : this.constantMobEffects) {
            livingEntity.addEffect(constantMobEffect);
        }
    }

    public void handleReapplyingEffects(LivingEntity livingEntity, long time) {
        for (Integer i : this.delayedMobEffects.keySet()) {
            Long lastApply = this.delayToTimer.getOrDefault(i, null);
            if (lastApply == null || time - lastApply > (long)i.intValue()) {
                for (MobEffectInstance mobEffectInstance : this.delayedMobEffects.get(i)) {
                    livingEntity.addEffect(mobEffectInstance);
                }
            }
            this.delayToTimer.put(i, time);
        }
    }

    public void handleRemovingEffects(LivingEntity livingEntity) {
        for (List<MobEffectInstance> value : this.delayedMobEffects.values()) {
            for (MobEffectInstance mobEffectInstance : value) {
                livingEntity.removeEffect(mobEffectInstance.getEffect());
            }
        }
        for (MobEffectInstance mobEffectInstance : this.constantMobEffects) {
            livingEntity.removeEffect(mobEffectInstance.getEffect());
        }
        this.delayToTimer.clear();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AccessoryMobEffectsComponent that = (AccessoryMobEffectsComponent)obj;
        return Objects.equals(this.delayedMobEffects, that.delayedMobEffects);
    }

    public int hashCode() {
        return Objects.hash(this.delayedMobEffects);
    }

    public String toString() {
        return "AccessoryMobEffectsComponent[mobEffects=" + String.valueOf(this.delayedMobEffects) + "]";
    }
}

