/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.components;

import com.mojang.serialization.Codec;
import io.wispforest.accessories.api.core.Accessory;
import io.wispforest.accessories.api.core.AccessoryRegistry;
import io.wispforest.accessories.api.events.SlotStateChange;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotPath;
import io.wispforest.accessories.api.slot.SlotPathWithStack;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.serialization.CodecUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.world.item.ItemStack;

public final class AccessoryNestContainerContents {
    public static final AccessoryNestContainerContents EMPTY = new AccessoryNestContainerContents(List.of());
    public static final Endec<AccessoryNestContainerContents> ENDEC = StructEndecBuilder.of((StructField)CodecUtils.toEndec((Codec)ItemStack.OPTIONAL_CODEC).listOf().fieldOf("accessories", AccessoryNestContainerContents::accessories), AccessoryNestContainerContents::new);
    private final List<ItemStack> accessories;
    private final Map<Integer, SlotStateChange> slotChanges = new Int2ObjectOpenHashMap();

    public AccessoryNestContainerContents(List<ItemStack> accessories) {
        this.accessories = accessories;
    }

    public AccessoryNestContainerContents setStack(int index, ItemStack stack) {
        ArrayList<ItemStack> accessories = new ArrayList<ItemStack>(this.accessories());
        accessories.set(index, stack);
        AccessoryNestContainerContents contents = new AccessoryNestContainerContents(accessories);
        contents.slotChanges.putAll(this.slotChanges);
        contents.slotChanges.put(index, SlotStateChange.REPLACEMENT);
        return contents;
    }

    public AccessoryNestContainerContents addStack(ItemStack stack) {
        ArrayList<ItemStack> accessories = new ArrayList<ItemStack>(this.accessories());
        int index = accessories.size();
        accessories.add(stack);
        AccessoryNestContainerContents contents = new AccessoryNestContainerContents(accessories);
        contents.slotChanges.putAll(this.slotChanges);
        contents.slotChanges.put(index, SlotStateChange.REPLACEMENT);
        return contents;
    }

    public Map<Integer, SlotStateChange> slotChanges() {
        return this.slotChanges;
    }

    public Map<ItemStack, Accessory> getMap() {
        LinkedHashMap<ItemStack, Accessory> map = new LinkedHashMap<ItemStack, Accessory>();
        this.accessories().forEach(stack1 -> map.put((ItemStack)stack1, AccessoryRegistry.getAccessoryOrDefault(stack1)));
        return map;
    }

    public Map<SlotEntryReference, Accessory> getMap(SlotReference slotReference) {
        LinkedHashMap<SlotEntryReference, Accessory> map = new LinkedHashMap<SlotEntryReference, Accessory>();
        List<ItemStack> innerStacks = this.accessories();
        for (int i = 0; i < innerStacks.size(); ++i) {
            ItemStack innerStack = innerStacks.get(i);
            if (innerStack.isEmpty()) continue;
            map.put(new SlotEntryReference(SlotPath.cloneWithInnerIndex(slotReference, i), innerStack), AccessoryRegistry.getAccessoryOrDefault(innerStack));
        }
        return map;
    }

    public Map<SlotPathWithStack, Accessory> getMapWithPaths(SlotPath slotPath) {
        LinkedHashMap<SlotPathWithStack, Accessory> map = new LinkedHashMap<SlotPathWithStack, Accessory>();
        List<ItemStack> innerStacks = this.accessories();
        for (int i = 0; i < innerStacks.size(); ++i) {
            ItemStack innerStack = innerStacks.get(i);
            if (innerStack.isEmpty()) continue;
            map.put(SlotPathWithStack.of(SlotPath.cloneWithInnerIndex(slotPath, i), innerStack), AccessoryRegistry.getAccessoryOrDefault(innerStack));
        }
        return map;
    }

    public List<ItemStack> accessories() {
        return this.accessories;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AccessoryNestContainerContents that = (AccessoryNestContainerContents)obj;
        return Objects.equals(this.accessories, that.accessories);
    }

    public int hashCode() {
        return Objects.hash(this.accessories);
    }

    public String toString() {
        return "AccessoryNestContainerContents[accessories=" + String.valueOf(this.accessories) + "]";
    }
}

