/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.core;

import io.wispforest.accessories.api.SoundEventData;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryItemAttributeModifiers;
import io.wispforest.accessories.api.components.AccessoryStackSettings;
import io.wispforest.accessories.api.events.DropRule;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.mixin.LivingEntityAccessor;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.equipment.Equippable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.Nullable;

public interface Accessory {
    default public void tick(ItemStack stack, SlotReference reference) {
    }

    default public void onEquip(ItemStack stack, SlotReference reference) {
    }

    default public void onUnequip(ItemStack stack, SlotReference reference) {
    }

    default public boolean canEquip(ItemStack stack, SlotReference reference) {
        return true;
    }

    @MustBeInvokedByOverriders
    default public boolean canUnequip(ItemStack stack, SlotReference reference) {
        if (EnchantmentHelper.has((ItemStack)stack, (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE)) {
            Player player;
            LivingEntity livingEntity = reference.entity();
            return livingEntity instanceof Player && (player = (Player)livingEntity).isCreative();
        }
        return true;
    }

    default public void getDynamicModifiers(ItemStack stack, SlotReference reference, AccessoryAttributeBuilder builder) {
        this.getModifiers(stack, reference, builder);
    }

    default public void getStaticModifiers(Item item, AccessoryItemAttributeModifiers.Builder builder) {
    }

    @MustBeInvokedByOverriders
    default public DropRule getDropRule(ItemStack stack, SlotReference reference, DamageSource source) {
        return ((AccessoryStackSettings)stack.getOrDefault(AccessoriesDataComponents.STACK_SETTINGS, (Object)AccessoryStackSettings.DEFAULT)).dropRule();
    }

    @MustBeInvokedByOverriders
    default public void onEquipFromUse(ItemStack stack, SlotReference reference) {
        SoundEventData sound = this.getEquipSound(stack, reference);
        if (sound == null) {
            return;
        }
        reference.entity().playSound((SoundEvent)sound.event().value(), sound.volume(), sound.pitch());
    }

    @Nullable
    default public SoundEventData getEquipSound(ItemStack stack, SlotReference reference) {
        Holder equipSound = stack.has(DataComponents.EQUIPPABLE) ? ((Equippable)stack.get(DataComponents.EQUIPPABLE)).equipSound() : SoundEvents.ARMOR_EQUIP_GENERIC;
        return new SoundEventData((Holder<SoundEvent>)equipSound, 1.0f, 1.0f);
    }

    @Deprecated(forRemoval=true)
    default public boolean canEquipFromUse(ItemStack stack) {
        try {
            return this.canEquipFromUse(stack, null);
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    @MustBeInvokedByOverriders
    default public boolean canEquipFromUse(ItemStack stack, SlotReference reference) {
        if (stack.has(AccessoriesDataComponents.STACK_SETTINGS)) {
            return ((AccessoryStackSettings)stack.get(AccessoriesDataComponents.STACK_SETTINGS)).canEquipFromUse();
        }
        if (stack.has(DataComponents.EQUIPPABLE)) {
            return ((Equippable)stack.get(DataComponents.EQUIPPABLE)).swappable();
        }
        return true;
    }

    default public boolean canEquipFromDispenser(ItemStack stack, SlotReference reference) {
        if (stack.has(AccessoriesDataComponents.STACK_SETTINGS)) {
            return ((AccessoryStackSettings)stack.get(AccessoriesDataComponents.STACK_SETTINGS)).canEquipFromDispenser();
        }
        if (stack.has(DataComponents.EQUIPPABLE)) {
            return ((Equippable)stack.get(DataComponents.EQUIPPABLE)).dispensable();
        }
        return true;
    }

    default public void onBreak(ItemStack stack, SlotReference reference) {
        ((LivingEntityAccessor)reference.entity()).accessors$breakItem(stack);
    }

    default public int maxStackSize(ItemStack stack) {
        AccessoryStackSettings data = (AccessoryStackSettings)stack.getOrDefault(AccessoriesDataComponents.STACK_SETTINGS, (Object)AccessoryStackSettings.DEFAULT);
        if (data.useStackSize()) {
            return stack.getMaxStackSize();
        }
        return Math.min(Math.max(data.sizeOverride(), 1), stack.getMaxStackSize());
    }

    default public void getAttributesTooltip(ItemStack stack, SlotType type, List<Component> tooltips, Item.TooltipContext tooltipContext, TooltipFlag tooltipType) {
        this.getAttributesTooltip(stack, type, tooltips);
        Component component = ((AccessoryStackSettings)stack.getOrDefault(AccessoriesDataComponents.STACK_SETTINGS, (Object)AccessoryStackSettings.DEFAULT)).slotBasedTooltips().get(type.name());
        if (component != null && !component.equals((Object)CommonComponents.EMPTY)) {
            tooltips.add(component);
        }
    }

    default public void getExtraTooltip(ItemStack stack, List<Component> tooltips, Item.TooltipContext tooltipContext, TooltipFlag tooltipType) {
        this.getExtraTooltip(stack, tooltips);
        Component component = ((AccessoryStackSettings)stack.getOrDefault(AccessoriesDataComponents.STACK_SETTINGS, (Object)AccessoryStackSettings.DEFAULT)).extraTooltip();
        if (!component.equals((Object)CommonComponents.EMPTY)) {
            tooltips.add(component);
        }
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.22")
    default public void getModifiers(ItemStack stack, SlotReference reference, AccessoryAttributeBuilder builder) {
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.22")
    default public void getAttributesTooltip(ItemStack stack, SlotType type, List<Component> tooltips) {
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.22")
    default public void getExtraTooltip(ItemStack stack, List<Component> tooltips) {
    }
}

