/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.slot;

import io.netty.buffer.ByteBuf;
import io.wispforest.accessories.api.slot.SlotPath;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.endec.Deserializer;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.Serializer;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.format.bytebuf.ByteBufDeserializer;
import io.wispforest.endec.format.bytebuf.ByteBufSerializer;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.ApiStatus;

public class SlotReferenceEncoding {
    private static final Endec<LivingEntity> LIVING_ENTITY_ENDEC = Endec.VAR_INT.xmapWithContext((ctx, id) -> {
        Level level = ((LevelAttribute)ctx.requireAttributeValue(LevelAttribute.LEVEL)).level();
        Entity entity = level.getEntity(id.intValue());
        if (entity == null) {
            throw new IllegalStateException("Unable to locate the given entity with the following ID with the passed level! [Id: " + id + " , Level: " + String.valueOf(level.dimension()) + " ]");
        }
        if (!(entity instanceof LivingEntity)) {
            throw new IllegalStateException("Given entity found within the world was not of LivingEntity! [Id: " + id + ", EntityType: " + String.valueOf(entity.getType()) + ", Level: " + String.valueOf(level.dimension()) + " ]");
        }
        LivingEntity living = (LivingEntity)entity;
        return living;
    }, (context, entity) -> entity.getId());
    @ApiStatus.Experimental
    public static final StructEndec<SlotReference> ENDEC = StructEndecBuilder.of((StructField)LIVING_ENTITY_ENDEC.fieldOf("entity", SlotReference::entity), (StructField)SlotPath.ENDEC.flatFieldOf(SlotReference::slotPath), SlotReference::of);

    public static ByteBuf encodeReference(ByteBuf byteBuf, SlotReference slotReference) {
        ENDEC.encode(SerializationContext.empty(), (Serializer)ByteBufSerializer.of((ByteBuf)byteBuf), (Object)slotReference);
        return byteBuf;
    }

    public static SlotReference decodeReference(ByteBuf byteBuf, Level level) {
        return (SlotReference)ENDEC.decode(SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{new LevelAttribute(level)}), (Deserializer)ByteBufDeserializer.of((ByteBuf)byteBuf));
    }

    @ApiStatus.Experimental
    public record LevelAttribute(Level level) implements SerializationAttribute.Instance
    {
        public static final SerializationAttribute.WithValue<LevelAttribute> LEVEL = SerializationAttribute.withValue((String)"current_minecraft_level");

        public SerializationAttribute attribute() {
            return LEVEL;
        }

        public Object value() {
            return this;
        }
    }
}

