/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.client;

import com.mojang.blaze3d.vertex.PoseStack;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.client.AccessoriesRenderStateKeys;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.client.AccessoryRenderState;
import io.wispforest.accessories.api.client.renderers.AccessoryRenderer;
import io.wispforest.accessories.api.slot.SlotPath;
import io.wispforest.accessories.client.AccessoriesFunkyRenderingState;
import io.wispforest.accessories.client.AccessoryRendererErrorCache;
import io.wispforest.accessories.client.gui.AccessoriesScreenBase;
import io.wispforest.accessories.compat.config.AccessoriesConfig;
import io.wispforest.accessories.menu.AccessoriesInternalSlot;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.AvatarRenderer;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.joml.Vector3d;

public class AccessoriesRenderLayer<S extends LivingEntityRenderState, M extends EntityModel<S>>
extends RenderLayer<S, M> {
    private static final float increment = 0.1f;
    private static final Map<SlotPath, Float> brightnessMap = new HashMap<SlotPath, Float>();
    private static final Map<SlotPath, Float> opacityMap = new HashMap<SlotPath, Float>();
    private static long lastUpdated20th = 0L;

    public AccessoriesRenderLayer(RenderLayerParent<S, M> renderLayerParent) {
        super(renderLayerParent);
    }

    public void submit(PoseStack poseStack, SubmitNodeCollector submitNodeCollector, int light, S entityState, float f, float g) {
        AccessoriesInternalSlot accessoriesInternalSlot;
        Screen screen;
        boolean shouldUpdate;
        Minecraft client = Minecraft.getInstance();
        Map states = (Map)entityState.getStateData(AccessoriesRenderStateKeys.ACCESSORY_RENDER_STATES);
        if (states == null) {
            return;
        }
        entityState.setStateData(AccessoriesRenderStateKeys.LIGHT, (Object)light);
        AccessoriesFunkyRenderingState funkyRenderState = AccessoriesFunkyRenderingState.INSTANCE;
        boolean isRenderingLineTarget = funkyRenderState.isIsRenderingLineTarget();
        boolean renderingLines = funkyRenderState.isCollectAccessoryPositions();
        Map<SlotPath, Vector3d> positions = funkyRenderState.getNotVeryNicePositions();
        if (!renderingLines && !positions.isEmpty()) {
            positions.clear();
        }
        float scale = (float)(1.0 + 0.5 * (0.75 + Math.sin((double)System.currentTimeMillis() / 250.0)));
        Calendar calendar = Calendar.getInstance();
        long current20th = calendar.getTimeInMillis() / 50L;
        boolean bl = shouldUpdate = lastUpdated20th != current20th;
        if (shouldUpdate) {
            lastUpdated20th = current20th;
        }
        if ((screen = client.screen) instanceof AccessoriesScreenBase) {
            AccessoriesScreenBase screenBase = (AccessoriesScreenBase)screen;
            accessoriesInternalSlot = screenBase.getSelectedSlotIf(AccessoriesInternalSlot.class);
        } else {
            accessoriesInternalSlot = null;
        }
        AccessoriesInternalSlot selected = accessoriesInternalSlot;
        boolean preventHovering = selected != null && selected.getItem().isEmpty();
        AccessoriesConfig.ScreenOptions_.UnHoveredOptions_ unHoveredOptions = Accessories.config().screenOptions.unHoveredOptions;
        AccessoriesConfig.ScreenOptions_.HoveredOptions_ hoveredOptions = Accessories.config().screenOptions.hoveredOptions;
        boolean isFunnyDate = calendar.get(2) + 1 == 5 && calendar.get(5) == 16;
        SlotPath selectedPath = selected != null ? selected.slotPath() : null;
        states.forEach((path, accessoryRenderState) -> {
            boolean isSelected = path.equals(selectedPath);
            if (shouldUpdate) {
                Float currentBrightness = brightnessMap.getOrDefault(path, Float.valueOf(1.0f));
                Float currentOpacity = opacityMap.getOrDefault(path, Float.valueOf(1.0f));
                if (selectedPath != null && !isSelected && !preventHovering) {
                    brightnessMap.put((SlotPath)path, Float.valueOf(Math.max(unHoveredOptions.darkenedBrightness(), currentBrightness.floatValue() - 0.1f)));
                    opacityMap.put((SlotPath)path, Float.valueOf(Math.max(unHoveredOptions.darkenedOpacity(), currentOpacity.floatValue() - 0.1f)));
                } else {
                    brightnessMap.put((SlotPath)path, Float.valueOf(Math.min(1.0f, currentBrightness.floatValue() + 0.1f)));
                    opacityMap.put((SlotPath)path, Float.valueOf(Math.min(1.0f, currentOpacity.floatValue() + 0.1f)));
                }
            }
            ItemStack stack = accessoryRenderState.getStateData(AccessoriesRenderStateKeys.ITEM_STACK);
            AccessoryRenderer renderer = AccessoriesRendererRegistry.getRenderer(stack);
            if (isSelected || selectedPath == null || unHoveredOptions.renderUnHovered()) {
                poseStack.pushPose();
                try {
                    renderer.render((AccessoryRenderState)accessoryRenderState, entityState, this.getParentModel(), poseStack, submitNodeCollector);
                }
                catch (Throwable e) {
                    AccessoryRendererErrorCache.logIfTimeAllotted(entityState.getEntityUUIDForState(), stack, renderer, e);
                }
                poseStack.popPose();
            }
        });
    }

    public static <A extends Avatar> void submitFirstPersonAsClientPlayer(AvatarRenderer<A> avatarRender, HumanoidModel<AvatarRenderState> model, PoseStack matrices, int combinedLight, SubmitNodeCollector submitNodeCollector, HumanoidArm arm) {
        LocalPlayer player = Minecraft.getInstance().player;
        AccessoriesRenderLayer.submitFirstPerson(player, avatarRender, model, matrices, combinedLight, submitNodeCollector, arm);
    }

    public static <A extends Avatar> void submitFirstPerson(A entity, AvatarRenderer<A> avatarRender, HumanoidModel<AvatarRenderState> model, PoseStack matrices, int combinedLight, SubmitNodeCollector submitNodeCollector, HumanoidArm arm) {
        Level level = entity.level();
        float partialTicks = Minecraft.getInstance().getDeltaTracker().getGameTimeDeltaPartialTick(!level.tickRateManager().isEntityFrozen(entity));
        AvatarRenderState entityState = (AvatarRenderState)avatarRender.createRenderState(entity, partialTicks);
        entityState.setStateData(AccessoriesRenderStateKeys.LIGHT, (Object)combinedLight);
        AccessoriesRenderStateKeys.setupStateForAccessories((EntityRenderState)entityState, entity, partialTicks, arm);
        Map states = (Map)entityState.getStateData(AccessoriesRenderStateKeys.ACCESSORY_RENDER_STATES);
        if (states == null) {
            return;
        }
        states.forEach((slotPath, accessoryRenderState) -> {
            matrices.pushPose();
            ItemStack stack = accessoryRenderState.getStateData(AccessoriesRenderStateKeys.ITEM_STACK);
            AccessoryRenderer renderer = AccessoriesRendererRegistry.getRenderer(stack);
            try {
                renderer.render((AccessoryRenderState)accessoryRenderState, entityState, model, matrices, submitNodeCollector);
            }
            catch (Throwable e) {
                AccessoryRendererErrorCache.logIfTimeAllotted(entityState.getEntityUUIDForState(), stack, renderer, e);
            }
            matrices.popPose();
        });
    }
}

