/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.client;

import io.wispforest.accessories.client.AccessoriesPipelines;
import io.wispforest.accessories.client.BlitSpectrumRenderState;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.OwoUIPipelines;
import io.wispforest.owo.ui.renderstate.GradientQuadElementRenderState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.data.AtlasIds;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import org.joml.Vector4f;

public class DrawUtils {
    public static void drawWithSpectrum(GuiGraphics ctx, int x, int y, int blitOffset, int width, int height, ResourceLocation texture, float alpha) {
        TextureAtlasSprite sprite = Minecraft.getInstance().getAtlasManager().getAtlasOrThrow(AtlasIds.GUI).getSprite(texture);
        DrawUtils.innerDrawWithSpectrum(ctx, sprite.atlasLocation(), x, x + width, y, y + height, blitOffset, sprite.getU0(), sprite.getU1(), sprite.getV0(), sprite.getV1(), new Vector4f(alpha));
    }

    public static void drawWithSpectrum(GuiGraphics ctx, int x, int y, int blitOffset, int width, int height, TextureAtlasSprite sprite, float alpha) {
        DrawUtils.innerDrawWithSpectrum(ctx, sprite.atlasLocation(), x, x + width, y, y + height, blitOffset, sprite.getU0(), sprite.getU1(), sprite.getV0(), sprite.getV1(), new Vector4f(alpha));
    }

    public static void drawWithSpectrum(GuiGraphics ctx, int x, int y, int blitOffset, int width, int height, TextureAtlasSprite sprite, Vector4f alphaValues) {
        DrawUtils.innerDrawWithSpectrum(ctx, sprite.atlasLocation(), x, x + width, y, y + height, blitOffset, sprite.getU0(), sprite.getU1(), sprite.getV0(), sprite.getV1(), alphaValues);
    }

    private static void innerDrawWithSpectrum(GuiGraphics guiGraphics, ResourceLocation atlasLocation, int x1, int x2, int y1, int y2, int blitOffset, float minU, float maxU, float minV, float maxV, Vector4f alphaValues) {
        guiGraphics.guiRenderState.submitGuiElement((GuiElementRenderState)new BlitSpectrumRenderState(AccessoriesPipelines.SPECTRUM, TextureSetup.noTexture(), new Matrix3x2f((Matrix3x2fc)guiGraphics.pose()), x1, y1, x2, y2, minU, maxU, minV, maxV, alphaValues, guiGraphics.scissorStack.peek()));
    }

    public static void drawRectOutlineWithSpectrum(OwoUIDrawContext ctx, int x, int y, int width, int height, float alpha, boolean vertical) {
        DrawUtils.innerFill((GuiGraphics)ctx, x, y, width, 1, alpha, !vertical);
        DrawUtils.innerFill((GuiGraphics)ctx, x, y + height - 1, width, 1, alpha, !vertical);
        DrawUtils.innerFill((GuiGraphics)ctx, x, y + 1, 1, height - 2, alpha, vertical);
        DrawUtils.innerFill((GuiGraphics)ctx, x + width - 1, y + 1, 1, height - 2, alpha, vertical);
    }

    private static void innerFill(GuiGraphics guiGraphics, int x, int y, int width, int height, float alpha, boolean vertical) {
        float topValue;
        float multiplier = (float)((double)System.currentTimeMillis() / 20.0 % 360.0 / 360.0);
        float bottomValue = topValue = 1.0f - multiplier;
        Matrix3x2f matrix = new Matrix3x2f((Matrix3x2fc)guiGraphics.pose());
        ScreenRectangle scissorRect = guiGraphics.scissorStack.peek();
        guiGraphics.guiRenderState.submitGuiElement((GuiElementRenderState)new GradientQuadElementRenderState(OwoUIPipelines.GUI_HSV, matrix, new ScreenRectangle(x, y, width, height).transformMaxBounds(matrix), scissorRect, new Color(topValue, 1.0f, 1.0f, alpha), new Color(bottomValue, 1.0f, 1.0f, alpha), new Color(vertical ? bottomValue : topValue, 1.0f, 1.0f, alpha), new Color(vertical ? topValue : bottomValue, 1.0f, 1.0f, alpha)));
    }

    private static ScreenRectangle getBounds(int x1, int y1, int x2, int y2, Matrix3x2f matrix3x2f) {
        return new ScreenRectangle(x1, y1, Math.abs(x2 - x1), Math.abs(y2 - y1));
    }

    public static void blitSprite(GuiGraphics context, ResourceLocation atlasLocation, int x, int y, int width, int height) {
        DrawUtils.blitSprite(context, atlasLocation, x, y, width, height, -1);
    }

    public static void blitSprite(GuiGraphics context, ResourceLocation atlasLocation, int x, int y, int width, int height, int blitOffset) {
        context.blitSprite(RenderPipelines.GUI_TEXTURED, atlasLocation, x, y, width, height, blitOffset);
    }

    public static void blit(GuiGraphics context, ResourceLocation atlasLocation, int x, int y, int width, int height) {
        DrawUtils.blit(context, atlasLocation, x, y, 0.0f, 0.0f, width, height, width, height);
    }

    public static void blit(GuiGraphics context, ResourceLocation atlasLocation, int x, int y, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        DrawUtils.blit(context, atlasLocation, x, y, 0.0f, 0.0f, uWidth, vHeight, textureWidth, textureHeight);
    }

    public static void blit(GuiGraphics context, ResourceLocation atlasLocation, int x, int y, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        context.blit(RenderPipelines.GUI_TEXTURED, atlasLocation, x, y, uOffset, vOffset, uWidth, vHeight, uWidth, vHeight, textureWidth, textureHeight);
    }

    public static void blit(GuiGraphics context, ResourceLocation atlasLocation, int x, int y, float uOffset, float vOffset, int uWidth, int vHeight, int width, int height, int textureWidth, int textureHeight) {
        context.blit(RenderPipelines.GUI_TEXTURED, atlasLocation, x, y, uOffset, vOffset, uWidth, vHeight, width, height, textureWidth, textureHeight, -1);
    }

    public static void blitSpriteWithColor(GuiGraphics context, TextureAtlasSprite sprite, int x, int y, int width, int height, Color color) {
        context.blitSprite(RenderPipelines.GUI_TEXTURED, sprite, x, y, width, height, color.argb());
    }
}

