/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.client.gui;

import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.client.screen.AccessoriesScreenTransitionHelper;
import io.wispforest.accessories.api.menu.AccessoriesBasedSlot;
import io.wispforest.accessories.api.slot.SlotGroup;
import io.wispforest.accessories.api.slot.SlotPath;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.api.slot.UniqueSlotHandling;
import io.wispforest.accessories.client.AccessoriesClient;
import io.wispforest.accessories.client.AccessoriesFunkyRenderingState;
import io.wispforest.accessories.client.DrawUtils;
import io.wispforest.accessories.client.gui.AccessoriesScreenBase;
import io.wispforest.accessories.client.gui.components.AccessoriesContainingLayout;
import io.wispforest.accessories.client.gui.components.AccessoriesScreenSettingsLayout;
import io.wispforest.accessories.client.gui.components.ComponentUtils;
import io.wispforest.accessories.client.gui.components.ExtendedScrollContainer;
import io.wispforest.accessories.client.gui.components.InventoryEntityComponent;
import io.wispforest.accessories.client.gui.components.PaginatedAccessoriesLayout;
import io.wispforest.accessories.client.gui.components.ScrollableAccessoriesLayout;
import io.wispforest.accessories.client.gui.utils.Line3d;
import io.wispforest.accessories.data.SlotGroupLoader;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.impl.option.AccessoriesPlayerOptionsHolder;
import io.wispforest.accessories.impl.option.PlayerOption;
import io.wispforest.accessories.impl.option.PlayerOptions;
import io.wispforest.accessories.impl.option.PlayerOptionsAccess;
import io.wispforest.accessories.impl.slot.ExtraSlotTypeProperties;
import io.wispforest.accessories.menu.AccessoriesInternalSlot;
import io.wispforest.accessories.menu.ArmorSlotTypes;
import io.wispforest.accessories.menu.SlotTypeAccessible;
import io.wispforest.accessories.menu.networking.ToggledSlots;
import io.wispforest.accessories.menu.variants.AccessoriesMenu;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.accessories.networking.holder.SyncOptionChange;
import io.wispforest.accessories.pond.ContainerScreenExtension;
import io.wispforest.owo.mixin.ui.SlotAccessor;
import io.wispforest.owo.ui.base.BaseOwoHandledScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.container.StackLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.PositionedRectangle;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import io.wispforest.owo.util.pond.OwoSlotExtension;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ErrorScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ArmorSlot;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.slf4j.Logger;

public class AccessoriesScreen
extends BaseOwoHandledScreen<FlowLayout, AccessoriesMenu>
implements AccessoriesScreenBase<AccessoriesMenu>,
ContainerScreenExtension,
PlayerOptionsAccess {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    private final AbstractContainerScreen<AbstractContainerMenu> prevScreen;
    private boolean rebuildComponentRectangles = true;
    private List<PositionedRectangle> componentRectangles = List.of();
    private final Map<Integer, Boolean> changedSlots = new HashMap<Integer, Boolean>();
    private final List<Vector3d> hoveredAccessoryPositons = new ArrayList<Vector3d>();
    private final List<Line3d> linesToAccessoryPositions = new ArrayList<Line3d>();
    @Nullable
    private AccessoriesContainingLayout<?> topComponent = null;
    @Nullable
    private ExtendedScrollContainer groupFilterScrollable = null;
    @Nullable
    private AccessoriesScreenSettingsLayout settingsLayout = null;

    public AccessoriesScreen(AccessoriesMenu handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        AbstractContainerScreen prevScreen;
        Screen screen = Minecraft.getInstance().screen;
        this.prevScreen = screen instanceof AbstractContainerScreen ? (prevScreen = (AbstractContainerScreen)screen) : null;
        this.inventoryLabelX = 42069;
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((Screen)this, Containers::verticalFlow);
    }

    protected FlowLayout rootComponent() {
        return (FlowLayout)this.uiAdapter.rootComponent;
    }

    public List<PositionedRectangle> getComponentRectangles() {
        if (this.rebuildComponentRectangles) {
            ArrayDeque unpackRules = new ArrayDeque();
            unpackRules.push(List.of());
            unpackRules.push(List.of(Pair.of((Object)false, (Object)"armor_entity_layout"), Pair.of((Object)true, (Object)"bottom_inventory_section")));
            unpackRules.push(List.of(Pair.of((Object)false, (Object)"outer_accessories_layout")));
            Stream<Object> stream = this.rootComponent().children().stream();
            while (!unpackRules.isEmpty()) {
                List ids = (List)unpackRules.pollLast();
                stream = stream.flatMap(component -> {
                    if (component instanceof ParentComponent) {
                        ParentComponent parent = (ParentComponent)component;
                        if (ids.isEmpty()) {
                            return parent.children().stream();
                        }
                        if (parent.id() != null) {
                            for (Pair pair : ids) {
                                if (!((String)pair.right()).equals(parent.id())) continue;
                                Stream<Object> componentStream = parent.children().stream();
                                if (((Boolean)pair.left()).booleanValue()) {
                                    componentStream = Stream.concat(componentStream, Stream.of(parent));
                                }
                                return componentStream;
                            }
                        }
                    }
                    return Stream.of(component);
                });
            }
            this.componentRectangles = stream.map(component -> component).toList();
            this.rebuildComponentRectangles = false;
        }
        return this.componentRectangles;
    }

    public <C extends io.wispforest.owo.ui.core.Component> C component(Class<C> expectedClass, String id) {
        return (C)super.component(expectedClass, id);
    }

    protected void containerTick() {
        super.containerTick();
        if (this.changedSlots.isEmpty()) {
            return;
        }
        NonNullList slots = ((AccessoriesMenu)this.getMenu()).slots;
        Map<Integer, Boolean> changes = this.changedSlots.entrySet().stream().filter(entry -> (Integer)entry.getKey() < slots.size()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        ((AccessoriesMenu)this.getMenu()).sendMessage(new ToggledSlots(changes));
        this.changedSlots.clear();
    }

    public void hideSlot(int index) {
        this.hideSlot((Slot)((AccessoriesMenu)this.menu).slots.get(index));
    }

    public void hideSlot(Slot slot) {
        ((SlotAccessor)slot).owo$setX(-300);
        ((SlotAccessor)slot).owo$setY(-300);
    }

    public void disableSlot(Slot slot) {
        super.disableSlot(slot);
        int index = slot.index;
        if (this.changedSlots.getOrDefault(index, false).booleanValue()) {
            return;
        }
        this.hideSlot(index);
        this.changedSlots.put(index, true);
    }

    public void enableSlot(Slot slot) {
        super.enableSlot(slot);
        int index = slot.index;
        if (!this.changedSlots.getOrDefault(index, true).booleanValue()) {
            return;
        }
        this.changedSlots.put(index, false);
    }

    @Override
    @Nullable
    public SlotTypeAccessible getSelectedSlot() {
        SlotTypeAccessible slot;
        Slot slot2 = this.hoveredSlot;
        return slot2 instanceof SlotTypeAccessible ? (slot = (SlotTypeAccessible)slot2) : null;
    }

    @Override
    @Nullable
    public Boolean isHovering_Logical(Slot slot, double mouseX, double mouseY) {
        AccessoriesContainingLayout<?> accessories = this.topComponent;
        return accessories != null ? accessories.isHovering_Logical(slot, mouseX, mouseY) : null;
    }

    public void onClose() {
        Set selectedGroups = ((AccessoriesMenu)this.getMenu()).selectedGroups().stream().map(SlotGroup::name).collect(Collectors.toSet());
        AccessoriesNetworking.sendToServer(SyncOptionChange.of(PlayerOptions.FILTERED_GROUPS, selectedGroups));
        super.onClose();
    }

    protected void init() {
        if (!((AccessoriesMenu)this.menu).isValidMenu()) {
            Minecraft.getInstance().setScreen((Screen)new ErrorScreen((Component)Component.literal((String)"Accessories Screen Opening Error!"), (Component)Component.literal((String)"Unable to open Accessories Screen due to desync with the Server!")));
            return;
        }
        super.init();
    }

    public boolean shouldCloseOnEsc() {
        if (((Boolean)this.getDefaultedData(PlayerOptions.ADVANCED_SETTINGS)).booleanValue()) {
            this.toggleAdvancedOptions(this.component(ButtonComponent.class, "advanced_options_btn"));
            return false;
        }
        return super.shouldCloseOnEsc();
    }

    public boolean keyPressed(KeyEvent input) {
        if (AccessoriesClient.OPEN_SCREEN.matches(input)) {
            this.onClose();
            return true;
        }
        if (input.key() == 256 && ((Boolean)this.getDefaultedData(PlayerOptions.ADVANCED_SETTINGS)).booleanValue()) {
            this.toggleAdvancedOptions(this.component(ButtonComponent.class, "advanced_options_btn"));
            return false;
        }
        return super.keyPressed(input);
    }

    protected boolean hasClickedOutside(double mouseX, double mouseY, int guiLeft, int guiTop) {
        for (PositionedRectangle rect : this.getComponentRectangles()) {
            if (!rect.isInBoundingBox(mouseX, mouseY)) continue;
            return false;
        }
        return true;
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        if (this.hoveredSlot != null) {
            Slot slot = this.hoveredSlot;
            if (slot instanceof AccessoriesInternalSlot) {
                AccessoriesInternalSlot accessoriesInternalSlot = (AccessoriesInternalSlot)slot;
                if (!ArmorSlotTypes.isArmorType(accessoriesInternalSlot.slotName())) {
                    AccessoriesScreenBase.FORCE_TOOLTIP_LEFT.setValue((Boolean)this.getDefaultedData(PlayerOptions.MAIN_WIDGET_POSITION));
                }
            } else if (this.hoveredSlot instanceof ArmorSlot) {
                AccessoriesScreenBase.FORCE_TOOLTIP_LEFT.setValue(true);
            } else if ((this.hoveredSlot.container instanceof TransientCraftingContainer || this.hoveredSlot instanceof ResultSlot) && !((Boolean)this.getDefaultedData(PlayerOptions.SHOW_GROUP_FILTER)).booleanValue()) {
                AccessoriesScreenBase.FORCE_TOOLTIP_LEFT.setValue((Boolean)this.getDefaultedData(PlayerOptions.MAIN_WIDGET_POSITION) == false);
            }
        }
        super.renderTooltip(guiGraphics, x, y);
        AccessoriesScreenBase.FORCE_TOOLTIP_LEFT.setValue(false);
    }

    protected void drawComponentTooltip(GuiGraphics drawContext, int mouseX, int mouseY, float tickDelta) {
        super.drawComponentTooltip(drawContext, mouseX, mouseY, tickDelta);
    }

    protected List<Component> getTooltipFromContainerItem(ItemStack itemStack) {
        ItemStack hoveredStack;
        AccessoriesBasedSlot slot;
        Slot slot2;
        List tooltipData = AccessoriesScreen.getTooltipFromItem((Minecraft)this.minecraft, (ItemStack)itemStack);
        if (Accessories.config().screenOptions.showEquippedStackSlotType() && ((AccessoriesMenu)this.menu).getCarried().isEmpty() && this.hoveredSlot != null && this.hoveredSlot.hasItem() && (slot2 = this.hoveredSlot) instanceof AccessoriesBasedSlot && ExtraSlotTypeProperties.getProperty((slot = (AccessoriesBasedSlot)slot2).slotName(), true).allowTooltipInfo() && itemStack == (hoveredStack = this.hoveredSlot.getItem())) {
            tooltipData.add(Component.empty());
            tooltipData.add(Component.translatable((String)Accessories.translationKey("tooltip.currently_equipped_in")).withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)slot.slotType().translation()).withStyle(ChatFormatting.BLUE)));
        }
        return tooltipData;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        SlotPath positionKey;
        Map<SlotPath, Vector3d> positions;
        AccessoriesInternalSlot slot;
        Slot slot2;
        super.renderBg(guiGraphics, partialTick, mouseX, mouseY);
        if (this.hoveredSlot != null && (slot2 = this.hoveredSlot) instanceof AccessoriesInternalSlot && (slot = (AccessoriesInternalSlot)slot2).isActive() && !slot.getItem().isEmpty() && (positions = AccessoriesFunkyRenderingState.INSTANCE.getNotVeryNicePositions()).containsKey(positionKey = slot.slotPath())) {
            this.hoveredAccessoryPositons.add(positions.get(positionKey));
            Vector3d vec = positions.get(positionKey);
            if (!slot.isCosmetic && vec != null && Accessories.config().screenOptions.hoveredOptions.line()) {
                Vector3d start = new Vector3d((double)(slot.x + this.leftPos + 17), (double)(slot.y + this.topPos + 9), 5000.0);
                Vector3d vec3 = vec.add(0.0, 0.0, 5000.0);
                this.linesToAccessoryPositions.add(new Line3d(start, vec3));
            }
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBg(guiGraphics, partialTick, mouseX, mouseY);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        if (Accessories.config().screenOptions.hoveredOptions.clickbait()) {
            this.hoveredAccessoryPositons.forEach(pos -> DrawUtils.blitSprite(guiGraphics, Accessories.of("highlight/clickbait"), (int)pos.x - 128, (int)pos.y - 128, 450, 256, 256));
            this.hoveredAccessoryPositons.clear();
        }
        if (!this.linesToAccessoryPositions.isEmpty() || Accessories.config().screenOptions.hoveredOptions.line()) {
            this.minecraft.renderBuffers().bufferSource().endBatch((RenderType)RenderType.LINES);
            this.linesToAccessoryPositions.clear();
        }
    }

    public void showCosmeticState(boolean value) {
        this.setData(PlayerOptions.SHOW_COSMETIC_SLOTS, value);
        AccessoriesNetworking.sendToServer(PlayerOptions.SHOW_COSMETIC_SLOTS.toPacket(value));
    }

    public boolean showCosmeticState() {
        return (Boolean)this.getDefaultedData(PlayerOptions.SHOW_COSMETIC_SLOTS);
    }

    protected void build(FlowLayout rootComponent) {
        io.wispforest.owo.ui.core.Component sideBarHolder;
        this.changedSlots.clear();
        ((AccessoriesMenu)this.getMenu()).slots.forEach(this::disableSlot);
        rootComponent.allowOverflow(true).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER).surface(Surface.VANILLA_TRANSLUCENT);
        ArrayList<Object> baseChildren = new ArrayList<Object>();
        AccessoriesContainingLayout<?> accessoriesComponent = this.createAccessoriesComponent();
        AccessoriesMenu menu = (AccessoriesMenu)this.getMenu();
        SlotGroupLoader.getValidGroups(((AccessoriesMenu)this.getMenu()).targetEntityDefaulted()).keySet().stream().filter(group -> ((Set)this.getDefaultedData(PlayerOptions.FILTERED_GROUPS)).contains(group.name())).forEach(menu::addSelectedGroup);
        io.wispforest.owo.ui.core.Component playerInv = ComponentUtils.createPlayerInv(5, menu.startingAccessoriesSlot(), this::slotAsComponent, x$0 -> this.enableSlot((int)x$0));
        this.setData(PlayerOptions.ADVANCED_SETTINGS, false);
        int offHandIndex = ((AccessoriesMenu)this.getMenu()).startingAccessoriesSlot() - 1;
        this.enableSlot(offHandIndex);
        final ParentComponent offhandComponent = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child((io.wispforest.owo.ui.core.Component)this.slotAsComponent(offHandIndex).margins(Insets.of((int)1))).padding(Insets.of((int)7, (int)7, (int)7, (int)4)).allowOverflow(true);
        io.wispforest.owo.ui.core.Component bottomInvComponent = new FlowLayout(this, Sizing.content(), Sizing.content(), FlowLayout.Algorithm.HORIZONTAL){

            public boolean isInBoundingBox(double x, double y) {
                return super.isInBoundingBox(x, y) || offhandComponent.isInBoundingBox(x, y);
            }
        }.child(Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child((io.wispforest.owo.ui.core.Component)offhandComponent).allowOverflow(true).positioning(Positioning.absolute((int)-29, (int)51))).child(Containers.verticalFlow((Sizing)Sizing.fixed((int)162), (Sizing)Sizing.fixed((int)76)).child(playerInv).id("bottom_component_holder")).child(((FlowLayout)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).positioning(Positioning.absolute((int)162, (int)-7)).configure(component -> {
            if (((Boolean)this.getDefaultedData(PlayerOptions.SHOW_CRAFTING_GRID)).booleanValue()) {
                component.child(this.createCraftingGrid());
            }
        })).id("crafting_grid_layout")).padding(Insets.of((int)7)).surface((ctx, component) -> {
            Boolean showCraftingGrid = (Boolean)this.getDefaultedData(PlayerOptions.SHOW_CRAFTING_GRID);
            int width = showCraftingGrid != false ? 238 : 198;
            DrawUtils.blit((GuiGraphics)ctx, Accessories.of("textures/gui/theme/" + ComponentUtils.checkMode("light", "dark") + "/player_inv/" + (showCraftingGrid != false ? "with" : "without") + "_crafting.png"), component.x() - 22, component.y(), width, 90);
        }).allowOverflow(true).id("bottom_inventory_section");
        baseChildren.add(bottomInvComponent);
        FlowLayout primaryLayout = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.fixed((int)140)).gap(2).horizontalAlignment(HorizontalAlignment.CENTER).id("armor_entity_layout");
        FlowLayout armorSlotsLayout = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).configure(layout -> layout.allowOverflow(true));
        FlowLayout outerLeftArmorLayout = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child((io.wispforest.owo.ui.core.Component)armorSlotsLayout);
        FlowLayout cosmeticArmorSlotsLayout = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).configure(layout -> layout.allowOverflow(true));
        FlowLayout outerRightArmorLayout = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child((io.wispforest.owo.ui.core.Component)cosmeticArmorSlotsLayout);
        for (int i = 0; i < menu.addedArmorSlots() / 2; ++i) {
            int armor = menu.startingAccessoriesSlot() + i * 2;
            int cosmeticArmor = armor + 1;
            this.enableSlot(armor);
            this.enableSlot(cosmeticArmor);
            armorSlotsLayout.child((io.wispforest.owo.ui.core.Component)this.slotAsComponent(armor).margins(Insets.of((int)1)));
            cosmeticArmorSlotsLayout.child((io.wispforest.owo.ui.core.Component)ComponentUtils.createSlotWithToggle((AccessoriesBasedSlot)((AccessoriesMenu)this.menu).slots.get(cosmeticArmor), this::slotAsComponent).left());
        }
        StackLayout entityContainer = Containers.stack((Sizing)Sizing.content(), (Sizing)Sizing.fixed((int)140)).child(Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child(this.createEntityComponent()).surface((ctx, component) -> {
            Boolean sideBySideMode;
            DrawUtils.blit((GuiGraphics)ctx, Accessories.of("textures/gui/theme/" + ComponentUtils.checkMode("light", "dark") + "/entity_view/" + ((sideBySideMode = (Boolean)this.getDefaultedData(PlayerOptions.SIDE_BY_SIDE_ENTITY)) != false ? "double" : "single") + "/entity_background.png"), component.x(), component.y(), sideBySideMode != false ? 162 : 108, 126);
        }).id("entity_renderer_holder")).child((io.wispforest.owo.ui.core.Component)Containers.verticalFlow((Sizing)Sizing.fixed((int)0), (Sizing)Sizing.fixed((int)0)).surface((ctx, component) -> {
            Boolean sideBySideMode;
            String surfaceType = Math.min(((AccessoriesMenu)this.getMenu()).addedArmorSlots() / 2, 4) + "_slots";
            DrawUtils.blit((GuiGraphics)ctx, Accessories.of("textures/gui/theme/" + ComponentUtils.checkMode("light", "dark") + "/entity_view/" + ((sideBySideMode = (Boolean)this.getDefaultedData(PlayerOptions.SIDE_BY_SIDE_ENTITY)) != false ? "double" : "single") + "/" + surfaceType + ".png"), component.x() - 7, component.y() - 7, sideBySideMode != false ? 176 : 122, 140);
        })).child(((FlowLayout)outerLeftArmorLayout.configure(component -> component.mouseScroll().subscribe((mouseX, mouseY, amount) -> true))).padding(Insets.of((int)7)).margins(Insets.left((int)-7)).positioning(Positioning.relative((int)0, (int)40))).child(((FlowLayout)outerRightArmorLayout.configure(component -> component.mouseScroll().subscribe((mouseX, mouseY, amount) -> true))).surface(ComponentUtils.SPECTRUM_SLOT_OUTLINE).padding(Insets.of((int)7)).margins(Insets.right((int)-7)).positioning(Positioning.relative((int)100, (int)40))).child(ComponentUtils.createIconButton(btn -> {
            this.showCosmeticState(!this.showCosmeticState());
            btn.tooltip(AccessoriesScreen.createToggleText("slot_cosmetics", false, this.showCosmeticState()));
            AccessoriesContainingLayout component = (AccessoriesContainingLayout)this.rootComponent().childById(AccessoriesContainingLayout.class, AccessoriesContainingLayout.defaultID());
            if (component != null) {
                component.onCosmeticToggle(this.showCosmeticState());
            }
        }, 14, btn -> btn.tooltip(AccessoriesScreen.createToggleText("slot_cosmetics", false, this.showCosmeticState())).margins(Insets.of((int)2, (int)0, (int)3, (int)0)), btn -> Accessories.of("textures/gui/" + (this.showCosmeticState() ? "charm" : "cosmetic") + "_toggle_icon" + (btn.isHovered() ? "_hovered" : "") + ".png")).positioning(Positioning.relative((int)0, (int)0))).child(ComponentUtils.createIconButton(btn -> AccessoriesScreenTransitionHelper.openPrevScreen((Player)Minecraft.getInstance().player, ((AccessoriesMenu)this.menu).targetEntityDefaulted(), this.prevScreen), 10, btn -> btn.tooltip((Component)Component.translatable((String)Accessories.translationKey("back.screen"))).margins(Insets.of((int)3, (int)0, (int)0, (int)3)), btn -> Accessories.of("textures/gui/accessories_back_icon" + (btn.isHovered() ? "_hovered" : "") + ".png")).positioning(Positioning.relative((int)100, (int)0))).child(ComponentUtils.createIconButton(btn -> this.toggleAdvancedOptions((ButtonComponent)btn), 14, "advanced_options_btn", btn -> btn.tooltip(AccessoriesScreen.createToggleText("advanced_options", true, (Boolean)this.getDefaultedData(PlayerOptions.ADVANCED_SETTINGS))).margins(Insets.of((int)0, (int)3, (int)0, (int)3)), (ctx, btn) -> Accessories.of("textures/gui/settings_icon" + (btn.isHovered() ? "_hovered" : "") + ".png")).positioning(Positioning.relative((int)100, (int)100)));
        if (!Accessories.config().screenOptions.alwaysShowCraftingGrid()) {
            entityContainer.child(this.createCraftingToggleButton());
        }
        primaryLayout.child(entityContainer.allowOverflow(true).padding(Insets.of((int)7)).id("entity_button_panel"));
        baseChildren.add(primaryLayout);
        if (accessoriesComponent != null) {
            primaryLayout.child((Boolean)this.getDefaultedData(PlayerOptions.MAIN_WIDGET_POSITION) != false ? 0 : 1, accessoriesComponent);
        }
        boolean hasSideBar = false;
        if (!(accessoriesComponent == null && ((AccessoriesMenu)this.getMenu()).selectedGroups().isEmpty() || (sideBarHolder = this.createSideBarOptions()) == null)) {
            if (((Boolean)this.getDefaultedData(PlayerOptions.SIDE_WIDGET_POSITION)).booleanValue() == ((Boolean)this.getDefaultedData(PlayerOptions.MAIN_WIDGET_POSITION)).booleanValue()) {
                primaryLayout.child(0, sideBarHolder);
            } else {
                primaryLayout.child(sideBarHolder);
            }
            hasSideBar = true;
        }
        this.setupPadding(accessoriesComponent, hasSideBar, (ParentComponent)primaryLayout);
        ParentComponent baseLayout = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).gap(2).children((Collection)baseChildren.reversed()).allowOverflow(true);
        baseLayout.horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER).positioning(Positioning.relative((int)50, (int)50));
        rootComponent.child((io.wispforest.owo.ui.core.Component)baseLayout);
    }

    public void setupPadding() {
        if (this.topComponent == null) {
            return;
        }
        boolean hasSideBar = this.rootComponent().childById(io.wispforest.owo.ui.core.Component.class, "side_bar_holder") != null;
        FlowLayout primaryLayout = (FlowLayout)this.rootComponent().childById(FlowLayout.class, "armor_entity_layout");
        this.setupPadding(this.topComponent, hasSideBar, (ParentComponent)primaryLayout);
    }

    public void setupPadding(AccessoriesContainingLayout<?> accessoriesComponent, boolean hasSideBar, ParentComponent primaryLayout) {
        if (((Boolean)this.getDefaultedData(PlayerOptions.ENTITY_CENTERED)).booleanValue()) {
            int padding = 0;
            Boolean paddingOnTheRight = (Boolean)this.getDefaultedData(PlayerOptions.MAIN_WIDGET_POSITION);
            if (accessoriesComponent != null) {
                int operationValue = (Boolean)this.getDefaultedData(PlayerOptions.SIDE_WIDGET_POSITION) != false ? 1 : -1;
                int roundingOffset = 0;
                if (((Boolean)this.getDefaultedData(PlayerOptions.SIDE_WIDGET_POSITION)).booleanValue()) {
                    roundingOffset = (Boolean)this.getDefaultedData(PlayerOptions.MAIN_WIDGET_POSITION) != false ? -1 : -3;
                } else if (this.component(io.wispforest.owo.ui.core.Component.class, "group_filter_holder") == null && !((Boolean)this.getDefaultedData(PlayerOptions.MAIN_WIDGET_POSITION)).booleanValue()) {
                    roundingOffset = -2;
                }
                padding = accessoriesComponent.getMaxPossibleWidth() + 3 + (hasSideBar ? 35 : 0) * operationValue + roundingOffset;
                primaryLayout.padding(paddingOnTheRight != false ? Insets.right((int)padding) : Insets.left((int)padding));
            }
        } else {
            primaryLayout.padding(Insets.none());
        }
    }

    public void rebuildEntityComponent() {
        FlowLayout holder = this.component(FlowLayout.class, "entity_renderer_holder");
        holder.clearChildren();
        holder.child(this.createEntityComponent());
        this.rebuildComponentRectangles = true;
    }

    public io.wispforest.owo.ui.core.Component createEntityComponent() {
        Boolean sideBySideView = (Boolean)this.getDefaultedData(PlayerOptions.SIDE_BY_SIDE_ENTITY);
        return InventoryEntityComponent.of(Sizing.fixed((int)(sideBySideView != false ? 162 : 108)), Sizing.fixed((int)126), ((AccessoriesMenu)this.getMenu()).targetEntityDefaulted()).renderWrapping((TriConsumer<OwoUIDrawContext, io.wispforest.owo.ui.core.Component, List<Runnable>>)((TriConsumer)(ctx, component, renderCall) -> AccessoriesFunkyRenderingState.INSTANCE.wrapEntityRendering(component.x() + 24, component.y(), component.x() + component.width() - 24, component.y() + component.height(), primaryEntityWrapCall -> {
            primaryEntityWrapCall.accept(() -> ((Runnable)renderCall.getFirst()).run());
            if (renderCall.size() != 1) {
                ((Runnable)renderCall.get(1)).run();
            }
        }))).sideBySideMode(sideBySideView).additionalOffset(sideBySideView != false ? 12 : 0).startingRotation((Boolean)this.getDefaultedData(PlayerOptions.MAIN_WIDGET_POSITION) != false ? -45.0f : 45.0f).scaleToFit(true).allowMouseRotation(true).lookAtCursor(Accessories.config().screenOptions.entityLooksAtMouseCursor()).id("entity_rendering_component");
    }

    public void rebuildAccessoriesComponent() {
        ((AccessoriesMenu)this.getMenu()).getAccessoriesSlots().forEach(this::disableSlot);
        FlowLayout primaryLayout = (FlowLayout)this.rootComponent().childById(FlowLayout.class, "armor_entity_layout");
        AccessoriesContainingLayout accessoriesLayout = (AccessoriesContainingLayout)primaryLayout.childById(AccessoriesContainingLayout.class, AccessoriesContainingLayout.defaultID());
        ParentComponent accessoriesParent = accessoriesLayout.parent();
        if (accessoriesParent != null) {
            ComponentUtils.recursiveSearchSlots(accessoriesParent, slotComponent -> this.hideSlot(slotComponent.slot()));
            accessoriesParent.removeChild((io.wispforest.owo.ui.core.Component)accessoriesLayout);
        }
        AccessoriesContainingLayout<?> accessoriesComponent = this.createAccessoriesComponent();
        boolean hasSideBar = false;
        if (accessoriesComponent != null) {
            if (((Boolean)this.getDefaultedData(PlayerOptions.MAIN_WIDGET_POSITION)).booleanValue()) {
                primaryLayout.child(0, accessoriesComponent);
            } else {
                primaryLayout.child(accessoriesComponent);
            }
            hasSideBar = this.swapOrCreateSideBarComponent();
        } else if (((AccessoriesMenu)this.getMenu()).selectedGroups().isEmpty()) {
            ParentComponent sideParParent;
            io.wispforest.owo.ui.core.Component sideBarOptionsComponent = primaryLayout.childById(io.wispforest.owo.ui.core.Component.class, "accessories_toggle_panel");
            if (sideBarOptionsComponent != null && (sideParParent = sideBarOptionsComponent.parent()) != null) {
                sideParParent.removeChild(sideBarOptionsComponent);
            }
        } else {
            hasSideBar = this.swapOrCreateSideBarComponent();
        }
        this.setupPadding(accessoriesComponent, hasSideBar, (ParentComponent)primaryLayout);
        this.toggleCraftingGrid();
        this.rebuildComponentRectangles = true;
    }

    public boolean swapOrCreateSideBarComponent() {
        if (this.topComponent == null && ((AccessoriesMenu)this.getMenu()).selectedGroups().isEmpty()) {
            return false;
        }
        FlowLayout armorAndEntityComp = (FlowLayout)this.rootComponent().childById(FlowLayout.class, "armor_entity_layout");
        armorAndEntityComp.removeChild(armorAndEntityComp.childById(FlowLayout.class, "side_bar_holder"));
        io.wispforest.owo.ui.core.Component sideBarResultWidget = this.createSideBarOptions();
        this.rebuildComponentRectangles = true;
        if (sideBarResultWidget != null) {
            if (((Boolean)this.getDefaultedData(PlayerOptions.SIDE_WIDGET_POSITION)).booleanValue() == ((Boolean)this.getDefaultedData(PlayerOptions.MAIN_WIDGET_POSITION)).booleanValue()) {
                armorAndEntityComp.child(0, sideBarResultWidget);
            } else {
                armorAndEntityComp.child(sideBarResultWidget);
            }
            return true;
        }
        return false;
    }

    @Nullable
    private AccessoriesContainingLayout<?> createAccessoriesComponent() {
        this.topComponent = (Integer)this.getDefaultedData(PlayerOptions.WIDGET_TYPE) == 2 ? ScrollableAccessoriesLayout.createOrNull(this) : PaginatedAccessoriesLayout.createOrNull(this);
        return this.topComponent;
    }

    @Nullable
    private io.wispforest.owo.ui.core.Component createSideBarOptions() {
        FlowLayout accessoriesTogglePanel = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).id("accessories_toggle_panel");
        io.wispforest.owo.ui.core.Component groupFilterComponent = this.createGroupFilters();
        if (groupFilterComponent != null) {
            return Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child((io.wispforest.owo.ui.core.Component)accessoriesTogglePanel.child(groupFilterComponent).padding(Insets.of((int)7)).surface((ctx, component) -> ComponentUtils.getPanelSurface().and(ComponentUtils.getPanelWithInset(6)).draw(ctx, component)).horizontalAlignment(HorizontalAlignment.CENTER)).horizontalAlignment((Boolean)this.getDefaultedData(PlayerOptions.MAIN_WIDGET_POSITION) != false ? HorizontalAlignment.LEFT : HorizontalAlignment.RIGHT).id("side_bar_holder");
        }
        return null;
    }

    public void rebuildSideBarOptions() {
        if (((Boolean)this.getDefaultedData(PlayerOptions.SHOW_GROUP_FILTER)).booleanValue()) {
            io.wispforest.owo.ui.core.Component groupFilter;
            FlowLayout panel = (FlowLayout)this.rootComponent().childById(FlowLayout.class, "accessories_toggle_panel");
            if (panel != null && (groupFilter = this.createGroupFilters()) != null) {
                panel.child(groupFilter);
            }
        } else {
            ParentComponent component = (ParentComponent)this.rootComponent().childById(ParentComponent.class, "group_filter_holder");
            if (component != null) {
                component.remove();
            }
        }
        this.rebuildComponentRectangles = true;
        this.toggleCraftingGrid();
    }

    @Nullable
    private io.wispforest.owo.ui.core.Component createGroupFilters() {
        if (!((Boolean)this.getDefaultedData(PlayerOptions.SHOW_GROUP_FILTER)).booleanValue()) {
            return null;
        }
        ArrayList<SlotGroup> groups = new ArrayList<SlotGroup>(SlotGroupLoader.getValidGroups(((AccessoriesMenu)this.getMenu()).targetEntityDefaulted()).keySet());
        if (groups.isEmpty()) {
            return null;
        }
        Set<SlotType> usedSlots = ((AccessoriesMenu)this.getMenu()).getUsedSlots();
        ArrayList<io.wispforest.owo.ui.core.Component> groupButtons = new ArrayList<io.wispforest.owo.ui.core.Component>();
        for (SlotGroup group : groups) {
            Set groupSlots = group.slots().stream().filter(slotName -> {
                if (UniqueSlotHandling.isUniqueSlot(slotName)) {
                    return false;
                }
                SlotType slotType = SlotTypeLoader.getSlotType(this.targetEntityDefaulted(), slotName);
                if (slotType == null) {
                    return false;
                }
                AccessoriesCapability capability = this.targetEntityDefaulted().accessoriesCapability();
                if (capability == null) {
                    return false;
                }
                AccessoriesContainer container = capability.getContainer(slotType);
                if (container == null) {
                    return false;
                }
                return container.getSize() > 0;
            }).map(slotName -> SlotTypeLoader.INSTANCE.getSlotType(false, (String)slotName)).collect(Collectors.toSet());
            if (groupSlots.isEmpty()) continue;
            if (usedSlots != null) {
                if (groupSlots.stream().noneMatch(usedSlots::contains)) continue;
            }
            groupButtons.add(ComponentUtils.createGroupToggle(this, group));
        }
        if (groupButtons.isEmpty()) {
            return null;
        }
        Object baseButtonLayout = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).children(groupButtons).gap(1);
        if (groupButtons.size() > 7) {
            ExtendedScrollContainer scrollable = (ExtendedScrollContainer)new ExtendedScrollContainer<ParentComponent>(ScrollContainer.ScrollDirection.VERTICAL, Sizing.fixed((int)21), Sizing.fixed((int)108), baseButtonLayout.padding(Insets.of((int)1))).configure(scrollContainer -> scrollContainer.oppositeScrollbar(((Boolean)this.getDefaultedData(PlayerOptions.SIDE_WIDGET_POSITION)).booleanValue() == ((Boolean)this.getDefaultedData(PlayerOptions.MAIN_WIDGET_POSITION)).booleanValue()).scrollToAfterLayout(this.groupFilterScrollable != null ? this.groupFilterScrollable.getProgress() : 0.0).scrollbarThiccness(2).scrollbar(ScrollContainer.Scrollbar.flat((Color)Color.ofArgb((int)-1610612736))).fixedScrollbarLength(16).padding(Insets.of((int)1, (int)2, (int)2, (int)1)).id("group_filters_scrollable"));
            baseButtonLayout = scrollable;
            this.groupFilterScrollable = scrollable;
        } else {
            baseButtonLayout.padding(Insets.of((int)1, (int)2, (int)2, (int)2));
            this.groupFilterScrollable = null;
        }
        return Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child(ComponentUtils.createIconButton(btn -> {
            ((AccessoriesMenu)this.getMenu()).selectedGroups().clear();
            this.rebuildAccessoriesComponent();
        }, 14, btn -> btn.tooltip((Component)Component.translatable((String)Accessories.translationKey("reset.group_filter"))), btn -> Accessories.of("textures/gui/reset_icon" + (btn.isHovered() ? "_hovered" : "") + ".png")).margins(Insets.of((int)3, (int)1, (int)0, (int)0))).child((io.wispforest.owo.ui.core.Component)baseButtonLayout).horizontalAlignment(HorizontalAlignment.CENTER).id("group_filter_holder");
    }

    private void swapBottomComponentHolder() {
        FlowLayout holder = (FlowLayout)this.rootComponent().childById(FlowLayout.class, "bottom_component_holder");
        holder.clearChildren();
        if (((Boolean)this.getDefaultedData(PlayerOptions.ADVANCED_SETTINGS)).booleanValue()) {
            for (int i = 0; i < ((AccessoriesMenu)this.menu).startingAccessoriesSlot() - 1; ++i) {
                this.disableSlot(i);
            }
            this.settingsLayout = new AccessoriesScreenSettingsLayout(this, this::component).onChange(type -> {
                switch (type) {
                    case ACCESSORIES: {
                        this.rebuildAccessoriesComponent();
                        break;
                    }
                    case ENTITY: {
                        this.rebuildEntityComponent();
                        break;
                    }
                    case SIDE_BAR: {
                        this.rebuildSideBarOptions();
                        break;
                    }
                    case SLOTS: {
                        ((AccessoriesMenu)this.getMenu()).updateUsedSlots();
                    }
                }
            });
            holder.child((io.wispforest.owo.ui.core.Component)this.settingsLayout).surface(ComponentUtils.getInsetPanelSurface()).padding(Insets.of((int)1));
        } else {
            this.settingsLayout = null;
            holder.child(ComponentUtils.createPlayerInv(5, ((AccessoriesMenu)this.menu).startingAccessoriesSlot(), this::slotAsComponent, x$0 -> this.enableSlot((int)x$0))).surface(Surface.BLANK).padding(Insets.of((int)0));
        }
        this.rebuildComponentRectangles = true;
    }

    private void toggleCraftingGrid() {
        this.rebuildComponentRectangles = true;
        this.removeCraftingGrid();
        if (!((Boolean)this.getDefaultedData(PlayerOptions.SHOW_CRAFTING_GRID)).booleanValue()) {
            return;
        }
        FlowLayout bottom_holder = (FlowLayout)this.rootComponent().childById(FlowLayout.class, "crafting_grid_layout");
        bottom_holder.child(this.createCraftingGrid());
    }

    private void removeCraftingGrid() {
        FlowLayout bottom_holder = (FlowLayout)this.rootComponent().childById(FlowLayout.class, "crafting_grid_layout");
        if (bottom_holder != null) {
            bottom_holder.clearChildren();
        }
        if (!((Boolean)this.getDefaultedData(PlayerOptions.SHOW_CRAFTING_GRID)).booleanValue()) {
            bottom_holder.margins(Insets.of((int)0));
            for (int i = 0; i < 5; ++i) {
                this.disableSlot(i);
            }
        }
    }

    private io.wispforest.owo.ui.core.Component createCraftingGrid() {
        return ComponentUtils.createCraftingComponent(0, this::slotAsComponent, x$0 -> this.enableSlot((int)x$0), true).id("crafting_component");
    }

    private io.wispforest.owo.ui.core.Component createCraftingToggleButton() {
        return ComponentUtils.createIconButton(btn -> {
            AccessoriesNetworking.sendToServer(SyncOptionChange.of(PlayerOptions.SHOW_CRAFTING_GRID, ((AccessoriesMenu)this.menu).owner(), bl -> bl == false));
            this.setData(PlayerOptions.SHOW_CRAFTING_GRID, (Boolean)this.getDefaultedData(PlayerOptions.SHOW_CRAFTING_GRID) == false);
            btn.tooltip(AccessoriesScreen.createToggleText("crafting_grid", true, (Boolean)this.getDefaultedData(PlayerOptions.SHOW_CRAFTING_GRID)));
            this.toggleCraftingGrid();
        }, 14, "crafting_grid_btn", btn -> btn.tooltip(AccessoriesScreen.createToggleText("crafting_grid", true, (Boolean)this.getDefaultedData(PlayerOptions.SHOW_CRAFTING_GRID))).margins(Insets.of((int)0, (int)3, (int)3, (int)0)), (ctx, btn) -> Accessories.of("textures/gui/crafting_toggle_icon" + (btn.isHovered() ? "_hovered" : "") + ".png")).positioning(Positioning.relative((int)0, (int)100));
    }

    @Override
    public void onHolderChange(PlayerOption<?> option) {
        if (this.settingsLayout == null) {
            return;
        }
        this.settingsLayout.onHolderChange(option);
        if (option.equals(PlayerOptions.SHOW_CRAFTING_GRID)) {
            StackLayout buttonPanel = this.component(StackLayout.class, "entity_button_panel");
            io.wispforest.owo.ui.core.Component craftingBtn = buttonPanel.childById(io.wispforest.owo.ui.core.Component.class, "crafting_grid_btn");
            if (craftingBtn != null && Accessories.config().screenOptions.alwaysShowCraftingGrid()) {
                buttonPanel.removeChild(craftingBtn);
            } else if (craftingBtn == null && Accessories.config().screenOptions.alwaysShowCraftingGrid()) {
                buttonPanel.child(buttonPanel.children().size() - 1, this.createCraftingToggleButton());
            }
        }
    }

    private void toggleAdvancedOptions(ButtonComponent btn) {
        boolean value = (Boolean)this.getDefaultedData(PlayerOptions.ADVANCED_SETTINGS) == false;
        this.setData(PlayerOptions.ADVANCED_SETTINGS, value);
        btn.tooltip(AccessoriesScreen.createToggleText("advanced_options", true, (Boolean)this.getDefaultedData(PlayerOptions.ADVANCED_SETTINGS)));
        this.swapBottomComponentHolder();
    }

    private static Component createToggleText(String type, boolean isTooltip, boolean value) {
        return Accessories.translation(type + ".toggle." + (value ? "enabled" : "disabled") + (isTooltip ? ".tooltip" : ""));
    }

    public ExtendedSlotComponent slotAsComponent(int index) {
        return new ExtendedSlotComponent(this, index);
    }

    @Override
    public <T> Optional<T> getData(PlayerOption<T> option) {
        return option.getData(((AccessoriesMenu)this.menu).owner()).or(() -> {
            AccessoriesPlayerOptionsHolder defaults = Accessories.config().screenOptions.defaultValues();
            return defaults != null ? defaults.getData(option) : Optional.empty();
        });
    }

    @Override
    public <T> void setData(PlayerOption<T> option, T data) {
        option.setData(((AccessoriesMenu)this.menu).owner(), data);
    }

    public class ExtendedSlotComponent
    extends BaseOwoHandledScreen.SlotComponent {
        protected final AccessoriesScreen screen;
        protected int index;

        protected ExtendedSlotComponent(AccessoriesScreen this$0, int index) {
            super((BaseOwoHandledScreen)this$0, index);
            this.screen = this$0;
            this.index = index;
            this.didDraw = true;
            Slot slot = this.slot();
            if (slot instanceof AccessoriesBasedSlot) {
                AccessoriesBasedSlot accessoriesBasedSlot = (AccessoriesBasedSlot)slot;
                this.tooltip(accessoriesBasedSlot.getTooltipData());
            }
        }

        public final Slot slot() {
            return this.slot;
        }

        public void dismount(Component.DismountReason reason) {
            super.dismount(reason);
            if (reason == Component.DismountReason.REMOVED) {
                ((SlotAccessor)this.slot).owo$setX(-300);
                ((SlotAccessor)this.slot).owo$setY(-300);
            }
        }

        public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
            this.didDraw = true;
            ((OwoSlotExtension)this.slot).owo$setDisabledOverride(false);
        }

        public void drawTooltip(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
            Slot slot = this.slot();
            if (slot != null) {
                if (slot instanceof AccessoriesInternalSlot) {
                    AccessoriesInternalSlot accessoriesInternalSlot = (AccessoriesInternalSlot)slot;
                    if (!ArmorSlotTypes.isArmorType(accessoriesInternalSlot.slotName())) {
                        AccessoriesScreenBase.FORCE_TOOLTIP_LEFT.setValue((Boolean)this.screen.getDefaultedData(PlayerOptions.MAIN_WIDGET_POSITION));
                    }
                } else if (slot instanceof ArmorSlot) {
                    AccessoriesScreenBase.FORCE_TOOLTIP_LEFT.setValue(true);
                } else if ((slot.container instanceof TransientCraftingContainer || slot instanceof ResultSlot) && !((Boolean)this.screen.getDefaultedData(PlayerOptions.SHOW_GROUP_FILTER)).booleanValue()) {
                    AccessoriesScreenBase.FORCE_TOOLTIP_LEFT.setValue((Boolean)this.screen.getDefaultedData(PlayerOptions.MAIN_WIDGET_POSITION) == false);
                }
            }
            super.drawTooltip(context, mouseX, mouseY, partialTicks, delta);
            AccessoriesScreenBase.FORCE_TOOLTIP_LEFT.setValue(false);
        }
    }
}

