/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.commands;

import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.attributes.SlotAttribute;
import io.wispforest.accessories.api.client.rendering.RenderingFunction;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryCustomRendererComponent;
import io.wispforest.accessories.api.components.AccessoryItemAttributeModifiers;
import io.wispforest.accessories.api.components.AccessoryMobEffectsComponent;
import io.wispforest.accessories.api.components.AccessoryNestContainerContents;
import io.wispforest.accessories.api.components.AccessorySlotValidationComponent;
import io.wispforest.accessories.api.components.AccessoryStackSettings;
import io.wispforest.accessories.api.slot.SlotGroup;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.commands.AccessoriesItemCommands;
import io.wispforest.accessories.commands.AccessoriesMixedSlotArgument;
import io.wispforest.accessories.commands.ResourceExtendedArgument;
import io.wispforest.accessories.commands.SlotArgumentType;
import io.wispforest.accessories.commands.api.CommandGenerators;
import io.wispforest.accessories.commands.api.CommandTreeGenerator;
import io.wispforest.accessories.commands.api.base.BranchedCommandGenerator;
import io.wispforest.accessories.commands.api.base.CommandTreeBuilder;
import io.wispforest.accessories.commands.api.core.NamedArgumentGetter;
import io.wispforest.accessories.commands.api.core.RecordArgumentTypeInfo;
import io.wispforest.accessories.data.CustomRendererLoader;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.data.SlotGroupLoader;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.mixin.CommandSelectionAccessor;
import io.wispforest.accessories.mixin.ResourceArgumentAccessor;
import io.wispforest.endec.Endec;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.SlotArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class AccessoriesCommands
implements CommandTreeGenerator.Branched {
    public static final AccessoriesCommands INSTANCE = new AccessoriesCommands();
    public static final SimpleCommandExceptionType NON_LIVING_ENTITY_TARGET = new SimpleCommandExceptionType((Message)Component.translatable((String)"accessories.argument.livingEntities.nonLiving"));
    public static final SimpleCommandExceptionType INVALID_SLOT_TYPE = new SimpleCommandExceptionType((Message)new LiteralMessage("Invalid Slot Type"));
    public static final SimpleCommandExceptionType ERROR_CAPABILITY_MISSING = new SimpleCommandExceptionType((Message)Component.literal((String)"Unable to get the needed capability from the given target!"));
    public static final DynamicCommandExceptionType ERROR_CONTAINER_MISSING = new DynamicCommandExceptionType(obj -> Component.literal((String)("Unable to get the needed Container from the given target! [Container: " + String.valueOf(obj) + "]")));
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Dynamic3CommandExceptionType ERROR_MODIFIER_ALREADY_PRESENT = new Dynamic3CommandExceptionType((var1, var2, var3) -> Component.translatableEscape((String)"accessories.commands.attribute.failed.modifier_already_present_itemstack", (Object[])new Object[]{var1, var2, var3}));
    private static final Dynamic3CommandExceptionType ERROR_NO_SUCH_MODIFIER = new Dynamic3CommandExceptionType((var1, var2, var3) -> Component.translatableEscape((String)"accessories.commands.attribute.failed.no_modifier_itemstack", (Object[])new Object[]{var1, var2, var3}));

    private AccessoriesCommands() {
    }

    public static void init() {
        CommandGenerators.create("accessories", INSTANCE, registration -> {
            registration.register(Accessories.of("slot_type"), SlotArgumentType.class, RecordArgumentTypeInfo.of(ctx -> SlotArgumentType.INSTANCE));
            registration.register(Accessories.of("resource"), ResourceExtendedArgument.class, RecordArgumentTypeInfo.of(ResourceExtendedArgument::attributes));
            registration.register(Accessories.of("slot_path"), AccessoriesMixedSlotArgument.class, RecordArgumentTypeInfo.of(Endec.STRING, "entity_argument_name", AccessoriesMixedSlotArgument::entityArgumentName, AccessoriesMixedSlotArgument::new));
        });
    }

    public static LivingEntity getOrThrowLivingEntity(CommandContext<CommandSourceStack> ctx, String name) throws CommandSyntaxException {
        Entity entity = EntityArgument.getEntity(ctx, (String)name);
        if (!(entity instanceof LivingEntity)) {
            throw NON_LIVING_ENTITY_TARGET.create();
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        return livingEntity;
    }

    public static AccessoriesCapability getCapability(Entity entity) throws CommandSyntaxException {
        if (!(entity instanceof LivingEntity)) {
            throw NON_LIVING_ENTITY_TARGET.create();
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        AccessoriesCapability capability = livingEntity.accessoriesCapability();
        if (capability == null) {
            throw ERROR_CAPABILITY_MISSING.create();
        }
        return capability;
    }

    public static AccessoriesContainer getContainer(Entity entity, String slot) throws CommandSyntaxException {
        AccessoriesCapability capability = AccessoriesCommands.getCapability(entity);
        AccessoriesContainer container = capability.getContainers().get(slot);
        if (container == null) {
            throw ERROR_CONTAINER_MISSING.create((Object)slot);
        }
        return container;
    }

    @Override
    public <T> NamedArgumentGetter<CommandSourceStack, T> getArgumentGetter(ArgumentType<T> type) {
        NamedArgumentGetter<CommandSourceStack, ?> getter = AccessoriesCommands.getArgumentGetterErased(type);
        return getter != null ? getter : CommandTreeGenerator.Branched.super.getArgumentGetter(type);
    }

    @Nullable
    public static <T> NamedArgumentGetter<CommandSourceStack, ?> getArgumentGetterErased(ArgumentType<T> type) {
        if (type instanceof ResourceLocationArgument) {
            return ResourceLocationArgument::getId;
        }
        if (type instanceof ComponentArgument) {
            return ComponentArgument::getResolvedComponent;
        }
        if (type instanceof BoolArgumentType) {
            return BoolArgumentType::getBool;
        }
        if (type instanceof SlotArgumentType) {
            return SlotArgumentType::getSlot;
        }
        if (type instanceof DoubleArgumentType) {
            return DoubleArgumentType::getDouble;
        }
        if (type instanceof IntegerArgumentType) {
            return IntegerArgumentType::getInteger;
        }
        if (type instanceof ResourceExtendedArgument) {
            return ResourceExtendedArgument::getResource;
        }
        if (type instanceof ResourceArgument) {
            ResourceArgument resourceArgument = (ResourceArgument)type;
            ResourceKey key = ((ResourceArgumentAccessor)resourceArgument).registryKey();
            return (ctx, name) -> ResourceArgument.getResource((CommandContext)ctx, (String)name, (ResourceKey)key);
        }
        if (type instanceof AccessoriesMixedSlotArgument) {
            return AccessoriesMixedSlotArgument::getSlot;
        }
        if (type instanceof SlotArgument) {
            return SlotArgument::getSlot;
        }
        return null;
    }

    @Override
    public void generateTrees(BranchedCommandGenerator root, CommandBuildContext context, Commands.CommandSelection environment) {
        root.modifyRootNode(builder -> builder.requires(stack -> stack.hasPermission(2)));
        if (((CommandSelectionAccessor)environment).accessories$includeIntegrated()) {
            root.branch("rendering", renderingBranch -> ((CommandTreeBuilder.BranchedCommandTreeBuilder)renderingBranch.leaves("create-renderer-stack", this.required("renderer_id", ResourceLocationArgument.id()), this.required("item_model_id", ResourceLocationArgument.id()), this.required("custom_name", ComponentArgument.textComponent((CommandBuildContext)context)), this.defaulted("is_bundle", BoolArgumentType.bool(), false), (ctx, rendererId, itemModelId, component, isBundle) -> {
                AccessoriesCommands.createRenderStack((CommandContext<CommandSourceStack>)ctx, rendererId, itemModelId, component, isBundle);
                return 0;
            })).leaves("listen-to-renderer", this.defaulted("item_model_id", ResourceLocationArgument.id(), null), (ctx, id) -> {
                CustomRendererLoader.constantFileResolving(((CommandSourceStack)ctx.getSource()).getServer(), id);
                return 1;
            }));
        }
        root.leaves("edit", this.defaulted("entity", (ArgumentType<?>)EntityArgument.entity(), AccessoriesCommands::getOrThrowLivingEntity, null), (ctx, livingEntity) -> {
            Accessories.askPlayerForVariant(((CommandSourceStack)ctx.getSource()).getPlayerOrException(), livingEntity);
            return 1;
        });
        List<String> validLoggingBranches = List.of("slots", "groups", "entity_bindings");
        DynamicCommandExceptionType logFailureType = new DynamicCommandExceptionType(branch -> Component.translatable((String)"accessories.commands.dump.failure", (Object[])new Object[]{branch, validLoggingBranches.toString()}));
        root.leaves("dump", this.branches(validLoggingBranches), (ctx, branch) -> {
            switch (branch) {
                case "slots": {
                    LOGGER.info("All given Slots registered:");
                    for (SlotType slotType : SlotTypeLoader.INSTANCE.getEntries((Level)((CommandSourceStack)ctx.getSource()).getLevel()).values()) {
                        LOGGER.info(slotType.dumpData());
                    }
                    break;
                }
                case "groups": {
                    LOGGER.info("All given Slot Groups registered:");
                    for (SlotGroup group : SlotGroupLoader.getGroups((Level)((CommandSourceStack)ctx.getSource()).getLevel())) {
                        LOGGER.info(group.dumpData());
                    }
                    break;
                }
                case "entity_bindings": {
                    LOGGER.info("All given Entity Bindings registered:");
                    EntitySlotLoader.INSTANCE.getEntitySlotData(false).forEach((type, slots) -> LOGGER.info("[EntityType: {}] <-> [Slots: {}]", type, slots.keySet()));
                    break;
                }
                default: {
                    throw logFailureType.create(branch);
                }
            }
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.translatable((String)"accessories.commands.dump.success", (Object[])new Object[]{branch}));
            return 1;
        });
        AccessoriesItemCommands.INSTANCE.generateTrees(root, context, environment);
        root.branch("slot", slotBranch -> ((CommandTreeBuilder.BranchedCommandTreeBuilder)slotBranch.leaves("get", this.required("entity", (ArgumentType<?>)EntityArgument.entity(), EntityArgument::getEntity), this.required("slot", SlotArgumentType.INSTANCE), this.defaulted("scale", DoubleArgumentType.doubleArg(), 1.0), (ctx, entity, slot, scale) -> {
            AccessoriesContainer container = AccessoriesCommands.getContainer(entity, slot);
            int size = container.getSize();
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"accessories.commands.slot.value.get.success", (Object[])new Object[]{Component.translatable((String)Accessories.translationKey("slot." + slot.replace(":", "."))), entity.getName(), size}), false);
            return (int)((double)size * scale);
        })).branch("modifier", modiferBranch -> ((CommandTreeBuilder.BranchedCommandTreeBuilder)modiferBranch.leaves("clear", this.required("entity", (ArgumentType<?>)EntityArgument.entity(), EntityArgument::getEntity), this.defaulted("slot", SlotArgumentType.INSTANCE, ""), (ctx, entity, s) -> {
            if (s.isBlank()) {
                AccessoriesCapability capability = AccessoriesCommands.getCapability(entity);
                capability.clearSlotModifiers();
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"accessories.commands.slot.modifier.clear.all.success", (Object[])new Object[]{entity.getName()}), false);
            } else {
                AccessoriesContainer container = AccessoriesCommands.getContainer(entity, s);
                container.clearModifiers();
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"accessories.commands.slot.modifier.clear.container.success", (Object[])new Object[]{s, entity.getName()}), false);
            }
            return 1;
        })).branch(this.required("entity", (ArgumentType<?>)EntityArgument.entity(), EntityArgument::getEntity), this.required("slot", SlotArgumentType.INSTANCE), this.required("id", ResourceLocationArgument.id()), branchBuilder -> branchBuilder.leaves("add", this.required("amount", DoubleArgumentType.doubleArg()), this.branches(List.of("add_value", "add_multiplied_base", "add_multiplied_total"), (String operationTypeStr) -> Arrays.stream(AttributeModifier.Operation.values()).filter(value -> value.getSerializedName().equals(operationTypeStr)).findFirst().orElse(null)), this.defaulted("is_persistent", BoolArgumentType.bool(), true), (ctx, entity, slot, id, amount, operation, isPersistent) -> {
            AccessoriesContainer container = AccessoriesCommands.getContainer(entity, slot);
            AttributeModifier modifier = new AttributeModifier(id, amount.doubleValue(), operation);
            if (isPersistent.booleanValue()) {
                container.addPersistentModifier(modifier);
            } else {
                container.addTransientModifier(modifier);
            }
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.translatable((String)"accessories.commands.slot.modifier.addition", (Object[])new Object[]{id, slot, entity.getDisplayName()}));
            return 1;
        }).leaves("remove", (ctx, entity, slot, id) -> {
            AccessoriesContainer container = AccessoriesCommands.getContainer(entity, slot);
            boolean doseExist = container.hasModifier((ResourceLocation)id);
            if (doseExist) {
                container.removeModifier((ResourceLocation)id);
            }
            String messageType = doseExist ? "accessories.commands.slot.modifier.removed.success" : "accessories.commands.slot.modifier.removed.failure";
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.translatable((String)messageType, (Object[])new Object[]{id, slot, entity.getDisplayName()}));
            return 1;
        }).leaves("get", this.defaulted("scale", DoubleArgumentType.doubleArg(), 1.0), (ctx, entity, slot, id, scale) -> {
            AccessoriesContainer container = AccessoriesCommands.getContainer(entity, slot);
            Map<ResourceLocation, AttributeModifier> modifiers = container.getModifiers();
            Holder<Attribute> attribute = SlotAttribute.getAttributeHolder(container.slotType());
            if (!modifiers.containsKey(id)) {
                throw ERROR_NO_SUCH_MODIFIER.create((Object)entity.getName(), (Object)AccessoriesCommands.getAttributeDescription(attribute), id);
            }
            double d = modifiers.get(id).amount();
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"commands.attribute.modifier.value.get.success", (Object[])new Object[]{Component.translationArg((ResourceLocation)id), AccessoriesCommands.getAttributeDescription(attribute), entity.getName(), d}), false);
            return (int)(d * scale);
        }))));
        root.branch("components", itemComponentBranch -> {
            itemComponentBranch.leaves("effect/add", this.required("effect", ResourceArgument.resource((CommandBuildContext)context, (ResourceKey)Registries.MOB_EFFECT)), this.defaulted("applyDelay", IntegerArgumentType.integer((int)1, (int)1000000), null), this.defaulted("seconds", IntegerArgumentType.integer((int)1, (int)1000000), -1), this.defaulted("amplifier", IntegerArgumentType.integer((int)0, (int)255), 1), this.defaulted("hideParticles", BoolArgumentType.bool(), null), this.defaulted("hideIcon", BoolArgumentType.bool(), null), (ctx, effect, applyDelay, seconds, amplifier, hideParticles, hideIcon) -> {
                if (seconds == -1 && hideParticles == null) {
                    hideParticles = true;
                }
                if (hideIcon == null) {
                    hideIcon = false;
                }
                MobEffectInstance effectInstance = new MobEffectInstance((Holder)effect, seconds.intValue(), amplifier.intValue(), false, hideParticles == false, hideIcon == false);
                ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
                player.getMainHandItem().update(AccessoriesDataComponents.MOB_EFFECTS, (Object)AccessoryMobEffectsComponent.EMPTY, data -> applyDelay != null ? data.addEffect(effectInstance, (int)applyDelay) : data.addEffect(effectInstance));
                return 1;
            });
            itemComponentBranch.leaves("nest", this.required("item", (ArgumentType<?>)ItemArgument.item((CommandBuildContext)context), (ctx, name) -> ItemArgument.getItem((CommandContext)ctx, (String)name).createItemStack(1, false)), (ctx, innerStack) -> {
                ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
                player.getMainHandItem().update(AccessoriesDataComponents.NESTED_ACCESSORIES, (Object)AccessoryNestContainerContents.EMPTY, data -> data.addStack((ItemStack)innerStack));
                ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.translatable((String)"accessories.commands.nest.addition"));
                return 1;
            });
            itemComponentBranch.leaves("slot", this.branches("add", "remove"), this.branches("valid", "invalid"), this.required("slot", SlotArgumentType.INSTANCE), (ctx, operation, condition, slot) -> AccessoriesCommands.adjustSlotValidationOnStack(condition, Objects.equals(operation, "add"), slot, (CommandContext<CommandSourceStack>)ctx));
            itemComponentBranch.branch("stack-sizing", branchBuilder -> ((CommandTreeBuilder.BranchedCommandTreeBuilder)branchBuilder.leaves("useStackSize", this.required("value", BoolArgumentType.bool()), (ctx, bl) -> {
                ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
                player.getMainHandItem().update(AccessoriesDataComponents.STACK_SETTINGS, (Object)AccessoryStackSettings.DEFAULT, component -> component.useStackSize((boolean)bl));
                return 1;
            })).leaves(this.required("size", IntegerArgumentType.integer()), (ctx, size) -> {
                ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
                player.getMainHandItem().update(AccessoriesDataComponents.STACK_SETTINGS, (Object)AccessoryStackSettings.DEFAULT, component -> component.sizeOverride((int)size));
                return 1;
            }));
            itemComponentBranch.branch("attribute", this.required("attribute", ResourceExtendedArgument.attributes(context)), this.required("id", ResourceLocationArgument.id()), branchBuilder -> branchBuilder.leaves("add", this.required("amount", DoubleArgumentType.doubleArg()), this.branches(List.of("add_value", "add_multiplied_base", "add_multiplied_total"), (String operationTypeStr) -> Arrays.stream(AttributeModifier.Operation.values()).filter(value -> value.getSerializedName().equals(operationTypeStr)).findFirst().orElse(null)), this.required("slot", SlotArgumentType.INSTANCE), this.required("isStackable", BoolArgumentType.bool()), this.defaulted("usedInSlotValidation", BoolArgumentType.bool(), false), AccessoriesCommands::addModifier).leaves("remove", AccessoriesCommands::removeModifier).leaves("get", this.defaulted("scale", DoubleArgumentType.doubleArg(), 1.0), AccessoriesCommands::getAttributeModifier));
        });
    }

    private static int getAttributeModifier(CommandContext<CommandSourceStack> ctx, Holder<Attribute> holder, ResourceLocation resourceLocation, double d) throws CommandSyntaxException {
        CommandSourceStack commandSourceStack = (CommandSourceStack)ctx.getSource();
        ServerPlayer livingEntity = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        ItemStack stack = livingEntity.getMainHandItem();
        AccessoryItemAttributeModifiers component = (AccessoryItemAttributeModifiers)stack.getOrDefault(AccessoriesDataComponents.ATTRIBUTES, (Object)AccessoryItemAttributeModifiers.EMPTY);
        AttributeModifier modifier = component.getModifier(holder, resourceLocation);
        if (modifier == null) {
            throw ERROR_NO_SUCH_MODIFIER.create((Object)stack.getDisplayName(), (Object)AccessoriesCommands.getAttributeDescription(holder), (Object)resourceLocation);
        }
        double e = modifier.amount();
        commandSourceStack.sendSuccess(() -> Component.translatable((String)"accessories.commands.attribute.modifier.value.get.success_itemstack", (Object[])new Object[]{Component.translationArg((ResourceLocation)resourceLocation), AccessoriesCommands.getAttributeDescription(holder), stack.getDisplayName(), e}), false);
        return (int)(e * d);
    }

    private static int addModifier(CommandContext<CommandSourceStack> ctx, Holder<Attribute> holder, ResourceLocation resourceLocation, double d, AttributeModifier.Operation operation, String slotName, boolean isStackable, boolean usedInSlotValidation) throws CommandSyntaxException {
        CommandSourceStack commandSourceStack = (CommandSourceStack)ctx.getSource();
        if (operation == null) {
            commandSourceStack.sendFailure((Component)Component.literal((String)"Unable to locate AttributeModifier Operation type passed to the command!"));
            return -1;
        }
        ServerPlayer livingEntity = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        ItemStack stack = livingEntity.getMainHandItem();
        AccessoryItemAttributeModifiers component = (AccessoryItemAttributeModifiers)stack.getOrDefault(AccessoriesDataComponents.ATTRIBUTES, (Object)AccessoryItemAttributeModifiers.EMPTY);
        if (component.hasModifier(holder, resourceLocation)) {
            throw ERROR_MODIFIER_ALREADY_PRESENT.create((Object)resourceLocation, (Object)AccessoriesCommands.getAttributeDescription(holder), (Object)stack.getDisplayName());
        }
        stack.set(AccessoriesDataComponents.ATTRIBUTES, (Object)component.withModifierAdded(holder, new AttributeModifier(resourceLocation, d, operation), slotName, isStackable, usedInSlotValidation));
        commandSourceStack.sendSuccess(() -> Component.translatable((String)"accessories.commands.attribute.modifier.add.success_itemstack", (Object[])new Object[]{Component.translationArg((ResourceLocation)resourceLocation), AccessoriesCommands.getAttributeDescription(holder), stack.getDisplayName()}), false);
        return 1;
    }

    private static int removeModifier(CommandContext<CommandSourceStack> ctx, Holder<Attribute> holder, ResourceLocation location) throws CommandSyntaxException {
        CommandSourceStack commandSourceStack = (CommandSourceStack)ctx.getSource();
        ServerPlayer livingEntity = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        MutableBoolean removedModifier = new MutableBoolean(false);
        ItemStack stack = livingEntity.getMainHandItem();
        stack.update(AccessoriesDataComponents.ATTRIBUTES, (Object)AccessoryItemAttributeModifiers.EMPTY, component -> {
            int size = component.modifiers().size();
            if (size != (component = component.withoutModifier(holder, location)).modifiers().size()) {
                removedModifier.setTrue();
            }
            return component;
        });
        if (!removedModifier.getValue().booleanValue()) {
            throw ERROR_NO_SUCH_MODIFIER.create((Object)location, (Object)stack.getDisplayName(), (Object)AccessoriesCommands.getAttributeDescription(holder));
        }
        commandSourceStack.sendSuccess(() -> Component.translatable((String)"accessories.commands.attribute.modifier.remove.success_itemstack", (Object[])new Object[]{Component.translationArg((ResourceLocation)location), AccessoriesCommands.getAttributeDescription(holder), stack.getDisplayName()}), false);
        return 1;
    }

    private static Component getAttributeDescription(Holder<Attribute> attribute) {
        return Component.translatable((String)((Attribute)attribute.value()).getDescriptionId());
    }

    private static int adjustSlotValidationOnStack(String branch, boolean addSlot, String slotName, CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer targetEntity = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        targetEntity.getMainHandItem().update(AccessoriesDataComponents.SLOT_VALIDATION, (Object)AccessorySlotValidationComponent.EMPTY, component -> Objects.equals(branch, "valid") ? (addSlot ? component.addValidSlot(slotName) : component.removeValidSlot(slotName)) : (addSlot ? component.addInvalidSlot(slotName) : component.removeInvalidSlot(slotName)));
        ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.translatable((String)("accessories.commands.slot.validation." + (addSlot ? "added" : "removed") + "." + branch), (Object[])new Object[]{slotName}));
        return 1;
    }

    private static int createRenderStack(CommandContext<CommandSourceStack> ctx, ResourceLocation rendererId, ResourceLocation modelId, Component component, boolean isBundle) throws CommandSyntaxException {
        Item item = Items.STICK;
        try {
            if (((Boolean)ctx.getArgument("is_bundle", Boolean.class)).booleanValue()) {
                item = Items.BUNDLE;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ItemStack itemStack = item.getDefaultInstance();
        itemStack.set(DataComponents.ITEM_NAME, (Object)component);
        itemStack.set(AccessoriesDataComponents.CUSTOM_RENDERER, (Object)new AccessoryCustomRendererComponent(List.of(new RenderingFunction.DeferredRenderer(rendererId, Map.of(), RenderingFunction.ArmTarget.BOTH)), null, false));
        itemStack.set(DataComponents.ITEM_MODEL, (Object)modelId);
        itemStack.set(AccessoriesDataComponents.SLOT_VALIDATION, (Object)new AccessorySlotValidationComponent(Set.of("any"), Set.of()));
        ((CommandSourceStack)ctx.getSource()).getPlayerOrException().addItem(itemStack);
        return 1;
    }
}

