/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.commands;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Either;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.slot.SlotPath;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.data.EntitySlotLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.ParserUtils;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.SlotRange;
import net.minecraft.world.inventory.SlotRanges;
import org.jetbrains.annotations.Nullable;

public record AccessoriesMixedSlotArgument(String entityArgumentName) implements ArgumentType<Either<SlotPath, Integer>>
{
    private static final Collection<String> EXAMPLES = Arrays.asList("back/1", "charm/1", "feet.1", "weapon");
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_SLOT = new DynamicCommandExceptionType(object -> Component.translatableEscape((String)"slot.unknown", (Object[])new Object[]{object}));
    private static final DynamicCommandExceptionType ERROR_ONLY_SINGLE_SLOT_ALLOWED = new DynamicCommandExceptionType(object -> Component.translatableEscape((String)"slot.only_single_allowed", (Object[])new Object[]{object}));

    public static AccessoriesMixedSlotArgument slot(String entityArgumentName) {
        return new AccessoriesMixedSlotArgument(entityArgumentName);
    }

    public static Either<SlotPath, Integer> getSlot(CommandContext<CommandSourceStack> context, String name) {
        return (Either)context.getArgument(name, Either.class);
    }

    public Either<SlotPath, Integer> parse(StringReader reader) throws CommandSyntaxException {
        String string = ParserUtils.readWhile((StringReader)reader, c -> c != ' ');
        SlotPath slotPath = SlotPath.fromString(string);
        if (slotPath != null) {
            return Either.left((Object)slotPath);
        }
        Integer vanillaSlot = this.parseVanillaSlot(reader, string);
        if (vanillaSlot != null) {
            return Either.right((Object)vanillaSlot);
        }
        throw ERROR_UNKNOWN_SLOT.createWithContext((ImmutableStringReader)reader, (Object)string);
    }

    @Nullable
    public Integer parseVanillaSlot(StringReader reader, String string) throws CommandSyntaxException {
        SlotRange slotRange = SlotRanges.nameToIds((String)string);
        if (slotRange == null) {
            return null;
        }
        if (slotRange.size() != 1) {
            throw ERROR_ONLY_SINGLE_SLOT_ALLOWED.createWithContext((ImmutableStringReader)reader, (Object)string);
        }
        return slotRange.slots().getInt(0);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder suggestionsBuilder) {
        CompletableFuture completableFuture;
        Object object = commandContext.getSource();
        if (object instanceof CommandSourceStack) {
            ArrayList<Object> suggestions = new ArrayList<Object>();
            try {
                LivingEntity livingEntity;
                AccessoriesCapability capability;
                Entity entityTarget = EntityArgument.getEntity(commandContext, (String)this.entityArgumentName);
                if (entityTarget instanceof LivingEntity && (capability = (livingEntity = (LivingEntity)entityTarget).accessoriesCapability()) != null) {
                    suggestions.addAll(EntitySlotLoader.getEntitySlots(livingEntity).values().stream().flatMap(slotType -> {
                        ArrayList<String> slotPaths = new ArrayList<String>();
                        AccessoriesContainer container = capability.getContainer((SlotType)slotType);
                        if (container != null) {
                            for (int i = 0; i < container.getSize(); ++i) {
                                slotPaths.add(SlotPath.createBaseSlotPath(slotType, i));
                            }
                        }
                        return slotPaths.stream();
                    }).toList());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            suggestions.addAll(SlotRanges.singleSlotNames().toList());
            return SharedSuggestionProvider.suggest(suggestions, (SuggestionsBuilder)suggestionsBuilder);
        }
        if (object instanceof SharedSuggestionProvider) {
            SharedSuggestionProvider sharedSuggestionProvider = (SharedSuggestionProvider)object;
            completableFuture = sharedSuggestionProvider.customSuggestion(commandContext);
        } else {
            completableFuture = Suggestions.empty();
        }
        return completableFuture;
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

