/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.commands;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.commands.AccessoriesCommands;
import io.wispforest.accessories.data.SlotTypeLoader;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.resources.ResourceLocation;

public final class SlotArgumentType
implements ArgumentType<String> {
    public static final SlotArgumentType INSTANCE = new SlotArgumentType();

    public static String getSlot(CommandContext<CommandSourceStack> context, String name) {
        return (String)context.getArgument(name, String.class);
    }

    public String parse(StringReader reader) throws CommandSyntaxException {
        String slotName;
        ResourceLocation arg = ResourceLocation.read((StringReader)reader);
        String string = slotName = arg.getNamespace().equals("minecraft") ? arg.getPath() : arg.toString();
        if (slotName.equals("any")) {
            return "any";
        }
        SlotType slotType = SlotTypeLoader.INSTANCE.getSlotType(false, slotName);
        if (slotType == null) {
            throw AccessoriesCommands.INVALID_SLOT_TYPE.create();
        }
        return slotType.name();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        if (context.getSource() instanceof SharedSuggestionProvider) {
            StringReader stringReader = new StringReader(builder.getInput());
            stringReader.setCursor(builder.getStart());
            ArrayList<String> validSlots = new ArrayList<String>(SlotTypeLoader.INSTANCE.getEntries(false).values().stream().map(SlotType::name).toList());
            validSlots.addFirst("any");
            return SharedSuggestionProvider.suggest(validSlots, (SuggestionsBuilder)builder);
        }
        return Suggestions.empty();
    }
}

