/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.commands.api;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import io.wispforest.accessories.commands.api.ArgumentRegistrationCallback;
import io.wispforest.accessories.commands.api.CommandTreeGenerator;
import io.wispforest.accessories.commands.api.OnArgumentRegistration;
import io.wispforest.accessories.commands.api.base.BaseCommandGenerator;
import io.wispforest.accessories.commands.api.base.BranchedCommandGenerator;
import io.wispforest.accessories.commands.api.base.CommandGenerator;
import io.wispforest.accessories.commands.api.core.Key;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;

public class CommandGenerators {
    private static final List<Holder<?>> ALL_COMMAND_GENERATORS = new ArrayList();

    public static void create(CommandTreeGenerator<CommandSourceStack, CommandBuildContext, CommandGenerator> generateTrees) {
        CommandGenerators.create(generateTrees, (ArgumentRegistrationCallback argumentRegistration) -> {});
    }

    public static void create(CommandTreeGenerator<CommandSourceStack, CommandBuildContext, CommandGenerator> generateTrees, OnArgumentRegistration registration) {
        ALL_COMMAND_GENERATORS.add(new Holder<CommandGenerator>(new CommandGenerator(), generateTrees, registration));
    }

    public static void create(String key, CommandTreeGenerator<CommandSourceStack, CommandBuildContext, BranchedCommandGenerator> generateTrees) {
        CommandGenerators.create(key, generateTrees, argumentRegistration -> {});
    }

    public static void create(String key, CommandTreeGenerator<CommandSourceStack, CommandBuildContext, BranchedCommandGenerator> generateTrees, OnArgumentRegistration registrationConsumer) {
        ALL_COMMAND_GENERATORS.add(new Holder<BranchedCommandGenerator>(new BranchedCommandGenerator(new Key(key)), generateTrees, registrationConsumer));
    }

    public static void registerAllGenerators(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context, Commands.CommandSelection environment) {
        for (Holder<?> holder : ALL_COMMAND_GENERATORS) {
            holder.registerCommands(dispatcher, context, environment);
        }
    }

    public static void registerAllArgumentTypes(ArgumentRegistrationCallback registration) {
        for (Holder<?> holder : ALL_COMMAND_GENERATORS) {
            holder.registration().registerArgumentTypes(registration);
        }
    }

    private record Holder<G extends BaseCommandGenerator<CommandSourceStack, G>>(G generator, CommandTreeGenerator<CommandSourceStack, CommandBuildContext, G> treeGenerator, OnArgumentRegistration registration) {
        public void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context, Commands.CommandSelection environment) {
            this.treeGenerator.generateTrees(this.generator, context, environment);
            ((BaseCommandGenerator)this.generator).addToCommandsAndClear((string, builtRootNode) -> {
                if (!(builtRootNode instanceof LiteralArgumentBuilder)) {
                    throw new IllegalArgumentException("A root command node was found not to be a valid root literal!!!!");
                }
                LiteralArgumentBuilder literalArgumentBuilder = (LiteralArgumentBuilder)builtRootNode;
                dispatcher.register(literalArgumentBuilder);
            });
        }
    }
}

