/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.commands.api.core;

import io.wispforest.accessories.commands.api.base.Argument;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.SequencedCollection;
import org.jetbrains.annotations.Nullable;

public final class Key {
    private final List<String> path;

    public Key(String key) {
        this(key.split("/"));
    }

    public Key(String ... keyParts) {
        this(List.of(keyParts));
    }

    public Key(SequencedCollection<String> keyParts) {
        this.path = keyParts.stream().filter(string -> !string.isBlank()).toList();
    }

    public List<String> path() {
        return this.path;
    }

    public Key child(Key key) {
        ArrayList<String> parts = new ArrayList<String>(this.path);
        parts.addAll(key.path());
        return new Key(parts);
    }

    public Key child(String keyPart) {
        ArrayList<String> parts = new ArrayList<String>(this.path);
        if (!keyPart.isBlank()) {
            parts.add(keyPart);
        }
        return new Key(parts);
    }

    @Nullable
    public Key parent() {
        if (this.path.size() - 1 <= 0) {
            return null;
        }
        ArrayList<String> parts = new ArrayList<String>(this.path);
        parts.removeLast();
        return new Key(parts);
    }

    public boolean isEmpty() {
        return this.path().isEmpty();
    }

    public String topPath() {
        return this.path.getLast();
    }

    public List<Argument<?>> asArgumentList() {
        return this.path().stream().map(Argument::asKeyPath).toList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof Key)) return false;
        Key otherKey = (Key)obj;
        if (!this.path.equals(otherKey.path)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hashCode(this.path);
    }
}

