/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.compat.config.client.components;

import io.wispforest.owo.config.Option;
import io.wispforest.owo.config.annotation.RangeConstraint;
import io.wispforest.owo.config.ui.OptionComponents;
import io.wispforest.owo.config.ui.component.ConfigEnumButton;
import io.wispforest.owo.config.ui.component.ConfigSlider;
import io.wispforest.owo.config.ui.component.ConfigTextBox;
import io.wispforest.owo.config.ui.component.ConfigToggleButton;
import io.wispforest.owo.config.ui.component.SearchAnchorComponent;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.util.EventSource;
import io.wispforest.owo.util.NumberReflection;
import io.wispforest.owo.util.Observable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;

public class ConfigurableStructLayout<T>
extends FlowLayout {
    public final Map<Field, ComponentFactory<T, ?>> handlers = new LinkedHashMap();
    public boolean sideBySideFormat;
    public final UIModel model;
    public final String configName;
    public final Option.Key optionKey;

    protected ConfigurableStructLayout(Sizing horizontalSizing, Sizing verticalSizing, UIModel uiModel, Option<?> option, boolean sideBySideFormat) {
        super(horizontalSizing, verticalSizing, sideBySideFormat ? FlowLayout.Algorithm.HORIZONTAL : FlowLayout.Algorithm.VERTICAL);
        this.sideBySideFormat = sideBySideFormat;
        this.model = uiModel;
        this.configName = option.configName();
        this.optionKey = option.key();
    }

    protected ConfigurableStructLayout<T> build(T value) {
        this.handlers.forEach((field, handler) -> {
            MutableObject component = new MutableObject();
            String name = field.getName();
            String translationKey = "text.config." + this.configName + ".option." + this.optionKey.asString() + "." + name;
            component.setValue((Object)handler.createComponent(value, (Field)field, t -> ReflectOps.get(field, t), (t, f) -> ReflectOps.set(field, t, f), translationKey, (ParentComponent)this));
            this.child((Component)component.getValue());
        });
        return this;
    }

    public ConfigurableStructLayout<T> composeComponents(Class<T> clazz, List<Field> validFields, T value) {
        for (Field field : validFields) {
            Class<?> fieldClazz = field.getType();
            if (NumberReflection.isNumberType(fieldClazz)) {
                this.numberField(field, (Number)ReflectOps.get(field, value));
                continue;
            }
            if (fieldClazz == String.class) {
                this.stringField(field, (String)ReflectOps.get(field, value));
                continue;
            }
            if (fieldClazz == ResourceLocation.class) {
                this.identifierField(field, (ResourceLocation)ReflectOps.get(field, value));
                continue;
            }
            if (fieldClazz.isEnum()) {
                this.createEnumButton(field, (Enum)ReflectOps.get(field, value));
                continue;
            }
            if (fieldClazz == Boolean.TYPE || fieldClazz == Boolean.class) {
                this.createBooleanButton(field, (Boolean)ReflectOps.get(field, value));
                continue;
            }
            throw new IllegalArgumentException("Unable to handle the given field type found within the struct class! [ParentClass: " + clazz.getSimpleName() + ", FieldName: " + field.getName() + "]");
        }
        return this;
    }

    public static <T> ConfigurableStructLayout<T> of(Class<T> clazz, T value, UIModel uiModel, Option<?> option) {
        List<Field> validFields = Arrays.stream(clazz.getFields()).filter(field -> !Modifier.isStatic(field.getModifiers()) && !Modifier.isTransient(field.getModifiers())).toList();
        boolean sideBySideFormat = validFields.size() <= 2;
        return new ConfigurableStructLayout<T>(Sizing.expand(), Sizing.content(), uiModel, option, sideBySideFormat).composeComponents(clazz, validFields, value).build(value);
    }

    public <F extends Number> ConfigurableStructLayout<T> numberField(Field field, F defaultValue) {
        if (field.isAnnotationPresent(RangeConstraint.class)) {
            return this.rangeControlsHandle(field, defaultValue, NumberReflection.isFloatingPointType(field.getType()) ? field.getAnnotation(RangeConstraint.class).decimalPlaces() : 0);
        }
        return this.textBoxHandle(field, defaultValue, configTextBox -> configTextBox.configureForNumber(field.getType()));
    }

    public ConfigurableStructLayout<T> stringField(Field field, String defaultValue) {
        return this.textBoxHandle(field, defaultValue, configTextBox -> {});
    }

    public ConfigurableStructLayout<T> identifierField(Field field, ResourceLocation defaultValue) {
        return this.textBoxHandle(field, defaultValue, configTextBox -> {
            configTextBox.inputPredicate(s -> s.matches("[a-z0-9_.:\\-]*"));
            configTextBox.applyPredicate(s -> ResourceLocation.tryParse((String)s) != null);
            configTextBox.valueParser(ResourceLocation::parse);
        });
    }

    public <F> ConfigurableStructLayout<T> textBoxHandle(Field field, F defaultValue, Consumer<ConfigTextBox> processor) {
        return this.textBoxHandle(field, defaultValue, f -> f != null ? Objects.toString(f) : "", processor);
    }

    public <F> ConfigurableStructLayout<T> textBoxHandle(Field field, F defaultValue, Function<F, String> toStringFunc, Consumer<ConfigTextBox> processor) {
        this.handlers.put(field, this.textBoxFactory(defaultValue, toStringFunc, processor));
        return this;
    }

    public <F extends Number> ConfigurableStructLayout<T> rangeControlsHandle(Field field, F defaultValue, int decimalPlaces) {
        this.handlers.put(field, (t, field1, getter, setter, translationKey, parentComponent) -> {
            String name = field1.getName();
            boolean withDecimals = decimalPlaces > 0;
            Class<?> clazz = field.getType();
            Number value = (Number)getter.apply(t);
            FlowLayout optionComponent = (FlowLayout)this.model.expandTemplate(FlowLayout.class, "range-config-option", OptionComponents.packParameters((String)translationKey, (String)value.toString()));
            if (this.sideBySideFormat) {
                optionComponent.horizontalSizing(Sizing.expand((int)50));
            }
            RangeConstraint constraint = field.getAnnotation(RangeConstraint.class);
            double min = constraint.min();
            double max = constraint.max();
            ConfigSlider sliderInput = (ConfigSlider)optionComponent.childById(ConfigSlider.class, "value-slider");
            String fieldId = sliderInput.id() + "-" + name;
            sliderInput.id(fieldId);
            sliderInput.min(min).max(max).decimalPlaces(decimalPlaces).snap(!withDecimals).setFromDiscreteValue(value.doubleValue());
            sliderInput.valueType(clazz);
            ButtonComponent resetButton = (ButtonComponent)optionComponent.childById(ButtonComponent.class, "reset-button");
            resetButton.active = (withDecimals ? value.doubleValue() : (double)Math.round(value.doubleValue())) != defaultValue.doubleValue();
            resetButton.onPress(button -> {
                sliderInput.setFromDiscreteValue(defaultValue.doubleValue());
                button.active = false;
            });
            sliderInput.onChanged().subscribe(newValue -> {
                resetButton.active = (withDecimals ? newValue : (double)Math.round(newValue)) != defaultValue.doubleValue();
            });
            sliderInput.onChanged().subscribe(newValue -> setter.accept(t, (Number)((ConfigSlider)parentComponent.childById(ConfigSlider.class, fieldId)).parsedValue()));
            FlowLayout sliderControls = (FlowLayout)optionComponent.childById(FlowLayout.class, "slider-controls");
            ParentComponent textControls = (ParentComponent)this.textBoxFactory(defaultValue, Objects::toString, configTextBox -> {
                configTextBox.configureForNumber(clazz);
                Predicate predicate = configTextBox.applyPredicate();
                configTextBox.applyPredicate(predicate.and(s -> {
                    double parsed = Double.parseDouble(s);
                    return parsed >= min && parsed <= max;
                }));
            }).createComponent(t, field, getter, setter, translationKey, parentComponent);
            ((FlowLayout)textControls.childById(FlowLayout.class, "controls-flow")).positioning(Positioning.layout());
            ConfigTextBox textInput = (ConfigTextBox)textControls.childById(ConfigTextBox.class, "value-box-" + name);
            FlowLayout controlsLayout = (FlowLayout)optionComponent.childById(FlowLayout.class, "controls-flow");
            ButtonComponent toggleButton = (ButtonComponent)optionComponent.childById(ButtonComponent.class, "toggle-button");
            MutableBoolean textMode = new MutableBoolean(false);
            toggleButton.onPress(button -> {
                textMode.setValue(textMode.isFalse());
                if (textMode.isTrue()) {
                    sliderControls.remove();
                    textInput.text(sliderInput.decimalPlaces() == 0 ? String.valueOf((int)sliderInput.discreteValue()) : String.valueOf(sliderInput.discreteValue()));
                    controlsLayout.child((Component)textControls);
                } else {
                    textControls.remove();
                    sliderInput.setFromDiscreteValue(((Number)textInput.parsedValue()).doubleValue());
                    controlsLayout.child((Component)sliderControls);
                }
                button.tooltip((net.minecraft.network.chat.Component)(textMode.isTrue() ? net.minecraft.network.chat.Component.translatable((String)"text.owo.config.button.range.edit_with_slider") : net.minecraft.network.chat.Component.translatable((String)"text.owo.config.button.range.edit_as_text")));
            });
            return optionComponent;
        });
        return this;
    }

    private <F> ComponentFactory<T, F> textBoxFactory(F defaultValue, Function<F, String> toStringFunc, Consumer<ConfigTextBox> processor) {
        return (t, field1, getter, setter, translationKey, parentComponent) -> {
            FlowLayout optionComponent = (FlowLayout)this.model.expandTemplate(FlowLayout.class, "text-box-config-option", OptionComponents.packParameters((String)translationKey, (String)((String)toStringFunc.apply(getter.apply(t)))));
            if (this.sideBySideFormat) {
                optionComponent.horizontalSizing(Sizing.expand((int)50));
            }
            ConfigTextBox valueBox = (ConfigTextBox)optionComponent.childById(ConfigTextBox.class, "value-box");
            ButtonComponent resetButton = (ButtonComponent)optionComponent.childById(ButtonComponent.class, "reset-button");
            String fieldId = valueBox.id() + "-" + field1.getName();
            if (this.sideBySideFormat) {
                valueBox.horizontalSizing(Sizing.fixed((int)Math.round((float)((Sizing)valueBox.horizontalSizing().get()).value / 1.5f)));
            }
            valueBox.id(fieldId);
            resetButton.active = !valueBox.getValue().equals(toStringFunc.apply(defaultValue));
            resetButton.onPress(button -> {
                valueBox.setValue((String)toStringFunc.apply(defaultValue));
                button.active = false;
            });
            EventSource onChanged = valueBox.onChanged();
            onChanged.subscribe(s -> {
                resetButton.active = !s.equals(toStringFunc.apply(defaultValue));
            });
            onChanged.subscribe(s -> setter.accept(t, ((ConfigTextBox)parentComponent.childById(ConfigTextBox.class, fieldId)).parsedValue()));
            processor.accept(valueBox);
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> ((LabelComponent)optionComponent.childById(LabelComponent.class, "option-name")).text().getString();
            supplierArray[1] = () -> ((ConfigTextBox)valueBox).getValue();
            optionComponent.child((Component)new SearchAnchorComponent((ParentComponent)optionComponent, this.optionKey.child(field1.getName()), supplierArray));
            return optionComponent;
        };
    }

    public <F extends Enum<?>> ConfigurableStructLayout<T> createEnumButton(Field field, final F defaultValue) {
        ComponentFactory factory = new ComponentFactory<T, F>(){

            @Override
            public Component createComponent(T t, Field field, Function<T, F> getter, BiConsumer<T, F> setter, String translationKey, ParentComponent parentComponent) {
                FlowLayout optionComponent = (FlowLayout)ConfigurableStructLayout.this.model.expandTemplate(FlowLayout.class, "enum-config-option", OptionComponents.packParameters((String)translationKey, (String)((Enum)getter.apply(t)).toString()));
                if (ConfigurableStructLayout.this.sideBySideFormat) {
                    optionComponent.horizontalSizing(Sizing.expand((int)50));
                }
                ConfigEnumButton enumButton = (ConfigEnumButton)optionComponent.childById(ConfigEnumButton.class, "enum-button");
                ButtonComponent resetButton = (ButtonComponent)optionComponent.childById(ButtonComponent.class, "reset-button");
                if (ConfigurableStructLayout.this.sideBySideFormat) {
                    enumButton.horizontalSizing(Sizing.fixed((int)Math.round((float)((Sizing)enumButton.horizontalSizing().get()).value / 1.5f)));
                }
                Option tempOption = new Option(ConfigurableStructLayout.this.configName, ConfigurableStructLayout.this.optionKey.child(field.getName()), (Object)((Enum)getter.apply(t)), Observable.of((Object)((Enum)getter.apply(t))), new Option.BoundField(t, field), null, Option.SyncMode.NONE, null);
                enumButton.init(tempOption, defaultValue.ordinal());
                resetButton.active = true;
                resetButton.onPress(button -> {
                    enumButton.select(defaultValue.ordinal());
                    button.active = false;
                });
                enumButton.onPress(button -> {
                    resetButton.active = enumButton.parsedValue() != defaultValue;
                    setter.accept(t, (Enum)enumButton.parsedValue());
                });
                optionComponent.child((Component)new SearchAnchorComponent((ParentComponent)optionComponent, ConfigurableStructLayout.this.optionKey.child(field.getName()), new Supplier[]{() -> ((LabelComponent)optionComponent.childById(LabelComponent.class, "option-name")).text().getString(), () -> enumButton.getMessage().getString()}));
                return optionComponent;
            }
        };
        this.handlers.put(field, factory);
        return this;
    }

    public ConfigurableStructLayout<T> createBooleanButton(Field field, Boolean defaultValue) {
        ComponentFactory factory = new ComponentFactory<T, Boolean>(){

            @Override
            public Component createComponent(T t, Field field, Function<T, Boolean> getter, BiConsumer<T, Boolean> setter, String translationKey, ParentComponent parentComponent) {
                FlowLayout optionComponent = (FlowLayout)ConfigurableStructLayout.this.model.expandTemplate(FlowLayout.class, "boolean-toggle-config-option", OptionComponents.packParameters((String)translationKey, (String)getter.apply(t).toString()));
                if (ConfigurableStructLayout.this.sideBySideFormat) {
                    optionComponent.horizontalSizing(Sizing.expand((int)50));
                }
                ConfigToggleButton toggleButton = (ConfigToggleButton)optionComponent.childById(ConfigToggleButton.class, "toggle-button");
                ButtonComponent resetButton = (ButtonComponent)optionComponent.childById(ButtonComponent.class, "reset-button");
                if (ConfigurableStructLayout.this.sideBySideFormat) {
                    resetButton.horizontalSizing(Sizing.fixed((int)Math.round((float)((Sizing)resetButton.horizontalSizing().get()).value / 1.5f)));
                }
                Option tempOption = new Option(ConfigurableStructLayout.this.configName, ConfigurableStructLayout.this.optionKey.child(field.getName()), (Object)getter.apply(t), Observable.of((Object)getter.apply(t)), new Option.BoundField(t, field), null, Option.SyncMode.NONE, null);
                toggleButton.enabled(((Boolean)tempOption.value()).booleanValue());
                resetButton.active = tempOption.value() != tempOption.defaultValue();
                resetButton.onPress(button -> {
                    toggleButton.enabled(((Boolean)tempOption.defaultValue()).booleanValue());
                    button.active = false;
                });
                toggleButton.onPress(button -> {
                    resetButton.active = toggleButton.parsedValue() != tempOption.defaultValue();
                });
                optionComponent.child((Component)new SearchAnchorComponent((ParentComponent)optionComponent, ConfigurableStructLayout.this.optionKey.child(field.getName()), new Supplier[]{() -> ((LabelComponent)optionComponent.childById(LabelComponent.class, "option-name")).text().getString(), () -> toggleButton.getMessage().getString()}));
                return optionComponent;
            }
        };
        this.handlers.put(field, factory);
        return this;
    }

    static class ReflectOps {
        ReflectOps() {
        }

        static <F> void set(Field field, Object t, F f) {
            try {
                field.set(t, f);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        static <F> F get(Field field, Object t) {
            try {
                return (F)field.get(t);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        static <T> T defaultConstruct(Class<T> clazz) {
            try {
                return (T)clazz.getConstructors()[0].newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static interface ComponentFactory<T, F> {
        public Component createComponent(T var1, Field var2, Function<T, F> var3, BiConsumer<T, F> var4, String var5, ParentComponent var6);
    }
}

