/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.data;

import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.api.slot.UniqueSlotHandling;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.data.api.EndecDataLoader;
import io.wispforest.accessories.data.api.SyncedDataHelper;
import io.wispforest.accessories.impl.core.AccessoriesHolderImpl;
import io.wispforest.accessories.impl.slot.ExtraSlotTypeProperties;
import io.wispforest.accessories.impl.slot.StrictMode;
import io.wispforest.accessories.pond.ReplaceableJsonResourceReloadListener;
import io.wispforest.accessories.utils.CollectionUtils;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import it.unimi.dsi.fastutil.Pair;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SequencedMap;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class EntitySlotLoader
extends EndecDataLoader<RawEnityBinding>
implements SyncedDataHelper<SequencedMap<EntityType<?>, List<String>>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final EntitySlotLoader INSTANCE = new EntitySlotLoader();
    private Map<TagKey<EntityType<?>>, Map<String, SlotType>> tagToBoundSlots = new HashMap();
    private Map<EntityType<?>, Map<String, SlotType>> entityToBoundSlots = new HashMap();
    private SequencedMap<EntityType<?>, SequencedMap<String, SlotType>> server = new LinkedHashMap();
    private SequencedMap<EntityType<?>, SequencedMap<String, SlotType>> client = new LinkedHashMap();

    protected EntitySlotLoader() {
        super(Accessories.of("entity_slot_loader"), "accessories/entity", RawEnityBinding.ENDEC, PackType.SERVER_DATA, Set.of(SlotTypeLoader.INSTANCE.getId()));
        ReplaceableJsonResourceReloadListener.toggleValue(this);
    }

    public static Map<String, SlotType> getEntitySlots(LivingEntity livingEntity) {
        return EntitySlotLoader.getEntitySlots(livingEntity.level(), livingEntity.getType());
    }

    public static Map<String, SlotType> getEntitySlots(Level level, EntityType<?> entityType) {
        Map<String, SlotType> map = INSTANCE.getSlotTypes(level.isClientSide(), entityType);
        return map != null ? map : Map.of();
    }

    @Nullable
    public final Map<String, SlotType> getSlotTypes(boolean isClientSide, EntityType<?> entityType) {
        return this.getEntitySlotData(isClientSide).get(entityType);
    }

    @ApiStatus.Internal
    public final Map<EntityType<?>, Map<String, SlotType>> getEntitySlotData(boolean isClientSide) {
        return isClientSide ? this.client : this.server;
    }

    @Override
    public Endec<SequencedMap<EntityType<?>, List<String>>> syncDataEndec() {
        return Endec.map(LinkedHashMap::new, type -> BuiltInRegistries.ENTITY_TYPE.getKey(type).toString(), strType -> (EntityType)BuiltInRegistries.ENTITY_TYPE.getValue(ResourceLocation.parse((String)strType)), (Endec)Endec.STRING.listOf());
    }

    @Override
    public void onReceivedData(SequencedMap<EntityType<?>, List<String>> data) {
        LinkedHashMap<EntityType, LinkedHashMap<String, SlotType>> entitySlotTypes = new LinkedHashMap<EntityType, LinkedHashMap<String, SlotType>>();
        for (Map.Entry entry : data.entrySet()) {
            LinkedHashMap<String, SlotType> map = ((List)entry.getValue()).stream().map(string -> SlotTypeLoader.INSTANCE.getSlotType(true, (String)string)).collect(CollectionUtils.toLinkedMap(SlotType::name));
            entitySlotTypes.put((EntityType)entry.getKey(), map);
        }
        this.client = Collections.unmodifiableSequencedMap(entitySlotTypes);
        AccessoriesHolderImpl.clearValidationCache(true);
    }

    @Override
    public SequencedMap<EntityType<?>, List<String>> getServerData() {
        LinkedHashMap entitySlots = new LinkedHashMap();
        for (Map.Entry entry : this.server.entrySet()) {
            entitySlots.put((EntityType)entry.getKey(), List.copyOf(((SequencedMap)entry.getValue()).keySet()));
        }
        return entitySlots;
    }

    public void buildEntryMap() {
        LinkedHashMap<EntityType, SequencedMap> tempMap = new LinkedHashMap<EntityType, SequencedMap>();
        this.tagToBoundSlots.forEach((entityTag, slots) -> {
            Set entityTypes = BuiltInRegistries.ENTITY_TYPE.get(entityTag).map(holders -> holders.stream().map(Holder::value).collect(Collectors.toSet())).orElseGet(() -> {
                LOGGER.warn("[EntitySlotLoader]: Unable to locate the given EntityType Tag used within a slot entry: [Location: {}]", (Object)entityTag.location());
                return Set.of();
            });
            entityTypes.forEach(entityType -> tempMap.computeIfAbsent((EntityType)entityType, entityType1 -> new LinkedHashMap()).putAll(slots));
        });
        this.entityToBoundSlots.forEach((entityType, slots) -> tempMap.computeIfAbsent((EntityType)entityType, entityType1 -> new LinkedHashMap()).putAll(slots));
        LinkedHashMap finishMap = new LinkedHashMap();
        tempMap.forEach((entityType, slotsBuilder) -> finishMap.put((EntityType<?>)entityType, (SequencedMap<String, SlotType>)Collections.unmodifiableSequencedMap(slotsBuilder)));
        this.server = finishMap;
        AccessoriesHolderImpl.clearValidationCache(false);
        this.tagToBoundSlots.clear();
        this.entityToBoundSlots.clear();
    }

    protected void apply(Map<ResourceLocation, RawEnityBinding> rawData, ResourceManager resourceManager, ProfilerFiller profiler) {
        Map allSlotTypes = SlotTypeLoader.INSTANCE.getEntries(false);
        this.tagToBoundSlots.clear();
        this.entityToBoundSlots.clear();
        for (Map.Entry<ResourceLocation, RawEnityBinding> entry : rawData.entrySet()) {
            ResourceLocation location = entry.getKey();
            RawEnityBinding rawEnityBinding = entry.getValue();
            LinkedHashMap slots = new LinkedHashMap();
            rawEnityBinding.slotTypes().stream().map(slotName -> Pair.of((Object)slotName, (Object)((SlotType)allSlotTypes.get(Accessories.parseLocationOrDefault(slotName))))).forEach(slotInfo -> {
                SlotType slotType = (SlotType)slotInfo.right();
                if (slotType != null) {
                    if (!ExtraSlotTypeProperties.getProperty((String)slotInfo.left(), false).strictMode().equals((Object)StrictMode.FULL)) {
                        slots.put(slotType.name(), slotType);
                    } else {
                        LOGGER.warn("Unable to add the given slot [{}] to the given group due to it being in strict mode! [Location: {}]", slotInfo.left(), (Object)location);
                    }
                } else if (slotType == null) {
                    LOGGER.warn("Unable to locate a given slot [{}] to add to a given entity('s) as it was not registered: [Location: {}]", slotInfo.first(), (Object)location);
                }
            });
            rawEnityBinding.entityTargets().forEach(string -> {
                if (string.contains("#")) {
                    ResourceLocation entityTypeTagLocation = ResourceLocation.tryParse((String)string.replace("#", ""));
                    TagKey entityTypeTag = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)entityTypeTagLocation);
                    this.tagToBoundSlots.computeIfAbsent(entityTypeTag, entityTag -> new HashMap()).putAll(slots);
                } else {
                    Optional.ofNullable(ResourceLocation.tryParse((String)string)).flatMap(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ENTITY_TYPE).getOptional(arg_0)).ifPresentOrElse(entityType -> this.entityToBoundSlots.computeIfAbsent((EntityType<?>)entityType, entityType1 -> new HashMap()).putAll(slots), () -> LOGGER.warn("[EntitySlotLoader]: Unable to locate the given EntityType [{}] within the registries for a slot entry: [Location: {}]", string, (Object)location));
                }
            });
        }
        for (Map.Entry<Object, Object> entry : UniqueSlotHandling.getSlotToEntities().entrySet()) {
            SlotType slotType = (SlotType)SlotTypeLoader.INSTANCE.getEntries(false).get(Accessories.parseLocationOrDefault((String)entry.getKey()));
            for (EntityType entityType : (Set)entry.getValue()) {
                this.entityToBoundSlots.computeIfAbsent(entityType, entityType1 -> new LinkedHashMap()).put(slotType.name(), slotType);
            }
        }
    }

    public record RawEnityBinding(Set<String> entityTargets, Set<String> slotTypes) {
        public static final StructEndec<RawEnityBinding> ENDEC = StructEndecBuilder.of((StructField)Endec.STRING.setOf().fieldOf("entities", RawEnityBinding::entityTargets), (StructField)Endec.STRING.setOf().fieldOf("slots", RawEnityBinding::slotTypes), RawEnityBinding::new);
    }
}

