/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.data;

import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.slot.SlotGroup;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.api.slot.UniqueSlotHandling;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.data.api.ManagedEndecDataLoader;
import io.wispforest.accessories.data.api.SyncedDataHelper;
import io.wispforest.accessories.data.api.SyncedDataHelperManager;
import io.wispforest.accessories.impl.slot.ExtraSlotTypeProperties;
import io.wispforest.accessories.impl.slot.SlotGroupImpl;
import io.wispforest.accessories.pond.ReplaceableJsonResourceReloadListener;
import io.wispforest.accessories.utils.CollectionUtils;
import io.wispforest.accessories.utils.EndecUtils;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;

public class SlotGroupLoader
extends ManagedEndecDataLoader<SlotGroup, RawGroupData> {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final SlotGroupLoader INSTANCE = new SlotGroupLoader();

    protected SlotGroupLoader() {
        super(Accessories.of("slot_group_loader"), "accessories/group", SlotGroupImpl.ENDEC, RawGroupData.ENDEC, PackType.SERVER_DATA, Set.of(SlotTypeLoader.INSTANCE.getId()));
        ReplaceableJsonResourceReloadListener.toggleValue(this);
        SyncedDataHelperManager.registerLoader(SyncedDataHelper.of(Accessories.of("unique_slot_groups"), Endec.STRING.setOf(), UniqueSlotHandling::setClientGroups, () -> UniqueSlotHandling.getGroups(false), this.getId()));
        SyncedDataHelperManager.registerLoader(SyncedDataHelper.of(Accessories.of("extra_slot_type_properties"), ExtraSlotTypeProperties.ENDEC.mapOf(), ExtraSlotTypeProperties::setClientPropertyMap, () -> ExtraSlotTypeProperties.getProperties(false), this.getId()));
    }

    public static List<SlotGroup> getGroups(Level level) {
        return INSTANCE.getGroups(level.isClientSide(), true);
    }

    public static List<SlotGroup> getGroups(Level level, boolean filterUniqueGroups) {
        return INSTANCE.getGroups(level.isClientSide(), filterUniqueGroups);
    }

    public static Map<SlotGroup, List<SlotType>> getValidGroups(LivingEntity living) {
        Map<String, SlotType> entitySpecificSlots = EntitySlotLoader.getEntitySlots(living);
        List<SlotGroup> groups = SlotGroupLoader.getGroups(living.level(), false);
        return groups.stream().map(slotGroup -> {
            if (UniqueSlotHandling.isUniqueGroup(slotGroup.name(), living.level().isClientSide())) {
                return null;
            }
            List<SlotType> slots = slotGroup.slots().stream().filter(entitySpecificSlots::containsKey).map(slot -> SlotTypeLoader.getSlotType(living.level(), slot)).toList();
            return slots.isEmpty() ? null : Map.entry(slotGroup, slots);
        }).filter(Objects::nonNull).collect(CollectionUtils.toLinkedMap());
    }

    public static Optional<SlotGroup> getGroup(Level level, String group) {
        return Optional.ofNullable(INSTANCE.getGroup(level.isClientSide(), group));
    }

    public final List<SlotGroup> getGroups(boolean isClientSide, boolean filterUniqueGroups) {
        Collection groups = this.getEntries(isClientSide).values();
        if (filterUniqueGroups) {
            groups = groups.stream().filter(group -> !UniqueSlotHandling.isUniqueGroup(group.name(), isClientSide)).toList();
        }
        return List.copyOf(groups);
    }

    public final SlotGroup getGroup(boolean isClientSide, String group) {
        return (SlotGroup)this.getEntry(Accessories.parseLocationOrDefault(group), isClientSide);
    }

    public final Optional<SlotGroup> findGroup(boolean isClientSide, String slot) {
        for (SlotGroup entry : this.getGroups(isClientSide, false)) {
            if (!entry.slots().contains(slot)) continue;
            return Optional.of(entry);
        }
        return Optional.empty();
    }

    public final SlotGroup getOrDefaultGroup(boolean isClientSide, String slot) {
        Map groups = this.getEntries(isClientSide);
        for (SlotGroup entry : groups.values()) {
            if (!entry.slots().contains(slot)) continue;
            return entry;
        }
        return (SlotGroup)groups.get(Accessories.parseLocationOrDefault("any"));
    }

    @Override
    public Map<ResourceLocation, SlotGroup> mapFrom(Map<ResourceLocation, RawGroupData> rawData) {
        LinkedHashMap<String, SlotGroupBuilder> slotGroups = new LinkedHashMap<String, SlotGroupBuilder>();
        slotGroups.put("unsorted", new SlotGroupBuilder("unsorted").order(30));
        LinkedHashMap allSlots = new LinkedHashMap(SlotTypeLoader.INSTANCE.getEntries(false));
        rawData.forEach((location, rawGroupData) -> {
            String[] pathParts = location.getPath().split("/");
            Object groupName = pathParts[pathParts.length - 1];
            Object namespace = pathParts.length > 1 ? pathParts[0] + ":" : "";
            boolean isShared = ((String)namespace).isBlank();
            if (!isShared) {
                groupName = (String)namespace + ":" + (String)groupName;
            }
            SlotGroupBuilder group = slotGroups.computeIfAbsent((String)groupName, SlotGroupBuilder::new);
            if (isShared) {
                for (String s : rawGroupData.slots()) {
                    for (Map.Entry builderEntry : slotGroups.entrySet()) {
                        if (!((SlotGroupBuilder)builderEntry.getValue()).slots.contains(s)) continue;
                        LOGGER.error("Unable to assign a give slot [{}] to the group [{}] as it already exists within the group [{}]", new Object[]{s, group, builderEntry.getKey()});
                        return;
                    }
                    SlotType slotType = (SlotType)allSlots.remove(Accessories.parseLocationOrDefault(s));
                    if (slotType == null) {
                        LOGGER.warn("SlotType added to a given group without being in the main map for slots! [Name: {}]", (Object)s);
                        continue;
                    }
                    group.addSlot(slotType);
                }
                group.order(rawGroupData.order());
                group.icon(rawGroupData.icon());
            }
        });
        HashSet<SlotType> remainSlots = new HashSet<SlotType>();
        for (SlotType value : allSlots.values()) {
            String slotName = value.name();
            if (!UniqueSlotHandling.isUniqueSlot(slotName)) {
                remainSlots.add(value);
                continue;
            }
            String group = slotName.split(":")[0];
            slotGroups.computeIfAbsent(group, SlotGroupBuilder::new).order(5).addSlot(value);
            UniqueSlotHandling.addGroup(group);
        }
        ((SlotGroupBuilder)slotGroups.get("unsorted")).addSlots(remainSlots);
        return slotGroups.entrySet().stream().map(entry -> Map.entry(Accessories.parseLocationOrDefault((String)entry.getKey()), ((SlotGroupBuilder)entry.getValue()).build())).sorted(Map.Entry.comparingByValue().reversed()).collect(CollectionUtils.toLinkedMap());
    }

    public record RawGroupData(int order, Set<String> slots, ResourceLocation icon) {
        public static final StructEndec<RawGroupData> ENDEC = StructEndecBuilder.of((StructField)Endec.INT.fieldOf("order", RawGroupData::order), (StructField)EndecUtils.collectionOf(Endec.STRING, LinkedHashSet::new).fieldOf("slots", RawGroupData::slots), (StructField)MinecraftEndecs.IDENTIFIER.optionalFieldOf("icon", RawGroupData::icon, () -> SlotGroup.UNKNOWN), RawGroupData::new);
    }

    public static class SlotGroupBuilder {
        private final String name;
        private Integer order = null;
        private final Set<SlotType> slots = new HashSet<SlotType>();
        private ResourceLocation iconLocation = SlotGroup.UNKNOWN;

        public SlotGroupBuilder(String name) {
            this.name = name;
        }

        public SlotGroupBuilder order(Integer value) {
            this.order = value;
            return this;
        }

        public SlotGroupBuilder addSlot(SlotType value) {
            this.slots.add(value);
            return this;
        }

        public SlotGroupBuilder addSlots(Collection<SlotType> values) {
            this.slots.addAll(values);
            return this;
        }

        public SlotGroupBuilder icon(ResourceLocation location) {
            this.iconLocation = location;
            return this;
        }

        public SlotGroup build() {
            return new SlotGroupImpl(this.name, Optional.ofNullable(this.order).orElse(0), this.slots.stream().sorted(Comparator.naturalOrder().reversed()).map(SlotType::name).collect(Collectors.toCollection(LinkedHashSet::new)), this.iconLocation);
        }
    }
}

