/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.data.api;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.data.api.SyncedDataHelper;
import io.wispforest.accessories.data.api.SyncedDataHelperManager;
import io.wispforest.accessories.mixin.SimpleJsonResourceReloadListenerAccessor;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.owo.serialization.CodecUtils;
import io.wispforest.owo.serialization.RegistriesAttribute;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class EndecDataLoader<T>
extends SimpleJsonResourceReloadListener<T> {
    protected final String type;
    protected final ResourceLocation id;
    protected final Endec<T> endec;
    protected final Set<ResourceLocation> dependencies;
    protected final SerializationContext context;
    protected final boolean requiresRegistries;
    private final Function<// Could not load outer class - annotation placement on inner may be incorrect
    PreparableReloadListener.SharedState, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable HolderLookup.Provider> registriesAccess;

    protected EndecDataLoader(ResourceLocation id, String type, Endec<T> endec, PackType packType) {
        this(id, type, endec, packType, false);
    }

    protected EndecDataLoader(ResourceLocation id, String type, Endec<T> endec, PackType packType, Set<ResourceLocation> value) {
        this(id, type, endec, packType, SerializationContext.empty(), false, value);
    }

    protected EndecDataLoader(ResourceLocation id, String type, Endec<T> endec, PackType packType, boolean requiresRegistries) {
        this(id, type, endec, packType, SerializationContext.empty(), requiresRegistries);
    }

    protected EndecDataLoader(ResourceLocation id, String type, Endec<T> endec, PackType packType, SerializationContext context, boolean requiresRegistries) {
        this(id, type, endec, packType, context, requiresRegistries, Set.of());
    }

    protected EndecDataLoader(ResourceLocation id, String type, Endec<T> endec, PackType packType, SerializationContext context, boolean requiresRegistries, Set<ResourceLocation> value) {
        super(new DelegatingCodec<T>(endec.toString(), endec), FileToIdConverter.json((String)type));
        EndecDataLoader endecDataLoader;
        this.id = id;
        this.type = type;
        this.endec = endec;
        this.context = context;
        this.requiresRegistries = requiresRegistries;
        this.dependencies = value;
        this.registriesAccess = AccessoriesInternals.registerLoader(packType, this);
        if (packType.equals((Object)PackType.SERVER_DATA) && (endecDataLoader = this) instanceof SyncedDataHelper) {
            SyncedDataHelper syncedDataLoader = (SyncedDataHelper)((Object)endecDataLoader);
            SyncedDataHelperManager.registerLoader(syncedDataLoader);
        }
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public Set<ResourceLocation> getDependencyIds() {
        return this.dependencies;
    }

    public void prepareSharedState(PreparableReloadListener.SharedState sharedState) {
        super.prepareSharedState(sharedState);
        SerializationContext ctx = this.context;
        if (this.requiresRegistries) {
            HolderLookup.Provider registries = this.registriesAccess.apply(sharedState);
            Objects.requireNonNull(registries, "Can not add the registries to endec context for the ManagedEndecDataLoader: " + String.valueOf(this.getId()));
            ctx = ctx.withAttributes(new SerializationAttribute.Instance[]{RegistriesAttribute.fromInfoGetter((RegistryOps.RegistryInfoLookup)new RegistryOps.HolderLookupAdapter(registries))});
        }
        this.getCodec().setCodec(ctx);
    }

    @ApiStatus.Internal
    private DelegatingCodec<T> getCodec() {
        return (DelegatingCodec)((SimpleJsonResourceReloadListenerAccessor)((Object)this)).getCodec();
    }

    protected Map<ResourceLocation, T> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        Map entries = super.prepare(resourceManager, profiler);
        this.getCodec().resetCodec();
        return entries;
    }

    private static class DelegatingCodec<T>
    implements Codec<T> {
        private final String name;
        private final Endec<T> endec;
        @Nullable
        private Codec<T> codec = null;

        private DelegatingCodec(String name, Endec<T> endec) {
            this.name = name;
            this.endec = endec;
        }

        void setCodec(SerializationContext ctx) {
            this.codec = CodecUtils.toCodec(this.endec, (SerializationContext)ctx);
        }

        void resetCodec() {
            this.codec = null;
        }

        Codec<T> getOrThrow() {
            if (this.codec == null) {
                throw new IllegalStateException("Unable to get codec as such has yet to be setup with the proper context!");
            }
            return this.codec;
        }

        public <S> DataResult<Pair<T, S>> decode(DynamicOps<S> ops, S input) {
            return this.getOrThrow().decode(ops, input);
        }

        public <S> DataResult<S> encode(T input, DynamicOps<S> ops, S prefix) {
            return this.getOrThrow().encode(input, ops, prefix);
        }

        public String toString() {
            return "RecursiveCodec[" + this.name + "]";
        }
    }
}

