/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.data.api;

import io.wispforest.endec.Endec;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface SyncedDataHelper<D> {
    public static <D> SyncedDataHelper<D> of(final ResourceLocation id, final Endec<D> endec, final Consumer<D> onReceived, final Supplier<D> getDataSupplier, final ResourceLocation ... dependencies) {
        return new SyncedDataHelper<D>(){

            @Override
            public ResourceLocation getId() {
                return id;
            }

            @Override
            public Set<ResourceLocation> getDependencyIds() {
                return Set.of(dependencies);
            }

            @Override
            public Endec<D> syncDataEndec() {
                return endec;
            }

            @Override
            public D getServerData() {
                return getDataSupplier.get();
            }

            @Override
            public void onReceivedData(D data) {
                onReceived.accept(data);
            }
        };
    }

    public Endec<D> syncDataEndec();

    @ApiStatus.OverrideOnly
    public void onReceivedData(D var1);

    @ApiStatus.Internal
    @Nullable
    default public Exception onReceivedDataUnsafe(Object data) {
        try {
            this.onReceivedData(data);
        }
        catch (Exception e) {
            return e;
        }
        return null;
    }

    public ResourceLocation getId();

    public Set<ResourceLocation> getDependencyIds();

    @ApiStatus.OverrideOnly
    public D getServerData();
}

