/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.impl;

import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryNestContainerContents;
import io.wispforest.accessories.api.core.Accessory;
import io.wispforest.accessories.api.core.AccessoryNest;
import io.wispforest.accessories.api.core.AccessoryRegistry;
import io.wispforest.accessories.api.slot.SlotPath;
import io.wispforest.accessories.api.slot.SlotReference;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class AccessoryNestUtils {
    @Nullable
    public static AccessoryNestContainerContents getData(ItemStack stack) {
        Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(stack);
        if (!(accessory instanceof AccessoryNest)) {
            return null;
        }
        return (AccessoryNestContainerContents)stack.get(AccessoriesDataComponents.NESTED_ACCESSORIES);
    }

    @Nullable
    public static <T, S extends SlotPath> T recursiveStackHandling(ItemStack stack, S reference, BiFunction<ItemStack, S, @Nullable T> function) {
        AccessoryNestContainerContents data;
        Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(stack);
        T value = function.apply(stack, reference);
        if (accessory instanceof AccessoryNest && value == null && (data = AccessoryNestUtils.getData(stack)) != null) {
            ItemStack innerStack;
            List<ItemStack> innerStacks = data.accessories();
            for (int i = 0; i < innerStacks.size() && ((innerStack = innerStacks.get(i)).isEmpty() || (value = AccessoryNestUtils.recursiveStackHandling(innerStack, SlotPath.cloneWithInnerIndex(reference, i), function)) == null); ++i) {
            }
            if (reference instanceof SlotReference) {
                SlotReference ref = (SlotReference)reference;
                AccessoryNest.checkIfChangesOccurred(stack, ref.entity(), data);
            }
        }
        return value;
    }

    public static <S extends SlotPath> void recursiveStackConsumption(ItemStack stack, S reference, BiConsumer<ItemStack, S> consumer) {
        Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(stack);
        consumer.accept(stack, reference);
        if (!(accessory instanceof AccessoryNest)) {
            return;
        }
        AccessoryNestContainerContents data = AccessoryNestUtils.getData(stack);
        if (data != null) {
            List<ItemStack> innerStacks = data.accessories();
            for (int i = 0; i < innerStacks.size(); ++i) {
                ItemStack innerStack = innerStacks.get(i);
                if (innerStack.isEmpty()) continue;
                AccessoryNestUtils.recursiveStackConsumption(innerStack, SlotPath.cloneWithInnerIndex(reference, i), consumer);
            }
            if (reference instanceof SlotReference) {
                SlotReference ref = (SlotReference)reference;
                AccessoryNest.checkIfChangesOccurred(stack, ref.entity(), data);
            }
        }
    }

    public static <S extends SlotPath> void recursiveStackConsumption(ItemStack stack, Consumer<ItemStack> consumer) {
        Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(stack);
        consumer.accept(stack);
        if (!(accessory instanceof AccessoryNest)) {
            return;
        }
        AccessoryNestContainerContents data = AccessoryNestUtils.getData(stack);
        if (data != null) {
            List<ItemStack> innerStacks = data.accessories();
            for (ItemStack innerStack : innerStacks) {
                if (innerStack.isEmpty()) continue;
                AccessoryNestUtils.recursiveStackConsumption(innerStack, consumer);
            }
        }
    }
}

