/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.impl.core;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.core.Accessory;
import io.wispforest.accessories.api.core.AccessoryRegistry;
import io.wispforest.accessories.api.equip.EquipAction;
import io.wispforest.accessories.api.equip.EquipCheck;
import io.wispforest.accessories.api.slot.SlotPredicateRegistry;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.endec.NbtMapCarrier;
import io.wispforest.accessories.impl.AccessoryAttributeLogic;
import io.wispforest.accessories.impl.core.AccessoriesContainerImpl;
import io.wispforest.accessories.impl.core.AccessoriesHolderImpl;
import io.wispforest.accessories.impl.core.ExpandedContainer;
import io.wispforest.accessories.impl.slot.ExtraSlotTypeProperties;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.accessories.networking.client.SyncEntireContainer;
import io.wispforest.accessories.utils.InstanceEndec;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.util.MapCarrierDecodable;
import io.wispforest.endec.util.MapCarrierEncodable;
import io.wispforest.owo.serialization.RegistriesAttribute;
import it.unimi.dsi.fastutil.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@ApiStatus.Internal
public class AccessoriesCapabilityImpl
implements AccessoriesCapability,
InstanceEndec {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final LivingEntity entity;
    private boolean updateContainersLock = false;

    public AccessoriesCapabilityImpl(LivingEntity entity) {
        this.entity = entity;
    }

    @Override
    public LivingEntity entity() {
        return this.entity;
    }

    @Override
    public Map<String, AccessoriesContainer> getContainers() {
        AccessoriesHolderImpl holder = AccessoriesHolderImpl.getHolder(this);
        for (AccessoriesContainer container : holder.getAllSlotContainers().values()) {
            if (this.entity == container.capability().entity()) break;
            ((AccessoriesContainerImpl)container).capability = this;
        }
        return holder.getSlotContainers();
    }

    @Override
    public void reset(boolean loadedFromTag) {
        ServerPlayer serverPlayer;
        AccessoriesHolderImpl holder;
        block7: {
            block6: {
                Object currentContainers;
                if (this.entity.level().isClientSide()) {
                    return;
                }
                holder = AccessoriesInternals.getHolder(this.entity);
                if (!loadedFromTag) {
                    Map<String, AccessoriesContainer> oldContainers = Map.copyOf(holder.getAllSlotContainers());
                    holder.init(this);
                    currentContainers = holder.getAllSlotContainers();
                    oldContainers.forEach((arg_0, arg_1) -> AccessoriesCapabilityImpl.lambda$reset$0((Map)currentContainers, arg_0, arg_1));
                } else {
                    holder.init(this);
                }
                currentContainers = this.entity;
                if (!(currentContainers instanceof ServerPlayer)) break block6;
                serverPlayer = (ServerPlayer)currentContainers;
                if (serverPlayer.connection != null) break block7;
            }
            return;
        }
        NbtMapCarrier carrier = NbtMapCarrier.of();
        holder.encode((MapCarrierEncodable)carrier, SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{RegistriesAttribute.of((RegistryAccess)this.entity.level().registryAccess())}));
        AccessoriesNetworking.sendToTrackingAndSelf((Entity)serverPlayer, new SyncEntireContainer(serverPlayer.getId(), carrier));
    }

    @Override
    public void updateContainers() {
        boolean hasUpdateOccurred;
        if (this.updateContainersLock) {
            return;
        }
        Collection<AccessoriesContainer> containers = this.getContainers().values();
        this.updateContainersLock = true;
        do {
            hasUpdateOccurred = false;
            for (AccessoriesContainer container : containers) {
                if (!container.hasChanged()) continue;
                container.update();
                hasUpdateOccurred = true;
            }
        } while (hasUpdateOccurred);
        this.updateContainersLock = false;
    }

    @Override
    public void addTransientSlotModifiers(Multimap<String, AttributeModifier> modifiers) {
        Map<String, AccessoriesContainer> containers = this.getContainers();
        for (Map.Entry entry : modifiers.asMap().entrySet()) {
            if (!containers.containsKey(entry.getKey())) continue;
            AccessoriesContainer container = containers.get(entry.getKey());
            ((Collection)entry.getValue()).forEach(container::addTransientModifier);
        }
    }

    @Override
    public void addPersistentSlotModifiers(Multimap<String, AttributeModifier> modifiers) {
        Map<String, AccessoriesContainer> containers = this.getContainers();
        for (Map.Entry entry : modifiers.asMap().entrySet()) {
            if (!containers.containsKey(entry.getKey())) continue;
            AccessoriesContainer container = containers.get(entry.getKey());
            ((Collection)entry.getValue()).forEach(container::addPersistentModifier);
        }
    }

    @Override
    public void removeSlotModifiers(Multimap<String, AttributeModifier> modifiers) {
        Map<String, AccessoriesContainer> containers = this.getContainers();
        for (Map.Entry entry : modifiers.asMap().entrySet()) {
            if (!containers.containsKey(entry.getKey())) continue;
            AccessoriesContainer container = containers.get(entry.getKey());
            ((Collection)entry.getValue()).forEach(modifier -> container.removeModifier(modifier.id()));
        }
    }

    @Override
    public Multimap<String, AttributeModifier> getSlotModifiers() {
        HashMultimap modifiers = HashMultimap.create();
        this.getContainers().forEach((arg_0, arg_1) -> AccessoriesCapabilityImpl.lambda$getSlotModifiers$2((Multimap)modifiers, arg_0, arg_1));
        return modifiers;
    }

    @Override
    public void clearSlotModifiers() {
        this.getContainers().forEach((s, container) -> container.clearModifiers());
    }

    @Override
    public void clearCachedSlotModifiers() {
        HashMultimap slotModifiers = HashMultimap.create();
        Map<String, AccessoriesContainer> containers = this.getContainers();
        containers.forEach((name, container) -> {
            Set<AttributeModifier> modifiers = container.getCachedModifiers();
            if (modifiers.isEmpty()) {
                return;
            }
            ExpandedContainer accessories = container.getAccessories();
            for (int i = 0; i < accessories.getContainerSize(); ++i) {
                ItemStack stack = accessories.getItem(i);
                if (stack.isEmpty()) continue;
                SlotReference slotReference = container.createReference(i);
                slotModifiers.putAll(AccessoryAttributeLogic.getAttributeModifiers(stack, slotReference).getSlotModifiers());
            }
        });
        slotModifiers.asMap().forEach((name, modifiers) -> {
            if (!containers.containsKey(name)) {
                return;
            }
            AccessoriesContainer container = (AccessoriesContainer)containers.get(name);
            modifiers.forEach(container.getCachedModifiers()::remove);
            container.clearCachedModifiers();
        });
    }

    @Override
    @Nullable
    public Pair<SlotReference, EquipAction> canEquipAccessory(ItemStack stack, boolean allowSwapping, EquipCheck extraCheck) {
        Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(stack);
        if (accessory == null) {
            return null;
        }
        HashMap<String, AccessoriesContainer> validContainers = new HashMap<String, AccessoriesContainer>();
        if (stack.isEmpty() && allowSwapping) {
            Map<String, AccessoriesContainer> allContainers = this.getContainers();
            EntitySlotLoader.getEntitySlots(this.entity()).forEach((s, slotType) -> validContainers.put((String)s, (AccessoriesContainer)allContainers.get(slotType.name())));
        } else {
            for (AccessoriesContainer container : this.getContainers().values()) {
                boolean isValid;
                if (container.getSize() <= 0 || !(isValid = SlotPredicateRegistry.canInsertIntoSlot(stack, container.createReference(0))) || !ExtraSlotTypeProperties.getProperty(container.getSlotName(), this.entity.level().isClientSide()).allowEquipFromUse()) continue;
                if (allowSwapping) {
                    validContainers.put(container.getSlotName(), container);
                }
                ExpandedContainer accessories = container.getAccessories();
                for (int i = 0; i < container.getSize(); ++i) {
                    ItemStack slotStack = accessories.getItem(i);
                    SlotReference slotReference = container.createReference(i);
                    if (!slotStack.isEmpty() || !AccessoryRegistry.canUnequip(slotStack, slotReference) || !SlotPredicateRegistry.canInsertIntoSlot(stack, slotReference) || !extraCheck.isValid(slotStack, false)) continue;
                    return Pair.of((Object)container.createReference(i), newStack -> this.setStack(slotReference, newStack, false));
                }
            }
        }
        for (AccessoriesContainer validContainer : validContainers.values()) {
            ExpandedContainer accessories = validContainer.getAccessories();
            for (int i = 0; i < accessories.getContainerSize(); ++i) {
                ItemStack slotStack = accessories.getItem(i).copy();
                SlotReference slotReference = validContainer.createReference(i);
                if (slotStack.isEmpty() || !AccessoryRegistry.canUnequip(slotStack, slotReference) || !stack.isEmpty() && (!SlotPredicateRegistry.canInsertIntoSlot(stack, slotReference) || !extraCheck.isValid(slotStack, true))) continue;
                return Pair.of((Object)slotReference, newStack -> this.setStack(slotReference, newStack, true));
            }
        }
        return null;
    }

    private Optional<ItemStack> setStack(SlotReference reference, ItemStack newStack, boolean shouldSwapStacks) {
        ItemStack oldStack = reference.getStack();
        oldStack = oldStack == null ? ItemStack.EMPTY : oldStack.copy();
        Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(oldStack);
        if (shouldSwapStacks) {
            ItemStack splitStack;
            ItemStack itemStack = splitStack = newStack.isEmpty() ? ItemStack.EMPTY : newStack.split(accessory.maxStackSize(newStack));
            if (!this.entity.level().isClientSide()) {
                reference.setStack(splitStack);
            }
            return Optional.of(oldStack);
        }
        if (!this.entity.level().isClientSide()) {
            ItemStack splitStack = newStack.split(accessory.maxStackSize(newStack));
            reference.setStack(splitStack);
        }
        return Optional.empty();
    }

    @Override
    public void encode(MapCarrierEncodable carrier, SerializationContext ctx) {
        AccessoriesHolderImpl.getHolder(this).encode(carrier, ctx);
    }

    @Override
    public void decode(MapCarrierDecodable carrier, SerializationContext ctx) {
        AccessoriesHolderImpl.getHolder(this).decode(carrier, ctx);
    }

    private static /* synthetic */ void lambda$getSlotModifiers$2(Multimap modifiers, String s, AccessoriesContainer container) {
        modifiers.putAll((Object)s, container.getModifiers().values());
    }

    private static /* synthetic */ void lambda$reset$0(Map currentContainers, String s, AccessoriesContainer oldContainer) {
        AccessoriesContainer currentContainer = (AccessoriesContainer)currentContainers.get(s);
        currentContainer.getAccessories().setFromPrev(oldContainer.getAccessories());
        currentContainer.markChanged(false);
    }
}

