/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.menu;

import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.menu.AccessoriesBasedSlot;
import io.wispforest.accessories.api.slot.SlotPredicateRegistry;
import io.wispforest.accessories.api.slot.SlotType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class AccessoriesInternalSlot
extends AccessoriesBasedSlot {
    public final boolean isCosmetic;
    public boolean useCosmeticIcon = true;
    private Function<AccessoriesInternalSlot, Boolean> isActive = slot -> true;
    private Function<AccessoriesInternalSlot, Boolean> isAccessible = slot -> true;

    public AccessoriesInternalSlot(AccessoriesContainer container, boolean isCosmetic, int slot2, int x, int y) {
        super(container, isCosmetic ? container.getCosmeticAccessories() : container.getAccessories(), slot2, x, y);
        this.isCosmetic = isCosmetic;
    }

    public AccessoriesInternalSlot isActive(Function<AccessoriesInternalSlot, Boolean> isActive) {
        this.isActive = isActive;
        return this;
    }

    public AccessoriesInternalSlot isAccessible(Function<AccessoriesInternalSlot, Boolean> isAccessible) {
        this.isAccessible = isAccessible;
        return this;
    }

    public AccessoriesInternalSlot useCosmeticIcon(boolean value) {
        this.useCosmeticIcon = value;
        return this;
    }

    @Override
    public boolean isCosmeticSlot() {
        return this.isCosmetic;
    }

    @Override
    public ResourceLocation getNoItemIcon() {
        return this.isCosmetic && this.useCosmeticIcon ? Accessories.of("gui/slot/cosmetic") : super.getNoItemIcon();
    }

    @Override
    public List<Component> getTooltipData() {
        ArrayList<Component> tooltipData = new ArrayList<Component>();
        String key = this.isCosmetic ? "cosmetic_" : "";
        SlotType slotType = this.accessoriesContainer.slotType();
        tooltipData.add((Component)Component.translatable((String)Accessories.translationKey(key + "slot.tooltip.singular")).withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)slotType.translation()).withStyle(ChatFormatting.BLUE)));
        return tooltipData;
    }

    @Override
    public void set(ItemStack stack) {
        ItemStack prevStack = this.getItem();
        super.set(stack);
    }

    @Override
    public boolean mayPlace(ItemStack stack) {
        if (!this.isAccessible.apply(this).booleanValue()) {
            return false;
        }
        if (!this.isCosmeticSlot()) {
            return super.mayPlace(stack);
        }
        SlotType slotType = this.accessoriesContainer.slotType();
        return SlotPredicateRegistry.getPredicateResults(slotType.validators(), this.entity.level(), this.entity, slotType, 0, stack);
    }

    @Override
    public boolean mayPickup(Player player) {
        return this.isAccessible.apply(this) != false && (this.isCosmetic || super.mayPickup(player));
    }

    public boolean allowModification(Player player) {
        return this.isAccessible.apply(this) != false && super.allowModification(player);
    }

    public boolean isActive() {
        return this.isActive.apply(this) != false && super.isActive();
    }
}

