/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.menu;

import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public final class SlotAccessContainer
implements Container {
    private final SlotAccess slotAccess;

    public SlotAccessContainer(SlotAccess slotAccess) {
        this.slotAccess = slotAccess;
    }

    public static Container ofArmor(EquipmentSlot equipmentSlot, LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            return SlotAccessContainer.ofPlayerArmor(equipmentSlot, player);
        }
        return SlotAccessContainer.ofGenericArmor(equipmentSlot, livingEntity);
    }

    public static Container ofGenericArmor(EquipmentSlot equipmentSlot, LivingEntity livingEntity) {
        return new SlotAccessContainer(SlotAccess.forEquipmentSlot((LivingEntity)livingEntity, (EquipmentSlot)equipmentSlot));
    }

    @Nullable
    public static Container ofPlayerArmor(EquipmentSlot equipmentSlot, Player player) {
        int index = 39 - (switch (equipmentSlot) {
            case EquipmentSlot.HEAD -> 0;
            case EquipmentSlot.CHEST -> 1;
            case EquipmentSlot.LEGS -> 2;
            case EquipmentSlot.FEET -> 3;
            default -> -1;
        });
        if (index == 40) {
            return null;
        }
        return new SlotAccessContainer(SlotAccess.forContainer((Container)player.getInventory(), (int)index));
    }

    public int getContainerSize() {
        return 1;
    }

    public boolean isEmpty() {
        return this.getItem(0).isEmpty();
    }

    public ItemStack getItem(int slot) {
        return this.slotAccess.get();
    }

    public ItemStack removeItem(int slot, int amount) {
        ItemStack stack = this.getItem(0).copy();
        ItemStack removedStack = stack.split(amount);
        this.slotAccess.set(stack);
        return removedStack;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack stack = this.getItem(0).copy();
        this.slotAccess.set(ItemStack.EMPTY);
        return stack;
    }

    public void setItem(int slot, ItemStack stack) {
        this.slotAccess.set(stack);
    }

    public void setChanged() {
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void clearContent() {
    }
}

