/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.networking.client;

import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.core.Accessory;
import io.wispforest.accessories.api.core.AccessoryRegistry;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public record AccessoryBreak(int entityId, String slotName, int slotIndex) {
    public static StructEndec<AccessoryBreak> ENDEC = StructEndecBuilder.of((StructField)Endec.VAR_INT.fieldOf("entityId", AccessoryBreak::entityId), (StructField)Endec.STRING.fieldOf("slotName", AccessoryBreak::slotName), (StructField)Endec.VAR_INT.fieldOf("slotIndex", AccessoryBreak::slotIndex), AccessoryBreak::new);

    public static AccessoryBreak of(SlotReference slotReference) {
        return new AccessoryBreak(slotReference.entity().getId(), slotReference.slotName(), slotReference.index());
    }

    public static void handlePacket(AccessoryBreak packet, Player player) {
        Entity entity = player.level().getEntity(packet.entityId());
        if (!(entity instanceof LivingEntity)) {
            throw new IllegalStateException("Unable to handle a Break call due to the passed entity id not corresponding to a LivingEntity!");
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        SlotReference slotReference = SlotReference.of(livingEntity, packet.slotName(), packet.slotIndex());
        AccessoriesCapability capability = livingEntity.accessoriesCapability();
        AccessoriesContainer container = capability.getContainer(slotReference.type());
        ItemStack stack = container.getAccessories().getItem(slotReference.index());
        Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(stack);
        if (accessory != null) {
            accessory.onBreak(stack, slotReference);
        }
    }
}

