/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import org.slf4j.Logger;

public class JsonUtils {
    private static final Gson GSON = new GsonBuilder().setLenient().setPrettyPrinting().create();
    private static final Logger LOGGER = LogUtils.getLogger();

    public static <T> Map<ResourceLocation, Resource> scanDirectoryWithReplace(ResourceManager resourceManager, FileToIdConverter fileToIdConverter) {
        LinkedHashMap<ResourceLocation, FileResourceData> outputResources = new LinkedHashMap<ResourceLocation, FileResourceData>();
        for (Map.Entry entry2 : fileToIdConverter.listMatchingResourceStacks(resourceManager).entrySet()) {
            ResourceLocation filePath = (ResourceLocation)entry2.getKey();
            ResourceLocation resourceLocation = fileToIdConverter.fileToId((ResourceLocation)entry2.getKey());
            for (Resource resource : (List)entry2.getValue()) {
                try {
                    BufferedReader reader = resource.openAsReader();
                    try {
                        JsonElement jsonElement = (JsonElement)GsonHelper.fromJson((Gson)GSON, (Reader)reader, JsonElement.class);
                        if (!(jsonElement instanceof JsonObject)) {
                            LOGGER.warn("File was found not to be parsed as a valid JsonObject, it will be skipped: [Location: " + String.valueOf(filePath) + "]");
                            continue;
                        }
                        JsonObject jsonObject = (JsonObject)jsonElement;
                        if (outputResources.containsKey(resourceLocation)) {
                            JsonObject jsonObject2 = ((FileResourceData)outputResources.get(resourceLocation)).obj().getAsJsonObject();
                            if (!GsonHelper.getAsBoolean((JsonObject)jsonObject, (String)"replace")) continue;
                            jsonObject.asMap().forEach((arg_0, arg_1) -> ((JsonObject)jsonObject2).add(arg_0, arg_1));
                            continue;
                        }
                        outputResources.put(resourceLocation, new FileResourceData(filePath, jsonObject, resource));
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (JsonParseException | IOException | IllegalArgumentException var14) {
                    LOGGER.error("Couldn't parse data file {} from {}", new Object[]{resourceLocation, filePath, var14});
                }
            }
        }
        return outputResources.entrySet().stream().collect(Collectors.toMap(entry -> ((FileResourceData)entry.getValue()).fileLocation(), entry -> ((FileResourceData)entry.getValue()).resource(), (object, object2) -> object, LinkedHashMap::new));
    }

    public record FileResourceData(ResourceLocation fileLocation, JsonObject obj, Resource resource) {
    }
}

