package io.wispforest.accessories;

import Z;
import com.google.common.reflect.Reflection;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.api.data.AccessoriesTags;
import io.wispforest.accessories.api.events.AllowEntityModificationCallback;
import io.wispforest.accessories.commands.AccessoriesCommands;
import io.wispforest.accessories.compat.config.AccessoriesConfig;
import io.wispforest.accessories.criteria.AccessoryChangedCriterion;
import io.wispforest.accessories.data.CustomRendererLoader;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.data.SlotGroupLoader;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.impl.event.VanillaItemPredicates;
import io.wispforest.accessories.impl.option.AccessoriesPlayerOptionsHolder;
import io.wispforest.accessories.menu.AccessoriesMenuVariant;
import io.wispforest.accessories.menu.ArmorSlotTypes;
import io.wispforest.accessories.mixin.CriteriaTriggersAccessor;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.accessories.networking.client.ScreenVariantPing;
import io.wispforest.accessories.utils.EndecUtils;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3966;
import net.minecraft.class_6025;
import net.minecraft.class_8942;
import net.minecraft.class_8942.class_11340;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;
import org.slf4j.Logger;

import java.util.function.Consumer;
import java.util.function.Function;

public class Accessories {

    public static final Logger LOGGER = LogUtils.getLogger();

    public static final class_2960 SLOT_LOADER_LOCATION = Accessories.of("slot_loader");
    public static final class_2960 ENTITY_SLOT_LOADER_LOCATION = Accessories.of("entity_slot_loader");
    public static final class_2960 SLOT_GROUP_LOADER_LOCATION = Accessories.of("slot_group_loader");
    public static final class_2960 DATA_RELOAD_HOOK = Accessories.of("data_reload_hook");

    public static final boolean DEBUG;

    static {
        boolean debug = AccessoriesLoaderInternals.isDevelopmentEnv();

        if (System.getProperty("accessories.debug") != null) {
            debug = Boolean.getBoolean("accessories.debug");
        }


        DEBUG = debug;
    }

    @ApiStatus.Internal
    public static class_1928.class_4313<class_1928.class_4310> RULE_KEEP_ACCESSORY_INVENTORY = null;

    public static final String MODID = "accessories";

    public static class_2960 of(String path){
        return class_2960.method_60655(MODID, path);
    }

    public static class_2960 parseLocationOrDefault(String s){
        var location = class_2960.method_12829(s);

        if (location == null) location = Accessories.of(s);

        return location;
    }

    public static String translationKey(String path){
        return MODID + "." + path;
    }

    public static class_2561 translation(String path) {
        return class_2561.method_43471(translationKey(path));
    }

    //--

    private static final AccessoriesConfig CONFIG = AccessoriesConfig.createAndLoad(serializationBuilder -> {
        serializationBuilder.addEndec(Vector2i.class, EndecUtils.VECTOR_2_I_ENDEC);
        serializationBuilder.addEndec(AccessoriesPlayerOptionsHolder.class, AccessoriesPlayerOptionsHolder.ENDEC);
    });

    public static AccessoriesConfig config(){
        return CONFIG;
    }

    //--

    public static void askPlayerForVariant(class_3222 player) {
        askPlayerForVariant(player, null);
    }

    public static void askPlayerForVariant(class_3222 player, @Nullable class_1309 targetEntity) {
        AccessoriesNetworking.sendToPlayer(player, ScreenVariantPing.of(targetEntity));
    }

    public static boolean attemptOpenScreenPlayer(class_3222 player, AccessoriesMenuVariant variant) {
        var result = class_1675.method_49998(player, e -> e instanceof class_1309, player.method_55755());

        if(!(result instanceof class_3966 entityHitResult)) return false;

        Accessories.openAccessoriesMenu(player, variant, (class_1309) entityHitResult.method_17782());

        return true;
    }

    public static void openAccessoriesMenu(class_1657 player, AccessoriesMenuVariant variant, @Nullable class_1309 targetEntity) {
        openAccessoriesMenu(player, variant, targetEntity, null);
    }

    public static void openAccessoriesMenu(class_1657 player, AccessoriesMenuVariant variant, @Nullable class_1309 targetEntity, @Nullable class_1799 carriedStack) {
        if(targetEntity != null && !player.equals(targetEntity)) {
            var result = AllowEntityModificationCallback.EVENT.invoker().allowModifications(targetEntity, player, null);

            if(!result.orElse(false)) return;
        }

        AccessoriesInternals.openAccessoriesMenu(player, variant, targetEntity, carriedStack);
    }

    //--

    public static AccessoryChangedCriterion ACCESSORY_EQUIPPED;
    public static AccessoryChangedCriterion ACCESSORY_UNEQUIPPED;

    public static void init() {
        Reflection.initialize(SlotTypeLoader.class, SlotGroupLoader.class, EntitySlotLoader.class, CustomRendererLoader.class);

        AccessoriesCommands.init();

        AllowEntityModificationCallback.EVENT.register((target, player, reference) -> {
            var type = target.method_5864();

            if(type.method_20210(AccessoriesTags.MODIFIABLE_ENTITY_BLACKLIST)) return TriState.FALSE;

            var isOwnersPet = (target instanceof class_6025 ownableEntity && ownableEntity.method_35057() != null && ownableEntity.method_35057().equals(player));

            if(isOwnersPet || type.method_20210(AccessoriesTags.MODIFIABLE_ENTITY_WHITELIST)) return TriState.TRUE;

            return TriState.DEFAULT;
        });

        ArmorSlotTypes.INSTANCE.init();

        VanillaItemPredicates.init();
    }

    public static void registerCriteria(){
        ACCESSORY_EQUIPPED = CriteriaTriggersAccessor.accessories$callRegister("accessories:equip_accessory", new AccessoryChangedCriterion());
        ACCESSORY_UNEQUIPPED = CriteriaTriggersAccessor.accessories$callRegister("accessories:unequip_accessory", new AccessoryChangedCriterion());
    }

    //--

    public static <T> T handleIoError(String dataName, Function<class_8942.class_11340, T> function) {
        return handleIoError(() -> dataName, function);
    }

    public static <T> T handleIoError(class_8942.class_11336 pathElement, Function<class_8942.class_11340, T> function) {
        try (var scopedCollector = new class_8942.class_11340(pathElement, Accessories.LOGGER)) {
            return function.apply(scopedCollector);
        }
    }

    public static void handleIoError(String dataName, Consumer<class_8942.class_11340> function) {
        handleIoError(() -> dataName, function);
    }

    public static void handleIoError(class_8942.class_11336 pathElement, Consumer<class_8942.class_11340> function) {
        try (var scopedCollector = new class_8942.class_11340(pathElement, Accessories.LOGGER)) {
            function.accept(scopedCollector);
        }
    }
}