package io.wispforest.accessories;

import com.google.common.collect.Multimap;
import com.google.gson.JsonObject;
import dev.architectury.injectables.annotations.ExpectPlatform;
import io.wispforest.accessories.data.api.EndecDataLoader;
import io.wispforest.accessories.impl.core.AccessoriesHolderImpl;
import io.wispforest.accessories.impl.option.AccessoriesPlayerOptionsHolder;
import io.wispforest.accessories.menu.AccessoriesMenuVariant;
import io.wispforest.endec.Endec;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.class_10712;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.class_3917;
import net.minecraft.class_4080;
import net.minecraft.class_6880;
import net.minecraft.class_6903;

/**
 * Util Class implemented though Architectury Plugin allowing for various access to platform specific way
 * of getting class instances
 */
@ApiStatus.Internal
public class AccessoriesInternals {

    @Nullable
    public static class_1304 INTERNAL_SLOT = null;

    @Nullable
    public static class_1304.class_1305 ACCESSORIES_TYPE = null;

    /**
     * @return {@link AccessoriesHolderImpl} attached to a given {@link class_1309} based on the Platforms method for getting it
     */
    @ExpectPlatform
    public static AccessoriesHolderImpl getHolder(class_1309 livingEntity) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static void modifyHolder(class_1309 livingEntity, UnaryOperator<AccessoriesHolderImpl> modifier) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static AccessoriesPlayerOptionsHolder getPlayerOptions(class_1657 player) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static void modifyPlayerOptions(class_1657 player, UnaryOperator<AccessoriesPlayerOptionsHolder> modifier) {
        throw new AssertionError();
    }

    //--

    @ExpectPlatform
    public static void giveItemToPlayer(class_3222 player, class_1799 stack) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static boolean isValidOnConditions(JsonObject object, String dataType, class_2960 key, class_4080 listener, @Nullable class_6903.class_7863 registryInfo) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static <T extends class_1703, D> class_3917<T> registerMenuType(class_2960 location, Endec<D> endec, TriFunction<Integer, class_1661, D, T> func) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static void openAccessoriesMenu(class_1657 player, AccessoriesMenuVariant variant, @Nullable class_1309 targetEntity, @Nullable class_1799 carriedStack) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static void addAttributeTooltips(@Nullable class_1657 player, class_1799 stack, Multimap<class_6880<class_1320>, class_1322> multimap, Consumer<class_2561> tooltipAddCallback, class_10712 display, class_1792.class_9635 context, class_1836 flag) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static Function<class_3302.class_11558, class_7225.@Nullable class_7874> registerLoader(class_3264 type, EndecDataLoader<?> loader) {
        throw new AssertionError();
    }
}
