package io.wispforest.accessories.api;

import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.attributes.AccessoryAttributeUtils;
import io.wispforest.accessories.api.core.Accessory;
import io.wispforest.accessories.api.core.AccessoryRegistry;
import io.wispforest.accessories.api.slot.SlotBasedPredicate;
import io.wispforest.accessories.api.slot.SlotPredicateRegistry;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.impl.AccessoryAttributeLogic;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1263;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_6880;

/**
 * Class containing the bulk of API calls for either registering {@link Accessory} instances, new {@link SlotBasedPredicate}s and more.
 */
@Deprecated(forRemoval = true)
public class AccessoriesAPI {

    /**
     * Registers an accessory implementation for a given item.
     */
    @Deprecated(forRemoval = true)
    public static void registerAccessory(class_1792 item, Accessory accessory) {
        AccessoryRegistry.register(item, accessory);
    }

    /**
     * @return the accessory bound to this stack or {@code null} if there is none
     */
    @Deprecated(forRemoval = true)
    @Nullable
    public static Accessory getAccessory(class_1799 stack){
        return AccessoryRegistry.getAccessoryOrDefault(stack);
    }

    /**
     * @return the accessory bound to this item or {@code null} if there is none
     */
    @Deprecated(forRemoval = true)
    @Nullable
    public static Accessory getAccessory(class_1792 item) {
        return AccessoryRegistry.getAccessory(item);
    }

    /**
     * @return the accessory bound to this stack or {@link #defaultAccessory()} if there is none
     */
    @Deprecated(forRemoval = true)
    public static Accessory getOrDefaultAccessory(class_1799 stack){
        return AccessoryRegistry.getAccessoryOrDefault(stack);
    }

    /**
     * @return the accessory bound to this item or {@link #defaultAccessory()} if there is none
     */
    @Deprecated(forRemoval = true)
    public static Accessory getOrDefaultAccessory(class_1792 item){
        return AccessoryRegistry.getAccessoryOrDefault(item);
    }

    /**
     * @return the default accessory implementation
     */
    @Deprecated(forRemoval = true)
    public static Accessory defaultAccessory(){
        return AccessoryRegistry.defaultAccessory();
    }

    @Deprecated(forRemoval = true)
    public static boolean isDefaultAccessory(Accessory accessory) {
        return AccessoryRegistry.isDefaultAccessory(accessory);
    }

    /**
     * @return If a given {@link class_1799} is found either to have an {@link Accessory} besides the
     * default or if the given stack has valid slots which it can be equipped
     */
    @Deprecated(forRemoval = true)
    public static boolean isValidAccessory(class_1799 stack, class_1937 level){
        return SlotPredicateRegistry.isValidAccessory(stack, level);
    }

    @Deprecated(forRemoval = true)
    public static boolean isValidAccessory(class_1799 stack, class_1937 level, @Nullable class_1309 entity){
        return SlotPredicateRegistry.isValidAccessory(stack, level, entity);
    }

    //--

    @Deprecated(forRemoval = true)
    public static AccessoryAttributeBuilder getAttributeModifiers(class_1799 stack, SlotReference slotReference){
        return AccessoryAttributeLogic.getAttributeModifiers(stack, slotReference, false);
    }

    @Deprecated(forRemoval = true)
    public static AccessoryAttributeBuilder getAttributeModifiers(class_1799 stack, SlotReference slotReference, boolean useTooltipCheck){
        return AccessoryAttributeLogic.getAttributeModifiers(stack, slotReference.entity(), slotReference.slotName(), slotReference.index(), useTooltipCheck);
    }

    @Deprecated(forRemoval = true)
    public static AccessoryAttributeBuilder getAttributeModifiers(class_1799 stack, String slotName, int slot){
        return AccessoryAttributeLogic.getAttributeModifiers(stack, null, slotName, slot);
    }

    @Deprecated(forRemoval = true)
    public static AccessoryAttributeBuilder getAttributeModifiers(class_1799 stack, @Nullable class_1309 entity, String slotName, int slot){
        return AccessoryAttributeLogic.getAttributeModifiers(stack, entity, slotName, slot, false);
    }

    /**
     * Attempts to get any at all AttributeModifier's found on the stack either though NBT or the Accessory bound
     * to the {@link class_1799}'s item
     */
    @Deprecated(forRemoval = true)
    public static AccessoryAttributeBuilder getAttributeModifiers(class_1799 stack, @Nullable class_1309 entity, String slotName, int slot, boolean hideTooltipIfDisabled){
        return AccessoryAttributeLogic.getAttributeModifiers(stack, entity, slotName, slot, hideTooltipIfDisabled);
    }

    @Deprecated(forRemoval = true)
    public static void addAttribute(class_1799 stack, String slotName, class_6880<class_1320> attribute, class_2960 location, double amount, class_1322.class_1323 operation, boolean isStackable) {
        AccessoryAttributeUtils.addAttribute(stack, slotName, attribute, location, amount, operation, isStackable);
    }

    //--

    /**
     * @return {@link UUID} based on the provided {@link SlotType#name} and entry index
     */
    @Deprecated(forRemoval = true)
    public static class_2960 createSlotLocation(SlotType slotType, int index) {
        return createSlotLocation(slotType.name(), index);
    }

    /**
     * @return {@link UUID} based on the provided slot name and entry index
     */
    @Deprecated(forRemoval = true)
    public static class_2960 createSlotLocation(String slotName, int index) {
        return Accessories.of(slotName.replace(":", "_") + "/" + index);
    }

    //--

    /**
     * Used to check if the given {@link class_1799} is valid for the given LivingEntity and SlotReference
     * based on {@link SlotBasedPredicate}s bound to the Slot and the {@link Accessory} bound to the stack if present
     */
    @Deprecated(forRemoval = true)
    public static boolean canInsertIntoSlot(class_1799 stack, SlotReference reference){
        return SlotPredicateRegistry.canInsertIntoSlot(stack, reference);
    }

    /**
     * Method used to check weather or not the given stack can be equipped within the slot referenced
     *
     * @param stack
     * @param reference
     * @return if the stack can be equipped or not
     */
    @Deprecated(forRemoval = true)
    public static boolean canEquip(class_1799 stack, SlotReference reference){
        return AccessoryRegistry.canEquip(stack, reference);
    }

    /**
     * Method used to check weather or not the given stack can be unequipped within the slot referenced
     *
     * @param stack
     * @param reference
     * @return if the stack can be unequipped or not
     */
    @Deprecated(forRemoval = true)
    public static boolean canUnequip(class_1799 stack, SlotReference reference){
        return AccessoryRegistry.canUnequip(stack, reference);
    }

    /**
     * @return All valid {@link SlotType}s for the given {@link class_1799} based on the {@link class_1309}
     * available {@link SlotType}s
     */
    @Deprecated(forRemoval = true)
    public static Collection<SlotType> getValidSlotTypes(class_1309 entity, class_1799 stack){
        return SlotPredicateRegistry.getValidSlotTypes(entity, stack);
    }

    @Deprecated(forRemoval = true)
    public static Collection<SlotType> getStackSlotTypes(class_1937 level, class_1799 stack){
        return SlotPredicateRegistry.getStackSlotTypes(level, null, stack);
    }

    @Deprecated(forRemoval = true)
    public static Collection<SlotType> getStackSlotTypes(class_1309 entity, class_1799 stack) {
        return SlotPredicateRegistry.getStackSlotTypes(entity.method_73183(), entity, stack);
    }

    @Deprecated(forRemoval = true)
    public static Collection<SlotType> getStackSlotTypes(class_1937 level, @Nullable class_1309 entity, class_1799 stack) {
        return SlotPredicateRegistry.getStackSlotTypes(level, entity, stack);
    }

    @Deprecated(forRemoval = true)
    public static Collection<SlotType> getUsedSlotsFor(class_1657 player) {
        return AccessoriesCapability.getUsedSlotsFor(player);
    }

    @Deprecated(forRemoval = true)
    public static Collection<SlotType> getUsedSlotsFor(class_1309 entity, class_1263 container) {
        return AccessoriesCapability.getUsedSlotsFor(entity, container);
    }

    @Deprecated(forRemoval = true)
    public static void breakStack(SlotReference reference){
        reference.breakStack();
    }

    //--

    @Deprecated(forRemoval = true)
    @Nullable
    public static SlotBasedPredicate getPredicate(class_2960 location) {
        return SlotPredicateRegistry.getPredicate(location);
    }

    @Deprecated(forRemoval = true)
    public static void registerPredicate(class_2960 location, SlotBasedPredicate predicate) {
        SlotPredicateRegistry.register(location, predicate);
    }

    @Deprecated(forRemoval = true)
    public static boolean getPredicateResults(Set<class_2960> predicateIds, class_1937 level, SlotType slotType, int index, class_1799 stack){
        return SlotPredicateRegistry.getPredicateResults(predicateIds, level, null, slotType, index, stack);
    }

    @Deprecated(forRemoval = true)
    public static boolean getPredicateResults(Set<class_2960> predicateIds, class_1937 level, @Nullable class_1309 entity, SlotType slotType, int index, class_1799 stack){
        return SlotPredicateRegistry.getPredicateResults(predicateIds, level, entity, slotType, index, stack);
    }
}