package io.wispforest.accessories.api;

import io.wispforest.accessories.impl.core.ExpandedContainer;
import java.util.Map;
import net.minecraft.class_1263;

public record SimpleAccessoriesStorage(boolean isClientSide, String slotName, int size, Map<Integer, Boolean> renderOptions, class_1263 accessories, class_1263 cosmeticAccessories) implements AccessoriesStorage {

    public static AccessoriesStorage copy(AccessoriesStorage storage) {
        return new SimpleAccessoriesStorage(
            storage.isClientSide(),
            storage.getSlotName(),
            storage.getSize(),
            storage.renderOptions(),
            copyContainer(storage.getAccessories()),
            copyContainer(storage.getCosmeticAccessories())
        );
    }

    @Override
    public String getSlotName() {
        return slotName;
    }

    @Override
    public class_1263 getAccessories() {
        return accessories;
    }

    @Override
    public class_1263 getCosmeticAccessories() {
        return cosmeticAccessories;
    }

    @Override
    public int getSize() {
        return size;
    }

    private static class_1263 copyContainer(class_1263 container) {
        if (container instanceof ExpandedContainer expandedContainer) {
            return expandedContainer.toImmutable();
        }

        return container;
    }
}
