package io.wispforest.accessories.api.attributes;

import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_6880;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

///
/// Helper record to hold data on a Attribute Modification made within the [AccessoryAttributeBuilder]
///
@ApiStatus.Internal
public record AttributeModificationData(@Nullable String slotPath, class_6880<class_1320> attribute, class_1322 modifier, boolean usedInSlotValidation) {

    public AttributeModificationData(@Nullable String slotPath, class_6880<class_1320> attribute, class_1322 modifier) {
        this(slotPath, attribute, modifier, false);
    }

    public AttributeModificationData(class_6880<class_1320> attribute, class_1322 modifier, boolean usedInSlotValidation) {
        this(null, attribute, modifier, usedInSlotValidation);
    }

    public AttributeModificationData(class_6880<class_1320> attribute, class_1322 modifier) {
        this(attribute, modifier, false);
    }

    public boolean isValid(boolean filterSlotBasedPredicates, boolean isSlotValidation) {
        return isValid(filterSlotBasedPredicates ? AllowedType.BASE : AllowedType.ALL, isSlotValidation);
    }

    public boolean isValid(AllowedType mode, boolean isSlotValidation) {
        if (!mode.equals(AllowedType.ALL)) {
            if (mode.equals(AllowedType.SLOT) != (attribute().comp_349() instanceof SlotAttribute)) return false;
        }

        if (isSlotValidation) return this.usedInSlotValidation();

        return true;
    }

    @Override
    public class_1322 modifier() {
        return (this.slotPath != null)
                ? new class_1322(modifier.comp_2447().method_45134((path) -> this.slotPath + "/" + path), modifier.comp_2449(), modifier.comp_2450())
                : modifier;
    }

    @Override
    public String toString() {
        return "AttributeModifierInstance[" +
                "attribute=" + this.attribute + ", " +
                "modifier=" + this.modifier +
                "slotPath=" + (this.slotPath != null ? this.slotPath : "none") +
                ']';
    }

    public enum AllowedType {
        BASE,
        SLOT,
        ALL
    }
}
