package io.wispforest.accessories.api.attributes;

import com.google.common.collect.Multimap;
import io.wispforest.accessories.api.slot.SlotType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_6880;

/**
 * Custom Attribute used to target an accessories Slot for modification of its size
 * based on the given {@link class_1322} within the Accessories System
 */
public class SlotAttribute extends class_1320 {

    private static final Map<String, class_6880<class_1320>> CACHED_ATTRIBUTES = new HashMap<>();

    private final String slotName;

    protected SlotAttribute(String slotName) {
        super(slotName, 0);

        this.slotName = slotName;
    }

    public String slotName(){
        return this.slotName;
    }

    /**
     * @deprecated Use {{@link #getAttributeHolder(SlotType)}}
     */
    @Deprecated(forRemoval = true)
    public static SlotAttribute getSlotAttribute(SlotType slotType){
        return getSlotAttribute(slotType.name());
    }

    /**
     * @deprecated Use {{@link #getAttributeHolder(String)}}
     */
    @Deprecated(forRemoval = true)
    public static SlotAttribute getSlotAttribute(String slotName){
        return (SlotAttribute) getAttributeHolder(slotName).comp_349();
    }

    public static class_6880<class_1320> getAttributeHolder(SlotType slotType){
        return getAttributeHolder(slotType.name());
    }

    public static class_6880<class_1320> getAttributeHolder(String slotName){
        return CACHED_ATTRIBUTES.computeIfAbsent(slotName, string -> class_6880.method_40223(new SlotAttribute(slotName)));
    }

    //--

    public static void addSlotModifier(Multimap<class_6880<class_1320>, class_1322> map, SlotType slotType, class_2960 location, double amount, class_1322.class_1323 operation) {
        addSlotModifier(map, slotType.name(), location, amount, operation);
    }

    public static void addSlotModifier(Multimap<class_6880<class_1320>, class_1322> map, String slot, class_2960 location, double amount, class_1322.class_1323 operation) {
        map.put(SlotAttribute.getAttributeHolder(slot), new class_1322(location, amount, operation));
    }

    public static void addSlotAttribute(AccessoryAttributeBuilder builder, String targetSlot, class_2960 location, double amount, class_1322.class_1323 operation, boolean isStackable) {
        if(isStackable) {
            builder.addStackable(SlotAttribute.getAttributeHolder(targetSlot), location, amount, operation);
        } else {
            builder.addExclusive(SlotAttribute.getAttributeHolder(targetSlot), location, amount, operation);
        }
    }

    public static void addSlotAttribute(class_1799 stack, String targetSlot, String boundSlot, class_2960 location, double amount, class_1322.class_1323 operation, boolean isStackable) {
        AccessoryAttributeUtils.addAttribute(stack, boundSlot, SlotAttribute.getAttributeHolder(targetSlot), location, amount, operation, isStackable);
    }
}
