package io.wispforest.accessories.api.caching;

import java.util.Arrays;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_9323;
import net.minecraft.class_9331;
import net.minecraft.class_9336;

public class DataComponentMapPredicate extends ItemStackBasedPredicate {

    public final class_9323 dataComponentMap;

    public DataComponentMapPredicate(String name, class_9323 dataComponentMap){
        super(name);

        this.dataComponentMap = dataComponentMap;
    }

    @Override
    public boolean test(class_1799 stack) {
        for (var typedDataComponent : dataComponentMap) {
            if (!typedDataComponent.equals(stack.method_58694(typedDataComponent.comp_2443()))) return false;
        }

        return true;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(dataComponentMap.method_57833().toArray());
    }

    @Override
    protected boolean isEqual(Object other) {
        var dataComponentMapPredicate = (DataComponentMapPredicate) other;

        return Objects.equals(this.dataComponentMap, dataComponentMapPredicate.dataComponentMap);
    }

    @Override
    public String extraStringData() {
        return "DataComponents: " + this.dataComponentMap.toString();
    }

    public interface ComponentAddCallback {
        <T> void add(class_9331<T> type, T t);
    }
}