package io.wispforest.accessories.api.caching;

import java.util.Arrays;
import net.minecraft.class_1799;
import net.minecraft.class_9331;

public class DataComponentsPredicate extends ItemStackBasedPredicate {

    public final class_9331<?>[] dataComponentTypes;

    public DataComponentsPredicate(String name, class_9331<?>... dataComponentTypes){
        super(name);

        this.dataComponentTypes = dataComponentTypes;
    }

    @Override
    public boolean test(class_1799 stack) {
        for (var dataComponentType : this.dataComponentTypes) {
            if (!stack.method_57826(dataComponentType)) return false;
        }

        return true;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(dataComponentTypes);
    }

    @Override
    protected boolean isEqual(Object other) {
        var itemComponentPredicate = (DataComponentsPredicate) other;

        return Arrays.equals(this.dataComponentTypes, itemComponentPredicate.dataComponentTypes);
    }

    @Override
    public String extraStringData() {
        return "DataComponents: " + Arrays.toString(this.dataComponentTypes);
    }
}
