package io.wispforest.accessories.api.caching;

import java.util.Objects;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;

public class ItemLikeClassPredicate extends ItemStackBasedPredicate {

    private final boolean isBlockClass;
    private final Class<? extends class_1935> clazz;

    public ItemLikeClassPredicate(String name, Class<? extends class_1935> clazz){
        super(name);
        this.clazz = clazz;

        this.isBlockClass = clazz.isAssignableFrom(class_2248.class);
    }

    @Override
    public String extraStringData() {
        return "Class: " + clazz.getSimpleName();
    }

    @Override
    public boolean test(class_1799 stack) {
        var item = stack.method_7909();

        if (this.isBlockClass) {
            return item instanceof class_1747 blockItem && clazz.isInstance(blockItem.method_7711());
        } else {
            return clazz.isInstance(item);
        }
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.clazz);
    }

    @Override
    protected boolean isEqual(Object other) {
        var itemLikeClassPredicate = (ItemLikeClassPredicate) other;

        return this.clazz.equals(itemLikeClassPredicate.clazz);
    }
}
