package io.wispforest.accessories.api.caching;

import java.util.Objects;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

public class ItemPredicate extends ItemStackBasedPredicate {

    private final class_1792 item;

    public ItemPredicate(String name, class_1792 item) {
        super(name);
        this.item = item;
    }

    @Override
    public boolean test(class_1799 stack) {
        return stack.method_7909().equals(this.item);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.item);
    }

    @Override
    protected boolean isEqual(Object other) {
        var itemPredicate = (ItemPredicate) other;

        return this.item.equals(itemPredicate.item);
    }

    @Override
    public String extraStringData() {
        return "Item: " + this.item.toString();
    }
}
