package io.wispforest.accessories.api.caching;

import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.impl.caching.EquipmentLookupCache;
import io.wispforest.owo.util.Scary;
import org.jetbrains.annotations.ApiStatus;

import java.util.function.Predicate;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_9331;

/**
 * A custom implementation of {@link Predicate} for use with {@link EquipmentLookupCache} requireing
 * the implementation of {@link #isEqual} and {@link #hashCode} to have proper equality
 */
public abstract class ItemStackBasedPredicate implements Predicate<class_1799> {

    private static final String UNKNOWN_PREDICATE = "UNKNOWN";

    private final String name;

    protected ItemStackBasedPredicate(String name) {
        this.name = name;
    }

    //--

    public static ItemStackBasedPredicate ofClass(Class<? extends class_1935> clazz) {
        return ofClass(UNKNOWN_PREDICATE, clazz);
    }

    public static ItemStackBasedPredicate ofClass(String name, Class<? extends class_1935> clazz) {
        return new ItemLikeClassPredicate(name, clazz);
    }

    public static ItemStackBasedPredicate ofItem(class_1792 item) {
        return ofItem(UNKNOWN_PREDICATE, item);
    }

    public static ItemStackBasedPredicate ofItem(String name, class_1792 item) {
        return new ItemPredicate(name, item);
    }

    public static ItemStackBasedPredicate ofComponents(class_9331<?>... dataComponentTypes) {
        return ofComponents(UNKNOWN_PREDICATE, dataComponentTypes);
    }

    public static ItemStackBasedPredicate ofComponents(String name, class_9331<?>... dataComponentTypes) {
        return new DataComponentsPredicate(name, dataComponentTypes);
    }

    /**
     * <strong>WARNING</strong>: it is recommended to either make a custom implementation of {@link ItemStackBasedPredicate}
     * to have the ability to cache any results for use within {@link AccessoriesCapability}. Reason behind this issue is
     * the fact that {@link Predicate}
     */
    @Scary
    @ApiStatus.Experimental
    public static ItemStackBasedPredicate ofPredicate(Predicate<class_1799> predicate) {
        return ofPredicate(UNKNOWN_PREDICATE, predicate);
    }

    /**
     * <strong>WARNING</strong>: it is recommended to either make a custom implementation of {@link ItemStackBasedPredicate}
     * to have the ability to cache any results for use within {@link AccessoriesCapability}
     */
    @Scary
    @ApiStatus.Experimental
    public static ItemStackBasedPredicate ofPredicate(String name, Predicate<class_1799> predicate) {
        if (predicate instanceof ItemStackBasedPredicate itemStackBasedPredicate) {
            return itemStackBasedPredicate;
        }

        return new ItemStackPredicate(name, predicate);
    }

    //--

    public final String name() {
        return this.name;
    }

    @Override
    public String toString() {
        return "Name: " + this.name + ", " + extraStringData();
    }

    public abstract String extraStringData();

    @Override
    public abstract boolean test(class_1799 stack);

    @Override
    public abstract int hashCode();

    protected abstract boolean isEqual(Object other);

    @Override
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!this.getClass().isInstance(other)) return false;

        return this.isEqual(other);
    }
}
