package io.wispforest.accessories.api.client;

import com.google.common.base.Suppliers;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesStorage;
import io.wispforest.accessories.api.AccessoriesStorageLookup;
import io.wispforest.accessories.api.SimpleAccessoriesStorage;
import io.wispforest.accessories.api.client.renderers.AccessoryRenderer;
import io.wispforest.accessories.api.slot.SlotPath;
import org.jetbrains.annotations.Nullable;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.UUID;
import net.minecraft.class_10017;
import net.minecraft.class_10042;
import net.minecraft.class_10444;
import net.minecraft.class_12075;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_169;
import net.minecraft.class_1799;

public class AccessoriesRenderStateKeys {
    public static final class_169<SlotPath> SLOT_PATH = new class_169<>(Accessories.of("slot_path"));
    public static final class_169<class_1799> ITEM_STACK = new class_169<>(Accessories.of("item_stack"));
    public static final class_169<@Nullable class_10444> ITEM_STACK_STATE = new class_169<>(Accessories.of("item_stack_state"));
    public static final class_169<class_10042> ENTITY_STATE = new class_169<>(Accessories.of("entity_state"));

    public static final class_169<@Nullable Map<SlotPath, AccessoryRenderState>> ACCESSORY_RENDER_STATES = new class_169<>(Accessories.of("item_stack_render_state"));
    public static final class_169<@Nullable AccessoriesStorageLookup> STORAGE_LOOKUP = new class_169<>(Accessories.of("storage_lookup"));

    public static final DefaultedContextKey<List<@Nullable AccessoryRenderState>> NESTED_ACCESSORY_RENDER_STATES = new DefaultedContextKey<>(Accessories.of("item_stack_render_state"), List::of);

    public static final class_169<@Nullable class_12075> CAMERA_STATE = new class_169<>(Accessories.of("entity_uuid"));

    public static final DefaultedContextKey<UUID> ENTITY_UUID = new DefaultedContextKey<>(Accessories.of("entity_uuid"), Suppliers.memoize(UUID::randomUUID));
    public static final class_169<Integer> ENTITY_ID = new DefaultedContextKey<>(Accessories.of("entity_id"), () -> 0);

    public static final DefaultedContextKey<Float> PARTIAL_TICKS = new DefaultedContextKey<>(Accessories.of("partial_ticks"), () -> 0f);
    public static final DefaultedContextKey<Integer> LIGHT = new DefaultedContextKey<>(Accessories.of("light"), () -> 1);

    public static final class_169<class_1306> ARM = new class_169<>(Accessories.of("arm"));


    public static void setupStateForAccessories(class_10017 state, class_1297 entity, float partialTick, class_1306 arm) {
        if (state instanceof class_10042 livingState) livingState.setStateData(ARM, arm);

        setupStateForAccessories(state, entity, partialTick);
    }

    public static void setupStateForAccessories(class_10017 state, class_1297 entity, float partialTick) {
        if (!(state instanceof class_10042 livingState) || !(entity instanceof class_1309 livingEntity)) return;

        livingState.setStateData(AccessoriesRenderStateKeys.ENTITY_UUID, livingEntity.method_5667());
        livingState.setStateData(AccessoriesRenderStateKeys.ENTITY_ID, livingEntity.method_5628());

        livingState.setStateData(AccessoriesRenderStateKeys.PARTIAL_TICKS, partialTick);

        var capability = livingEntity.accessoriesCapability();

        if (capability == null) return;

        var map = new LinkedHashMap<String, AccessoriesStorage>();

        for (var entry : capability.getContainers().entrySet()) {
            map.put(entry.getKey(), SimpleAccessoriesStorage.copy(entry.getValue()));
        }

        if (map.isEmpty()) return;

        AccessoriesStorageLookup lookup = () -> map;

        livingState.setStateData(AccessoriesRenderStateKeys.STORAGE_LOOKUP, lookup);

        var renderStates = new LinkedHashMap<SlotPath, AccessoryRenderState>();

        for (var container : lookup.getContainers().values()) {
            var accessories = container.getAccessories();
            var cosmetics = container.getCosmeticAccessories();

            for (int i = 0; i < container.getSize(); i++) {
                var stack = accessories.method_5438(i);
                var cosmeticStack = cosmetics.method_5438(i);

                if (!cosmeticStack.method_7960() && Accessories.config().clientOptions.showCosmeticAccessories()) {
                    stack = cosmeticStack;
                }

                if (stack.method_7960()) continue;

                //--

                var renderer = AccessoriesRendererRegistry.getRenderer(stack);

                if (renderer.isEmpty()) continue;

                var path = container.createPath(i);

                var accessoryState = renderer.createRenderState(stack, path, lookup, livingEntity, livingState);

                if (accessoryState != null) renderStates.put(path, accessoryState);
            }
        }

        livingState.setStateData(AccessoriesRenderStateKeys.ACCESSORY_RENDER_STATES, renderStates);
    }
}
