package io.wispforest.accessories.api.client.renderers;

import io.wispforest.accessories.api.AccessoriesStorageLookup;
import io.wispforest.accessories.api.client.AccessoriesRenderStateKeys;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.client.AccessoryRenderState;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryNestContainerContents;
import io.wispforest.accessories.api.slot.SlotPath;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_10042;
import net.minecraft.class_11659;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_4587;
import net.minecraft.class_583;

public interface AccessoryNestRenderer extends AccessoryRenderer {

    default List<class_1799> getInnerStacks(class_1799 holderStack) {
        var data = holderStack.method_58694(AccessoriesDataComponents.NESTED_ACCESSORIES);

        if (data == null) return List.of();

        return data.accessories();
    }

    @Override
    default <S extends class_10042> void render(AccessoryRenderState accessoryState, S entityState, class_583<S> model, class_4587 matrices, class_11659 collector) {
        var innerStates = accessoryState.getStateData(AccessoriesRenderStateKeys.NESTED_ACCESSORY_RENDER_STATES);

        for (var innerState : innerStates) {
            if (innerState == null) continue;

            var innerStack = innerState.getStateData(AccessoriesRenderStateKeys.ITEM_STACK);

            var renderer = AccessoriesRendererRegistry.getRenderer(innerStack);

            matrices.method_22903();

            try {
                renderer.render(innerState, entityState, model, matrices, collector);
            } catch (Exception e) {
                throw new IllegalStateException("[AccessoryNestRenderer] Unable to render a given inner item stack due the following error: ", e);
            } finally {
                matrices.method_22909();
            }
        }
    }

    @Override
    default void extractRenderState(class_1799 stack, SlotPath path, AccessoriesStorageLookup storageLookup, class_1309 entity, class_10042 entityState, AccessoryRenderState accessoryState) {
        AccessoryRenderer.super.extractRenderState(stack, path, storageLookup, entity, entityState, accessoryState);

        List<@Nullable AccessoryRenderState> innerStates = new ArrayList<>();

        var innerStacks = getInnerStacks(stack);

        for (int i = 0; i < innerStacks.size(); i++) {
            var innerStack = innerStacks.get(i);
            var renderer = AccessoriesRendererRegistry.getRenderer(innerStack);

            var state = renderer.createRenderState(innerStack, SlotPath.withInnerIndex(path, i), storageLookup, entity, entityState);

            innerStates.add(state);
        }

        accessoryState.setStateData(AccessoriesRenderStateKeys.NESTED_ACCESSORY_RENDER_STATES, innerStates);
    }

    @Override
    default boolean shouldRender(class_1799 stack, SlotPath path, AccessoriesStorageLookup storageLookup, class_1309 entity, class_10042 renderState, boolean isRenderingEnabled) {
        var innerStacks = getInnerStacks(stack);

        for (var innerStack : innerStacks) {
            var renderer = AccessoriesRendererRegistry.getRenderer(innerStack);

            if (renderer.shouldRender(stack, path, storageLookup, entity, renderState, isRenderingEnabled)) {
                return true;
            }
        }

        return AccessoryRenderer.super.shouldRender(stack, path, storageLookup, entity, renderState, isRenderingEnabled);
    }
}
