package io.wispforest.accessories.api.client.renderers;

import I;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesStorageLookup;
import io.wispforest.accessories.api.client.AccessoriesRenderStateKeys;
import io.wispforest.accessories.api.client.AccessoryRenderState;
import io.wispforest.accessories.api.client.DefaultedContextKey;
import io.wispforest.accessories.api.client.rendering.ModelTransformOps;
import io.wispforest.accessories.api.client.rendering.Side;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryCustomRendererComponent;
import io.wispforest.accessories.api.core.Accessory;
import io.wispforest.accessories.api.slot.SlotPath;
import io.wispforest.accessories.compat.config.RenderSlotTarget;
import org.slf4j.Logger;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_10034;
import net.minecraft.class_10042;
import net.minecraft.class_10444;
import net.minecraft.class_11659;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_169;
import net.minecraft.class_1799;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_7833;

/**
 * Default Renderer for any {@link Accessory} that doesn't have a renderer registered.
 */
public class DefaultAccessoryRenderer implements AccessoryRenderer {

    public static final class_169<Boolean> DISABLED_TRANSFORMATIONS = new DefaultedContextKey<>(Accessories.of("disabled_transformations"), () -> false);

    private static final Logger LOGGER = LogUtils.getLogger();

    //--

    public static final DefaultAccessoryRenderer INSTANCE;

    private final Map<String, RenderHelper> slotToHelpers = new HashMap<>();

    public DefaultAccessoryRenderer(){
        slotToHelpers.putAll(DEFAULT_HELPERS);
    }

    /**
     * Registers a {@link RenderHelper} for a given slot name if not already registered
     */
    public static void registerHelper(String slotType, RenderHelper helper){
        var helpers = INSTANCE.slotToHelpers;

        if(!helpers.containsKey(slotType)){
            helpers.put(slotType, helper);
        } else {
            LOGGER.warn("[DefaultAccessoryRenderer] Unable to add to the main renderer instance due to a duplicate helper already exists!");
        }
    }

    @Override
    public <S extends class_10042> void render(AccessoryRenderState accessoryState, S entityState, class_583<S> model, class_4587 matrices, class_11659 collector) {
        if (!(model instanceof class_572<? extends class_10034> humanoidModel)) return;

        var stackRenderState = accessoryState.getStateData(AccessoriesRenderStateKeys.ITEM_STACK_STATE);

        if (stackRenderState == null) {
            throw new IllegalStateException("Unable to render default accessory as the ItemStacks render state has not been setup!");
        }

        var light = entityState.getStateData(AccessoriesRenderStateKeys.LIGHT);

        Consumer<class_4587> renderCall = (poseStack) -> stackRenderState.method_65604(poseStack, collector, light, class_4608.field_21444, entityState.field_61821);

        if(!accessoryState.getStateData(DISABLED_TRANSFORMATIONS)) {
            var path = accessoryState.getStateData(AccessoriesRenderStateKeys.SLOT_PATH);
            var stack = accessoryState.getStateData(AccessoriesRenderStateKeys.ITEM_STACK);

            var helper = slotToHelpers.get(path.slotName());

            if (helper == null) return;

            helper.render(stack, path, matrices, humanoidModel, entityState, renderCall);
        } else {
            renderCall.accept(matrices);
        }
    }

    @Override
    public boolean shouldCreateStackRenderState() {
        return true;
    }

    @Override
    public boolean shouldRender(class_1799 stack, SlotPath path, AccessoriesStorageLookup storageLookup, class_1309 entity, class_10042 renderState, boolean isRenderingEnabled) {
        var disabledTargetType = Accessories.config().clientOptions.disabledDefaultRenders();

        var slotName = path.slotName();

        for (var target : disabledTargetType) {
            if(slotName.equals(target.slotType) && target.targetType.isValid(stack.method_7909())) {
                return false;
            }
        }

        var translationData = stack.method_58695(AccessoriesDataComponents.CUSTOM_RENDERER, AccessoryCustomRendererComponent.EMPTY);

        if (!translationData.disableDefaultTranslations() && slotToHelpers.get(path.slotName()) == null) {
            return false;
        }

        var arm = renderState.getStateData(AccessoriesRenderStateKeys.ARM);

        if (arm != null) {
            return (slotName.equals("hand") || slotName.equals("wrist") || slotName.equals("ring"))
                && (path.index() % 2 == 0 ? arm == class_1306.field_6183 : arm == class_1306.field_6182);
        }

        return AccessoryRenderer.super.shouldRender(stack, path, storageLookup, entity, renderState, isRenderingEnabled);
    }

    public interface RenderHelper {
        <S extends class_10042> void render(class_1799 stack, SlotPath path, class_4587 matrices, class_572<? extends class_10034> humanoidModel, S renderState, Consumer<class_4587> renderCall);
    }

    //--

    private static final Map<String, RenderHelper> DEFAULT_HELPERS;

    static {
        DEFAULT_HELPERS = Map.ofEntries(
                Map.entry("face", new RenderHelper() {
                    @Override
                    public <S extends class_10042> void render(class_1799 stack, SlotPath path, class_4587 matrices, class_572<? extends class_10034> humanoidModel, S renderState, Consumer<class_4587> renderCall) {
                        ModelTransformOps.transformToFace(matrices, renderState, humanoidModel, "head", Side.FRONT);
                        renderCall.accept(matrices);
                    }
                }),
                Map.entry("hat", new RenderHelper() {
                    @Override
                    public <S extends class_10042> void render(class_1799 stack, SlotPath path, class_4587 matrices, class_572<? extends class_10034> humanoidModel, S renderState, Consumer<class_4587> renderCall) {
                        ModelTransformOps.transformToFace(matrices, renderState, humanoidModel, "head", Side.TOP);
                        matrices.method_22904(0, 0.25, 0);
                        for (int i = 0; i < stack.method_7947(); i++) {
                            renderCall.accept(matrices);
                            matrices.method_22904(0, 0.5, 0);
                        }
                    }
                }),
                Map.entry("back", new RenderHelper() {
                    @Override
                    public <S extends class_10042> void render(class_1799 stack, SlotPath path, class_4587 matrices, class_572<? extends class_10034> humanoidModel, S renderState, Consumer<class_4587> renderCall) {
                        ModelTransformOps.transformToFace(matrices, renderState, humanoidModel, "body", Side.BACK);
                        matrices.method_22905(1.5f, 1.5f, 1.5f);
                        renderCall.accept(matrices);
                    }
                }),
                Map.entry("necklace", new RenderHelper() {
                    @Override
                    public <S extends class_10042> void render(class_1799 stack, SlotPath path, class_4587 matrices, class_572<? extends class_10034> humanoidModel, S renderState, Consumer<class_4587> renderCall) {
                        ModelTransformOps.transformToModelPart(matrices, renderState, humanoidModel, "body", 0, 1, 1);
                        matrices.method_22904(0, -0.25, 0);
                        renderCall.accept(matrices);
                    }
                }),
                Map.entry("cape", new RenderHelper() {
                    @Override
                    public <S extends class_10042> void render(class_1799 stack, SlotPath path, class_4587 matrices, class_572<? extends class_10034> humanoidModel, S renderState, Consumer<class_4587> renderCall) {
                        ModelTransformOps.transformToModelPart(matrices, renderState, humanoidModel, "body", 0, 1, -1);
                        matrices.method_22904(0, -0.25, 0);
                        renderCall.accept(matrices);
                    }
                }),
                Map.entry("ring", new RenderHelper() {
                    @Override
                    public <S extends class_10042> void render(class_1799 stack, SlotPath path, class_4587 matrices, class_572<? extends class_10034> humanoidModel, S renderState, Consumer<class_4587> renderCall) {
                        var modelTarget = path.index() % 2 == 0 ? "right_arm" : "left_arm";
                        var xPercent = path.index() % 2 == 0 ? 1 : -1;

                        ModelTransformOps.transformToModelPart(
                                matrices,
                                renderState,
                                humanoidModel,
                                modelTarget,
                                xPercent,
                                -1,
                                0
                        );
                        var offset = path.index() / 2;
                        matrices.method_22904(
                                (path.index() % 2 == 0 ? -1 : 1) * offset * -0.0001,
                                0.25 * (offset + 1),
                                0
                        );
                        matrices.method_22905(0.5f, 0.5f, 0.5f);
                        matrices.method_22907(class_7833.field_40716.rotationDegrees(90));
                        for (int i = 0; i < stack.method_7947(); i++) {
                            renderCall.accept(matrices);
                            matrices.method_22904(
                                    0,
                                    0,
                                    path.index() % 2 == 0 ? -0.5 : 0.5
                            );
                        }
                    }
                }),
                Map.entry("wrist", new RenderHelper() {
                    @Override
                    public <S extends class_10042> void render(class_1799 stack, SlotPath path, class_4587 matrices, class_572<? extends class_10034> humanoidModel, S renderState, Consumer<class_4587> renderCall) {
                        var modelTarget = path.index() % 2 == 0 ? "right_arm" : "left_arm";
                        ModelTransformOps.transformToModelPart(matrices, renderState, humanoidModel, modelTarget, 0, -0.5, 0);
                        matrices.method_22905(1.01f, 1.01f, 1.01f);
                        matrices.method_22907(class_7833.field_40716.rotationDegrees(90));
                        renderCall.accept(matrices);
                    }
                }),
                Map.entry("hand", new RenderHelper() {
                    @Override
                    public <S extends class_10042> void render(class_1799 stack, SlotPath path, class_4587 matrices, class_572<? extends class_10034> humanoidModel, S renderState, Consumer<class_4587> renderCall) {
                        var modelTarget = path.index() % 2 == 0 ? "right_arm" : "left_arm";
                        ModelTransformOps.transformToFace(matrices, renderState, humanoidModel, modelTarget, Side.BOTTOM);
                        matrices.method_22904(0, 0.25, 0);
                        matrices.method_22905(1.02f, 1.02f, 1.02f);
                        matrices.method_22907(class_7833.field_40716.rotationDegrees(90));
                        renderCall.accept(matrices);
                    }
                }),
                Map.entry("belt", new RenderHelper() {
                    @Override
                    public <S extends class_10042> void render(class_1799 stack, SlotPath path, class_4587 matrices, class_572<? extends class_10034> humanoidModel, S renderState, Consumer<class_4587> renderCall) {
                        ModelTransformOps.transformToFace(matrices, renderState, humanoidModel, "body", Side.BOTTOM);
                        matrices.method_22905(1.01f, 1.01f, 1.01f);
                        renderCall.accept(matrices);
                    }
                }),
                Map.entry("anklet", new RenderHelper() {
                    @Override
                    public <S extends class_10042> void render(class_1799 stack, SlotPath path, class_4587 matrices, class_572<? extends class_10034> humanoidModel, S renderState, Consumer<class_4587> renderCall) {
                        var modelTarget = path.index() % 2 == 0 ? "right_leg" : "left_leg";
                        ModelTransformOps.transformToModelPart(matrices, renderState, humanoidModel, modelTarget, 0, -0.5, 0);
                        matrices.method_22905(1.01f, 1.01f, 1.01f);
                        renderCall.accept(matrices);
                    }
                }),
                Map.entry("shoes", new RenderHelper() {
                    @Override
                    public <S extends class_10042> void render(class_1799 stack, SlotPath path, class_4587 matrices, class_572<? extends class_10034> humanoidModel, S renderState, Consumer<class_4587> renderCall) {
                        matrices.method_22903();
                        ModelTransformOps.transformToFace(matrices, renderState, humanoidModel, "right_leg", Side.BOTTOM);
                        matrices.method_22904(0, 0.25, 0);
                        matrices.method_22905(1.02f, 1.02f, 1.02f);
                        renderCall.accept(matrices);
                        matrices.method_22909();
                        matrices.method_22903();
                        ModelTransformOps.transformToFace(matrices, renderState, humanoidModel, "left_leg", Side.BOTTOM);
                        matrices.method_22904(0, 0.25, 0);
                        matrices.method_22905(1.02f, 1.02f, 1.02f);
                        renderCall.accept(matrices);
                        matrices.method_22909();
                    }
                })
        );

        INSTANCE = new DefaultAccessoryRenderer();
    }
}
