package io.wispforest.accessories.api.client.renderers;

import io.wispforest.accessories.api.client.AccessoriesRenderStateKeys;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.client.AccessoryRenderState;
import net.minecraft.class_10042;
import net.minecraft.class_10444;
import net.minecraft.class_11659;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_583;

/**
 * Simple version of the {@link AccessoryRenderer} with a transformation method to adjust
 * a given item to certain part of the given {@link class_1309} then rendering the accessory
 * as an Item at the specified location and scale
 */
public interface SimpleAccessoryRenderer extends AccessoryRenderer {

    @Override
    default <S extends class_10042> void render(AccessoryRenderState accessoryState, S entityState, class_583<S> model, class_4587 matrices, class_11659 collector) {
        var stackRenderState = accessoryState.getStateData(AccessoriesRenderStateKeys.ITEM_STACK_STATE);

        if (stackRenderState == null) {
            throw new NullPointerException("Unable to get the required ItemStack render state to render a SimpleAccessoryRenderer: " + AccessoriesRendererRegistry.getRendererId(this));
        }

        align(accessoryState, entityState, model, matrices);

        var light = entityState.getStateData(AccessoriesRenderStateKeys.LIGHT);
        var stack = accessoryState.getStateData(AccessoriesRenderStateKeys.ITEM_STACK);

        renderStack(accessoryState, entityState, model, matrices, collector, stack, stackRenderState, light);
    }

    public default <S extends class_10042> void renderStack(AccessoryRenderState accessoryState, S entityState, class_583<S> model, class_4587 matrices, class_11659 collector, class_1799 stack, class_10444 stackRenderState, int light) {
        stackRenderState.method_65604(matrices, collector, entityState.getStateData(AccessoriesRenderStateKeys.LIGHT), class_4608.field_21444, 0);
    }

    @Override
    default boolean shouldCreateStackRenderState() {
        return true;
    }

    /// Method used to align the given matrices to the desired position and scale on the current [LivingEntity]
    /// passed within the [#render] method.
    ///
    /// \[1.21.8 and below-> 1.21.9]
    /// - stack           -> {@link AccessoryRenderState#getStateData} with {@link AccessoriesRenderStateKeys#ITEM_STACK}
    /// - path            -> {@link AccessoryRenderState#getStateData} with {@link AccessoriesRenderStateKeys#SLOT_PATH}
    ///
    public <S extends class_10042> void align(AccessoryRenderState accessoryState, S entityState, class_583<S> model, class_4587 matrices);

}