package io.wispforest.accessories.api.client.renderers;

import io.wispforest.accessories.api.AccessoriesStorageLookup;
import io.wispforest.accessories.api.client.AccessoryRenderState;
import io.wispforest.accessories.api.slot.SlotPath;
import net.minecraft.class_10042;
import net.minecraft.class_11659;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_4587;
import net.minecraft.class_583;

public class WrappedAccessoryRenderer implements AccessoryRenderer {

    private final AccessoryRenderer delegate;

    public WrappedAccessoryRenderer(AccessoryRenderer delegate) {
        this.delegate = delegate;
    }

    @Override
    public <S extends class_10042> void render(AccessoryRenderState accessoryState, S entityState, class_583<S> model, class_4587 matrices, class_11659 collector) {
        this.delegate.render(accessoryState, entityState, model, matrices, collector);
    }

    @Override
    public AccessoryRenderState createRenderState(class_1799 stack, SlotPath path, AccessoriesStorageLookup storageLookup, class_1309 entity, class_10042 renderState) {
        return this.delegate.createRenderState(stack, path, storageLookup, entity, renderState);
    }

    @Override
    public void extractRenderState(class_1799 stack, SlotPath path, AccessoriesStorageLookup storageLookup, class_1309 entity, class_10042 entityState, AccessoryRenderState accessoryState) {
        this.delegate.extractRenderState(stack, path, storageLookup, entity, entityState, accessoryState);
    }

    @Override
    public boolean shouldCreateStackRenderState() {
        return this.delegate.shouldCreateStackRenderState();
    }

    @Override
    public boolean shouldRender(class_1799 stack, SlotPath path, AccessoriesStorageLookup storageLookup, class_1309 entity, class_10042 renderState, boolean isRendering) {
        return this.delegate.shouldRender(stack, path, storageLookup, entity, renderState, isRendering);
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }
}
