package io.wispforest.accessories.api.client.rendering;

import Z;
import com.mojang.datafixers.util.Pair;
import io.wispforest.accessories.mixin.client.ModelPartAccessor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Optional;
import net.minecraft.class_10042;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_630;
import net.minecraft.class_7833;

//@Environment(EnvType.CLIENT)
@ApiStatus.Experimental
public class ModelTransformOps {

    private static final Map<class_2960, ModelPartTransformer> ADDITIONAL_TRANSFORMERS = new LinkedHashMap<>();

    @ApiStatus.Experimental
    public static void registerTransformer(class_2960 location, ModelPartTransformer modelTransformers) {
        if (ADDITIONAL_TRANSFORMERS.containsKey(location)) {
            throw new IllegalStateException("Already existing ModelTransformer exists!");
        }

        ADDITIONAL_TRANSFORMERS.put(location, modelTransformers);
    }

    @ApiStatus.Experimental
    public static boolean transformToFace(class_4587 poseStack, class_10042 renderState, class_3879 model, String modelPartName, Side side) {
        var vec = side.direction.method_62675();

        return transformToModelPart(poseStack, renderState, model, modelPartName, vec.method_10263(), vec.method_10264(), vec.method_10260());
    }

    @ApiStatus.Experimental
    public static boolean transformToModelPart(class_4587 poseStack, class_10042 renderState, class_3879 model, String modelPartName) {
        return transformToModelPart(poseStack, renderState, model, modelPartName, 0, 0, 0);
    }

    @ApiStatus.Experimental
    public static boolean transformToModelPart(class_4587 poseStack, class_10042 renderState, class_3879 model, String modelPartName, @Nullable Number xPercent, @Nullable Number yPercent, @Nullable Number zPercent) {
        // TODO: ADD ERRORING FOR IF IT OCCURED

        for (var entry : ADDITIONAL_TRANSFORMERS.entrySet()) {
            var result = entry.getValue().transformToPart(poseStack, renderState, model, modelPartName, xPercent, yPercent, zPercent);

            if (result) return true;
        }

        var modelPart = getPart(model, modelPartName);

        if (modelPart != null) {
            transformToModelPart(poseStack, modelPart, xPercent, yPercent, zPercent);

            return true;
        }

        return false;
    }

    @ApiStatus.Experimental
    @Nullable
    public static class_630 getPart(class_3879 model, String modelPartName) {
        var possiblePart = getAnyDescendantWithName(model, modelPartName);

        return possiblePart.orElse(null);
    }

    public static Optional<class_630> getAnyDescendantWithName(class_3879 model, String name) {
        var root = model.method_63512();

        if (name.equals("root")) return Optional.of(root);

        return getAnyDescendantWithName(root, name);
    }

    private static Optional<class_630> getAnyDescendantWithName(class_630 part, String name) {
        for (var entry : ((ModelPartAccessor) (Object) part).getChildren().entrySet()) {
            var childName = entry.getKey();
            var childPart = entry.getValue();

            if (childName.equals(name)) return Optional.of(childPart);

            var result = getAnyDescendantWithName(childPart, name);

            if (result.isPresent()) return result;
        }

        return Optional.empty();
    }

    /**
     * Transforms the rendering context to a specific face on a ModelPart
     *
     * @param poseStack the pose stack to apply the transformation(s) to
     * @param part      The ModelPart to transform to
     * @param side      The side of the ModelPart to transform to
     */
    public static void transformToFace(class_4587 poseStack, class_630 part, Side side) {
        var vec = side.direction.method_62675();

        transformToModelPart(poseStack, part, vec.method_10263(), vec.method_10264(), vec.method_10260());
    }

    /**
     * Transforms the rendering context to the center of a ModelPart
     *
     * @param poseStack the pose stack to apply the transformation(s) to
     * @param part      The ModelPart to transform to
     */
    public static void transformToModelPart(class_4587 poseStack, class_630 part) {
        transformToModelPart(poseStack, part, 0, 0, 0);
    }

    /**
     * Transforms the rendering context to a specific place relative to a ModelPart
     *
     * @param poseStack the pose stack to apply the transformation(s) to
     * @param part      The ModelPart to transform to
     * @param xPercent  The percentage of the x-axis to translate to
     *                  <p>
     *                  (-1 being the left side and 1 being the right side)
     *                  <p>
     *                  If null, will be ignored
     * @param yPercent  The percentage of the y-axis to translate to
     *                  <p>
     *                  (-1 being the bottom and 1 being the top)
     *                  <p>
     *                  If null, will be ignored
     * @param zPercent  The percentage of the z-axis to translate to
     *                  <p>
     *                  (-1 being the back and 1 being the front)
     *                  <p>
     *                  If null, will be ignored
     */
    public static void transformToModelPart(class_4587 poseStack, class_630 part, @Nullable Number xPercent, @Nullable Number yPercent, @Nullable Number zPercent) {
        part.method_22703(poseStack);
        var aabb = getAABB(part);
        poseStack.method_22905(1 / 16f, 1 / 16f, 1 / 16f);
        poseStack.method_22904(
                xPercent != null ? class_3532.method_16436((-xPercent.doubleValue() + 1) / 2, aabb.getFirst().field_1352, aabb.getSecond().field_1352) : 0,
                yPercent != null ? class_3532.method_16436((-yPercent.doubleValue() + 1) / 2, aabb.getFirst().field_1351, aabb.getSecond().field_1351) : 0,
                zPercent != null ? class_3532.method_16436((-zPercent.doubleValue() + 1) / 2, aabb.getFirst().field_1350, aabb.getSecond().field_1350) : 0
        );
        poseStack.method_22905(8, 8, 8);
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(180));
    }

    private static Pair<class_243, class_243> getAABB(class_630 part) {
        class_243 min = new class_243(0, 0, 0);
        class_243 max = new class_243(0, 0, 0);

        if (part.getClass().getSimpleName().contains("EMFModelPart")) {
            var parts = new ArrayList<class_630>();

            parts.add(part);
            parts.addAll(((ModelPartAccessor) (Object) part).getChildren().values());

            for (var modelPart : parts) {
                for (class_630.class_628 cube : ((ModelPartAccessor) (Object) modelPart).getCubes()) {
                    min = new class_243(
                            Math.min(min.field_1352, Math.min(cube.field_3645 + modelPart.field_3657, cube.field_3648 + modelPart.field_3657)),
                            Math.min(min.field_1351, Math.min(cube.field_3644 + modelPart.field_3656, cube.field_3647 + modelPart.field_3656)),
                            Math.min(min.field_1350, Math.min(cube.field_3643 + modelPart.field_3655, cube.field_3646 + modelPart.field_3655))
                    );
                    max = new class_243(
                            Math.max(max.field_1352, Math.max(cube.field_3645 + modelPart.field_3657, cube.field_3648 + modelPart.field_3657)),
                            Math.max(max.field_1351, Math.max(cube.field_3644 + modelPart.field_3656, cube.field_3647 + modelPart.field_3656)),
                            Math.max(max.field_1350, Math.max(cube.field_3643 + modelPart.field_3655, cube.field_3646 + modelPart.field_3655))
                    );
                }
            }
        } else {
            for (class_630.class_628 cube : ((ModelPartAccessor) (Object) part).getCubes()) {
                min = new class_243(
                        Math.min(min.field_1352, Math.min(cube.field_3645, cube.field_3648)),
                        Math.min(min.field_1351, Math.min(cube.field_3644, cube.field_3647)),
                        Math.min(min.field_1350, Math.min(cube.field_3643, cube.field_3646))
                );
                max = new class_243(
                        Math.max(max.field_1352, Math.max(cube.field_3645, cube.field_3648)),
                        Math.max(max.field_1351, Math.max(cube.field_3644, cube.field_3647)),
                        Math.max(max.field_1350, Math.max(cube.field_3643, cube.field_3646))
                );
            }
        }

        return Pair.of(min, max);
    }

    @ApiStatus.Experimental
    public interface ModelPartTransformer {
        boolean transformToPart(class_4587 poseStack, class_10042 renderState, class_3879 model, String modelPartName, @Nullable Number xPercent, @Nullable Number yPercent, @Nullable Number zPercent);
    }
}
