package io.wispforest.accessories.api.client.rendering;

import com.google.common.base.CaseFormat;
import com.google.common.base.Supplier;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.client.rendering.RenderingFunction.*;
import io.wispforest.accessories.utils.EndecUtils;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.format.edm.EdmElement;
import io.wispforest.endec.format.edm.EdmSerializer;
import io.wispforest.endec.format.gson.GsonEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.owo.serialization.CodecUtils;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import io.wispforest.owo.serialization.format.nbt.NbtEndec;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.*;
import net.minecraft.class_11362;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1306;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3730;
import net.minecraft.class_7923;

@ApiStatus.Experimental
public sealed interface RenderingFunction permits DeferredRenderer, Block, Compound, Conditional, RawRenderer, Entity, Item, Model, Particle, Transformations {

    static Transformations ofTransformation(List<io.wispforest.accessories.api.client.rendering.Transformation> transformations, List<RenderingFunction> renderingFunctions, ArmTarget armTarget) {
        return new Transformations(transformations, new Compound(renderingFunctions, armTarget));
    }

    static Model ofModel(class_2960 id) {
        return new Model(id);
    }

    static Block ofBlock(net.minecraft.class_2248 block) {
        return ofBlock(block.method_9564());
    }

    static Block ofBlock(class_2680 state) {
        return new Block(state, null, new class_2487());
    }

    static Block ofBlockEntity(net.minecraft.class_2248 block, class_2591<? extends net.minecraft.class_2586> type, class_1937 level) {
        return ofBlockEntity(block.method_9564(), type, level);
    }

    static Block ofBlockEntity(class_2680 blockState, class_2591<? extends net.minecraft.class_2586> type, class_1937 level) {
        var blockEntity = type.method_11032(class_2338.field_10980, blockState);

        if (blockEntity == null) throw new IllegalStateException("Unable to create render function of the given block entity");

        return ofBlockEntity(blockState, type, blockEntity.method_38244(level.method_30349()));
    }

    static Block ofBlockEntity(class_2680 blockState, class_2591<? extends net.minecraft.class_2586> type, class_2487 data) {
        return new Block(blockState, type, data);
    }

    static Item ofItem(class_1799 stack) {
        return new Item(stack);
    }

    static Entity ofEntity(class_1299<? extends net.minecraft.class_1297> entityType, class_1937 level) {
        var entity = entityType.method_5883(level, class_3730.field_16467);
        if (entity == null) throw new IllegalStateException("Unable to create render function of the given entity");

        return Accessories.handleIoError("rendering_function_entity_data", scopedCollector -> {
            var valueOutput = class_11362.method_71459(scopedCollector, level.method_30349());

            var string = entity.method_5653();
            if (string == null) throw new IllegalStateException("Unable to create render function of the given entity");

            valueOutput.method_71469("id", string);
            entity.method_5647(valueOutput);

            var compound = valueOutput.method_71475();

            return new Entity(entityType, compound, true);
        });
    }

    static Entity ofEntity(class_1299<? extends net.minecraft.class_1297> entityType, class_2487 data) {
        return new Entity(entityType, data, true);
    }

    static Particle ofParticle(class_2960 uniqueId, float delay, class_2394 particleData, Vector3f delta, float speed, int count, boolean overrideLimiter, boolean alwaysShow) {
        return new Particle(uniqueId, delay, particleData, delta, speed, count, overrideLimiter, alwaysShow);
    }

    //--

    Endec<RenderingFunction> ENDEC = Endec.dispatchedStruct(
            key -> switch (key) {
                case "transformation" -> Transformations.ENDEC;
                case "model" -> Model.ENDEC;
                case "block" -> Block.ENDEC;
                case "item" -> Item.ENDEC;
                case "entity" -> Entity.ENDEC;
                case "particle" -> Particle.ENDEC;
                case "compound" -> Compound.ENDEC;
                case "renderer" -> DeferredRenderer.ENDEC;
                case "conditional" -> Conditional.ENDEC;
                case "data" -> RawRenderer.ENDEC;
                default -> throw new IllegalStateException("A invalid rendering function was created meaning such is unable to be decoded!");
            },
            RenderingFunction::key,
            Endec.STRING,
            "type"
    );

    default String key() {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, this.getClass().getSimpleName());
    }

    record Transformations(List<io.wispforest.accessories.api.client.rendering.Transformation> transformations, Compound renderingFunction) implements RenderingFunction {
        public static final StructEndec<Transformations> ENDEC = StructEndecBuilder.of(
                io.wispforest.accessories.api.client.rendering.Transformation.ENDEC.listOf().fieldOf("transformations", Transformations::transformations),
                Compound.ENDEC.flatFieldOf(Transformations::renderingFunction),
                Transformations::new
        );
    }

    record Model(class_2960 id) implements RenderingFunction {
        public static final StructEndec<Model> ENDEC = StructEndecBuilder.of(
                MinecraftEndecs.IDENTIFIER.fieldOf("id", Model::id),
                Model::new
        );
    }

    record Block(class_2680 state, @Nullable class_2591<?> type, class_2487 data) implements RenderingFunction {
        public static final StructEndec<Block> ENDEC = StructEndecBuilder.of(
                EndecUtils.blockStateEndec("id").flatFieldOf(Block::state),
                CodecUtils.toEndec(class_7923.field_41181.method_39673()).optionalFieldOf("entity_id", Block::type, (class_2591<?>) null),
                NbtEndec.COMPOUND.optionalFieldOf("data", Block::data, class_2487::new),
                Block::new
        );
    }

    record Item(class_1799 stack) implements RenderingFunction {
        public static final StructEndec<Item> ENDEC = StructEndecBuilder.of(
                new EndecUtils.LazyStructEndec<>(() -> {
                    var baseCodec = class_1799.field_24671;

                    try {
                        var field = baseCodec.getClass().getDeclaredField("wrapped");

                        field.setAccessible(true);

                        var supplier = (Supplier<Codec<class_1799>>) field.get(baseCodec);

                        return CodecUtils.toStructEndec(((MapCodec.MapCodecCodec<class_1799>) supplier.get()).codec());
                    } catch (NoSuchFieldException | IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }).flatFieldOf(Item::stack),
                Item::new
        );
    }

    record Entity(class_1299<?> entityType, class_2487 data, boolean allowTicking) implements RenderingFunction {
        public static final StructEndec<Entity> ENDEC = StructEndecBuilder.of(
                CodecUtils.toEndec(class_7923.field_41177.method_39673()).fieldOf("entity_id", Entity::entityType),
                NbtEndec.COMPOUND.optionalFieldOf("stack", Entity::data, class_2487::new),
                Endec.BOOLEAN.optionalFieldOf("allow_ticking", Entity::allowTicking, false),
                Entity::new
        );
    }

    record Particle(class_2960 uniqueId, float delay, class_2394 particleData, Vector3f delta, float speed, int count, boolean overrideLimiter, boolean alwaysShow) implements RenderingFunction {
        private static final Endec<class_2394> PARTICLE_OPTIONS_ENDEC = CodecUtils.toEndec(class_2398.field_25125);

        public static final StructEndec<Particle> ENDEC = StructEndecBuilder.of(
                MinecraftEndecs.IDENTIFIER.optionalFieldOf("unique_id", Particle::uniqueId, () -> Accessories.of("shared")),
                Endec.FLOAT.optionalFieldOf("delay", Particle::delay, () -> 20f),
                PARTICLE_OPTIONS_ENDEC.fieldOf("particle_data", Particle::particleData),
                EndecUtils.VECTOR_3_F_ENDEC.flatFieldOf(Particle::delta),
                Endec.FLOAT.optionalFieldOf("speed", Particle::speed, 1f),
                Endec.INT.optionalFieldOf("count", Particle::count, 1),
                Endec.BOOLEAN.optionalFieldOf("override_limiter", Particle::overrideLimiter, false),
                Endec.BOOLEAN.optionalFieldOf("always_show", Particle::alwaysShow, false),
                Particle::new
        );

        @Override
        public boolean equals(Object obj) {
            if (obj == this) return true;
            if (obj == null || obj.getClass() != this.getClass()) return false;
            var that = (Particle) obj;

            var rawParticleData = PARTICLE_OPTIONS_ENDEC.encodeFully(EdmSerializer::of, this.particleData);
            var thatRawParticleData = PARTICLE_OPTIONS_ENDEC.encodeFully(EdmSerializer::of, that.particleData);

            return Objects.equals(rawParticleData, thatRawParticleData) &&
                    Objects.equals(this.delta, that.delta) &&
                    Float.floatToIntBits(this.speed) == Float.floatToIntBits(that.speed) &&
                    this.count == that.count &&
                    this.overrideLimiter == that.overrideLimiter &&
                    this.alwaysShow == that.alwaysShow;
        }

        @Override
        public int hashCode() {
            return Objects.hash(PARTICLE_OPTIONS_ENDEC.encodeFully(EdmSerializer::of, this.particleData), delta, speed, count, overrideLimiter, alwaysShow);
        }

        @Override
        public String toString() {
            return "Particle[" +
                    "particleData=" + particleData + ", " +
                    "delta=" + delta + ", " +
                    "speed=" + speed + ", " +
                    "count=" + count + ", " +
                    "overrideLimiter=" + overrideLimiter +
                    "alwaysShow=" + alwaysShow +']';
        }
    }

    interface ArmedTargeted {
        ArmTarget firstPersonArmTarget();
    }

    record Compound(List<RenderingFunction> renderingFunctions, ArmTarget firstPersonArmTarget) implements RenderingFunction, ArmedTargeted {
        private static final StructEndec<Compound> OLD_FORMAT_ENDEC = StructEndecBuilder.of(
                RenderingFunction.ENDEC.fieldOf("rendering_function", s -> s.renderingFunctions().getFirst()),
                Endec.forEnum(ArmTarget.class).optionalFieldOf("first_person_arm_target", Compound::firstPersonArmTarget, () -> ArmTarget.NONE),
                (function, armTarget) -> new Compound(List.of(function), armTarget)
        );

        public static final StructEndec<Compound> ENDEC = StructEndecBuilder.of(
                RenderingFunction.ENDEC.listOf().fieldOf("rendering_functions", Compound::renderingFunctions),
                Endec.forEnum(ArmTarget.class).optionalFieldOf("first_person_arm_target", Compound::firstPersonArmTarget, () -> ArmTarget.NONE),
                Compound::new
        ).structuredCatchErrors((ctx, serializer, struct, mainException) -> {
            try {
                return OLD_FORMAT_ENDEC.decodeStruct(ctx, serializer, struct);
            } catch (Exception ignored) {}

            throw new RuntimeException(mainException);
        });
    }

    final class RawRenderer implements RenderingFunction, ArmedTargeted {
        public static final StructEndec<RawRenderer> ENDEC = StructEndecBuilder.of(
                GsonEndec.INSTANCE.mapOf().optionalFieldOf("references", RawRenderer::references, HashMap::new),
                GsonEndec.INSTANCE.listOf().fieldOf("rendering_functions", RawRenderer::renderingFunctions),
                Endec.forEnum(ArmTarget.class).optionalFieldOf("first_person_arm_target", RawRenderer::firstPersonArmTarget, () -> ArmTarget.NONE),
                RawRenderer::new
        );

        private final Map<String, JsonElement> references;
        private final List<JsonElement> renderingFunctions;
        private final ArmTarget firstPersonArmTarget;

        private final UUID uuid;

        public RawRenderer(Map<String, JsonElement> references, List<JsonElement> renderingFunctions, ArmTarget firstPersonArmTarget) {
            this.references = references;
            this.renderingFunctions = renderingFunctions;
            this.firstPersonArmTarget = firstPersonArmTarget;

            this.uuid = UUID.nameUUIDFromBytes(this.toString().getBytes(StandardCharsets.UTF_8));
        }

        public Map<String, JsonElement> references() { return Collections.unmodifiableMap(references); }
        public List<JsonElement> renderingFunctions() { return Collections.unmodifiableList(renderingFunctions); }
        public ArmTarget firstPersonArmTarget() { return firstPersonArmTarget; }
        public UUID getUUID() { return uuid; }

        @Override public String key() { return "data"; }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) return true;
            if (obj == null || obj.getClass() != this.getClass()) return false;
            var that = (RawRenderer) obj;
            return Objects.equals(this.references, that.references) &&
                    Objects.equals(this.renderingFunctions, that.renderingFunctions) &&
                    Objects.equals(this.firstPersonArmTarget, that.firstPersonArmTarget);
        }

        @Override
        public int hashCode() {
            return Objects.hash(references, renderingFunctions, firstPersonArmTarget);
        }

        @Override
        public String toString() {
            return "RawRenderer[" + "references=" + references + ", " + "renderingFunctions=" + renderingFunctions + ", " + "firstPersonArmTarget=" + firstPersonArmTarget + ']';
        }
    }

    // TODO: FIRST CHANGE FROM JSON TO EDM WHEN 1.21.4 and CACHE RESULTS OF CUSTOM renderingFunctions SOME HOW?
//    @Environment(EnvType.CLIENT)
    @ApiStatus.Experimental
    final class DeferredRenderer implements RenderingFunction, ArmedTargeted {
        public static final StructEndec<DeferredRenderer> ENDEC = StructEndecBuilder.of(
                MinecraftEndecs.IDENTIFIER.optionalFieldOf("renderer_id", DeferredRenderer::rendererId, () -> AccessoriesRendererRegistry.NO_RENDERER_ID),
                GsonEndec.INSTANCE.mapOf().optionalFieldOf("references", DeferredRenderer::references, HashMap::new),
                Endec.forEnum(ArmTarget.class).optionalFieldOf("first_person_arm_target", DeferredRenderer::firstPersonArmTarget, () -> ArmTarget.BOTH),
                DeferredRenderer::new
        );

        private final class_2960 rendererId;
        private final Map<String, JsonElement> references;
        private final ArmTarget firstPersonArmTarget;

        private final UUID uuid;

        public DeferredRenderer(class_2960 rendererId,
                                Map<String, JsonElement> references,
                                ArmTarget firstPersonArmTarget) {
            this.rendererId = rendererId;
            this.references = references;
            this.firstPersonArmTarget = firstPersonArmTarget;

            this.uuid = UUID.nameUUIDFromBytes(this.toString().getBytes(StandardCharsets.UTF_8));
        }

        public Map<String, JsonElement> references() { return Collections.unmodifiableMap(references); }
        public class_2960 rendererId() { return rendererId; }
        public ArmTarget firstPersonArmTarget() { return firstPersonArmTarget; }
        public UUID getUUID() { return uuid; }

        @Override public String key() { return "renderer"; }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) return true;
            if (obj == null || obj.getClass() != this.getClass()) return false;
            var that = (DeferredRenderer) obj;
            return Objects.equals(this.rendererId, that.rendererId) &&
                    Objects.equals(this.references, that.references) &&
                    Objects.equals(this.firstPersonArmTarget, that.firstPersonArmTarget);
        }

        @Override
        public int hashCode() {
            return Objects.hash(rendererId, references, firstPersonArmTarget);
        }

        @Override
        public String toString() {
            return "DeferredRenderer[" + "rendererId=" + rendererId + ", " + "references=" + references + ", " + "firstPersonArmTarget=" + firstPersonArmTarget + ']';
        }

    }

    record Conditional(List<RenderingPredicate> predicates, Compound renderingFunction) implements RenderingFunction {
        public static final StructEndec<Conditional> ENDEC = StructEndecBuilder.of(
                RenderingPredicate.ENDEC.listOf().fieldOf("predicates", Conditional::predicates),
                Compound.ENDEC.flatFieldOf(Conditional::renderingFunction),
                Conditional::new
        );
    }

    enum ArmTarget {
        LEFT(class_1306.field_6182),
        RIGHT(class_1306.field_6183),
        BOTH(class_1306.field_6182, class_1306.field_6183),
        NONE;

        private final Set<class_1306> arms;

        ArmTarget(class_1306 ...arms){
            var result = EnumSet.noneOf(class_1306.class);

            result.addAll(Set.of(arms));

            this.arms = result;
        }

        public final boolean hasArm(class_1306 arm){
            return this.arms.contains(arm);
        }
    }
}
