package io.wispforest.accessories.api.client.rendering;

import io.wispforest.accessories.api.client.renderers.DefaultAccessoryRenderer;
import java.util.function.Predicate;
import net.minecraft.class_1747;
import net.minecraft.class_1792;

/**
 * Class used to check for if a {@link class_1792} is
 * a valid Target for rendering and used within {@link DefaultAccessoryRenderer#render}
 */
public enum TargetType {
    ITEM(item -> !(item instanceof class_1747)),
    BLOCK(item -> item instanceof class_1747),
    ALL(item -> true);

    private final Predicate<class_1792> predicate;

    TargetType(Predicate<class_1792> predicate) {
        this.predicate = predicate;
    }

    public boolean isValid(class_1792 item) {
        return this.predicate.test(item);
    }
}
