package io.wispforest.accessories.api.client.screen;

import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.compat.config.MenuButtonInjection;
import io.wispforest.accessories.mixin.HorseInventoryMenuAccessor;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.accessories.networking.server.ContainerClose;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1309;
import net.minecraft.class_1496;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_490;
import net.minecraft.class_491;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.Map.Entry;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;

@ApiStatus.Experimental
public class AccessoriesScreenTransitionHelper {

    private static boolean INITIALIZED_INJECTIONS = false;

    public static final Event<MenuButtonInjectionCallback> EVENT = EventFactory.createArrayBacked(MenuButtonInjectionCallback.class, invokers -> registerFunc -> {
        for (var invoker : invokers) invoker.registerInjections(registerFunc);
    });

    private static final List<Class<class_465<class_1703>>> SCREEN_CLASSES = new ArrayList<>();

    private static final Map<class_2960, MenuButtonInjection> BUTTON_INJECTION_DATA = new HashMap<>();

    private static final Map<Predicate<class_465<class_1703>>, ScreenTransitionHelper> SCREEN_PREDICATES = new LinkedHashMap<>();

    private static final List<PlayerBasedTargetGetter> SCREENLESS_TARGET_GETTERS = new ArrayList<>();

    private static final List<ScreenOpener> SCREEN_OPENERS = new ArrayList<>();

    public static void registerTargetGetter(PlayerBasedTargetGetter getter) {
        SCREENLESS_TARGET_GETTERS.add(getter);
    }

    public static void registerScreenOpener(ScreenOpener screenOpener) {
        SCREEN_OPENERS.add(screenOpener);
    }

    @SafeVarargs
    public static void registerScreensForButton(Class<? extends class_465<?>>... screenClasses) {
        SCREEN_CLASSES.addAll((Collection) List.of(screenClasses));
    }

    public static <M extends class_1703, S extends class_465<M>> void registerPlayerScreenTransition(class_2960 location, Class<S> screenClass) {
        registerPlayerScreenTransition(location, screenClass::isInstance);

        registerScreensForButton(screenClass);
    }

    public static void registerPlayerScreenTransition(class_2960 location, Predicate<class_465<class_1703>> screenPredicate) {
        registerScreenTransition(location, screenPredicate, ScreenBasedTargetGetter.PLAYER_DEFAULTED_TARGET, ScreenReopener.PLAYER_INVENTORY);
    }

    public static <M extends class_1703, S extends class_465<M>> void registerScreenTransitionWithCustomInvReopener(class_2960 location, Class<S> screenClass, ScreenBasedTargetGetter<M, S> getter) {
        registerScreenTransition(location, screenClass, getter, (ScreenReopener<M, S>) ScreenReopener.CUSTOM_INVENTORY);
    }

    public static <M extends class_1703, S extends class_465<M>> void registerScreenTransition(class_2960 location, Class<S> screenClass, ScreenBasedTargetGetter<M, S> getter, ScreenReopener<M, S> reopener) {
        registerScreenTransition(location,
                screenClass::isInstance,
                (ScreenBasedTargetGetter<class_1703, class_465<class_1703>>) getter,
                (ScreenReopener<class_1703, class_465<class_1703>>) reopener);

        registerScreensForButton(screenClass);
    }

    public static void registerScreenTransition(class_2960 location, Predicate<class_465<class_1703>> screenPredicate, ScreenBasedTargetGetter<class_1703, class_465<class_1703>> targetEntityGetter, ScreenReopener<class_1703, class_465<class_1703>> reopener) {
        SCREEN_PREDICATES.put(screenPredicate, new ScreenTransitionHelper(location, targetEntityGetter, reopener));
    }

    //--

    @ApiStatus.Internal
    public static Class<class_465>[] getScreenClasses() {
        return List.copyOf(SCREEN_CLASSES).toArray(value -> new Class[value]);
    }

    private static @Nullable class_437 prevScreen = null;
    private static @Nullable MenuButtonInjection prevInjection = null;
    private static @Nullable AccessoriesScreenTransitionHelper.ScreenTransitionHelper prevScreenInfo = null;

    @ApiStatus.Internal
    public static @Nullable MenuButtonInjection getInjection(class_465<class_1703> screen) {
        if (!INITIALIZED_INJECTIONS) initInjections();

        if (screen.equals(prevScreen)) return prevInjection;

        MenuButtonInjection injection = null;
        ScreenTransitionHelper info = null;

        try {
            var typeLocation = class_7923.field_41187.method_10221(screen.method_17577().method_17358());

            injection = BUTTON_INJECTION_DATA.get(typeLocation);
        } catch (Exception ignored) {}

        if (injection == null) {
            info = getInfo(screen);

            if(info != null) {
                injection = BUTTON_INJECTION_DATA.get(info.location());
            }
        }

        prevScreen = screen;
        prevInjection = injection;
        prevScreenInfo = info;

        return injection;
    }

    private static @Nullable AccessoriesScreenTransitionHelper.ScreenTransitionHelper getInfo(class_465<class_1703> screen) {
        for (var entry : SCREEN_PREDICATES.entrySet()) {
            if (entry.getKey().test(screen)) return entry.getValue();
        }

        return null;
    }

    @ApiStatus.Internal
    @Nullable
    public static class_1309 getTargetEntity(class_465<class_1703> screen) {
        if (prevScreenInfo == null) return null;

        return prevScreenInfo.getter().getTarget(screen);
    }

    @ApiStatus.Internal
    @Nullable
    public static class_1309 getTargetEntity(class_746 player) {
        for (var targetGetter : SCREENLESS_TARGET_GETTERS) {
            var target = targetGetter.getTarget(player);

            if (target != null) return target;
        }

        return null;
    }

    @ApiStatus.Internal
    public static void openPrevScreen(class_1657 player, class_1309 targetEntity, @Nullable class_465<class_1703> screen) {
        if (screen != null) {
            var info = getInfo(screen);

            if (info != null) {
                if(info.reopener.reopenScreen(player, targetEntity, screen)) return;
            }
        } else {
            if (Accessories.config().screenOptions.backButtonClosesScreen()) {
                class_310.method_1551().method_1507(null);

                return;
            }

            for (var screenOpener : SCREEN_OPENERS) {
                if (screenOpener.openScreen(player, targetEntity)) return;
            }
        }

        class_310.method_1551().method_1507(new class_490(player));

        player.field_7512 = player.field_7498;

        AccessoriesNetworking.sendToServer(new ContainerClose());
    }

    @ApiStatus.Internal
    public static void init() {
        registerPlayerScreenTransition(class_2960.method_60656("creative_player_inventory"), class_481.class);
        registerPlayerScreenTransition(class_2960.method_60656("player_inventory"), class_490.class);

        //--

        registerScreenTransitionWithCustomInvReopener(
                class_2960.method_60656("horse_inventory"),
                class_491.class,
                (class_491 screen) -> ((HorseInventoryMenuAccessor) screen.method_17577()).accessories$horse()
        );

        registerTargetGetter(player -> {
            return (player.method_5854() instanceof class_1496 abstractHorse)
                    ? abstractHorse
                    : null;
        });

        registerScreenOpener(ScreenOpener.CUSTOM_INVENTORY);
    }

    public static void initInjections() {
        Consumer<List<MenuButtonInjection>> consumer = injections -> {
            BUTTON_INJECTION_DATA.clear();

            injections.forEach(injection -> BUTTON_INJECTION_DATA.putIfAbsent(injection.menuType(), injection));

            EVENT.invoker().registerInjections(BUTTON_INJECTION_DATA::putIfAbsent);
        };

        Accessories.config().screenOptions.subscribeToMenuButtonInjections(consumer);

        consumer.accept(Accessories.config().screenOptions.menuButtonInjections());

        INITIALIZED_INJECTIONS = true;
    }

    private record ScreenTransitionHelper(class_2960 location, ScreenBasedTargetGetter<class_1703, class_465<class_1703>> getter, ScreenReopener<class_1703, class_465<class_1703>> reopener) { }

    public interface MenuButtonInjectionCallback {
        void registerInjections(BiConsumer<class_2960, MenuButtonInjection> registerFunc);
    }
}
