package io.wispforest.accessories.api.components;

import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.owo.serialization.CodecUtils;
import org.jetbrains.annotations.ApiStatus;

import java.util.*;
import java.util.stream.Collectors;
import net.minecraft.class_1293;
import net.minecraft.class_1309;

@ApiStatus.Experimental
public final class AccessoryMobEffectsComponent {
    public static final AccessoryMobEffectsComponent EMPTY = new AccessoryMobEffectsComponent(new ArrayList<>(), new HashMap<>());

    private static final Endec<List<class_1293>> MOB_EFFECT_INSTANCES = CodecUtils.toEndecWithRegistries(class_1293.field_48821, class_1293.field_49207).listOf();
    private static final Endec<Map<Integer, List<class_1293>>> MAP_ENDEC = StructEndecBuilder.of(
            Endec.INT.fieldOf("delay", Map.Entry::getKey),
            MOB_EFFECT_INSTANCES.fieldOf("effect_instances", Map.Entry::getValue),
            Map::entry
    ).listOf()
            .xmap(entries -> {
                return entries.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (instances1, instances2) -> {
                    var list = new ArrayList<>(instances1);

                    list.addAll(instances2);

                    return list;
                }, LinkedHashMap::new));
            }, kvMap -> List.copyOf(kvMap.entrySet()));

    public static Endec<AccessoryMobEffectsComponent> ENDEC = StructEndecBuilder.of(
            MOB_EFFECT_INSTANCES.fieldOf("constant_effects", AccessoryMobEffectsComponent::constantMobEffects),
            MAP_ENDEC.fieldOf("delayed_effects", AccessoryMobEffectsComponent::delayedMobEffects),
            AccessoryMobEffectsComponent::new
    );

    private final List<class_1293> constantMobEffects;
    private final Map<Integer, List<class_1293>> delayedMobEffects;

    private final Map<Integer, Long> delayToTimer = new HashMap<>();

    public AccessoryMobEffectsComponent(List<class_1293> constantMobEffects, Map<Integer, List<class_1293>> mobEffects) {
        this.constantMobEffects = constantMobEffects;
        this.delayedMobEffects = mobEffects;
    }

    public List<class_1293> constantMobEffects() {
        return Collections.unmodifiableList(this.constantMobEffects);
    }

    public Map<Integer, List<class_1293>> delayedMobEffects() {
        return Collections.unmodifiableMap(this.delayedMobEffects);
    }

    public AccessoryMobEffectsComponent addEffect(class_1293 instance) {
        var effects = new ArrayList<>(this.constantMobEffects);

        effects.add(instance);

        return new AccessoryMobEffectsComponent(effects, this.delayedMobEffects);
    }

    public AccessoryMobEffectsComponent addEffect(class_1293 instance, int applyDelay) {
        var map = new HashMap<>(this.delayedMobEffects);

        map.computeIfAbsent(applyDelay, integer -> new ArrayList<>())
                .add(instance);

        return new AccessoryMobEffectsComponent(this.constantMobEffects, map);
    }

    public void handleApplyingConstantEffects(class_1309 livingEntity) {
        for (class_1293 constantMobEffect : this.constantMobEffects) {
            livingEntity.method_6092(constantMobEffect);
        }
    }

    public void handleReapplyingEffects(class_1309 livingEntity, long time) {
        for (var i : delayedMobEffects.keySet()) {
            var lastApply = delayToTimer.getOrDefault(i, null);

            if ((lastApply == null) || time - lastApply > i) {
                for (var mobEffectInstance : delayedMobEffects.get(i)) {
                    livingEntity.method_6092(mobEffectInstance);
                }
            }

            delayToTimer.put(i, time);
        }
    }

    public void handleRemovingEffects(class_1309 livingEntity) {
        for (List<class_1293> value : delayedMobEffects.values()) {
            for (class_1293 mobEffectInstance : value) {
                livingEntity.method_6016(mobEffectInstance.method_5579());
            }
        }

        for (class_1293 mobEffectInstance : this.constantMobEffects) {
            livingEntity.method_6016(mobEffectInstance.method_5579());
        }

        delayToTimer.clear();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (obj == null || obj.getClass() != this.getClass()) return false;
        var that = (AccessoryMobEffectsComponent) obj;
        return Objects.equals(this.delayedMobEffects, that.delayedMobEffects);
    }

    @Override
    public int hashCode() {
        return Objects.hash(delayedMobEffects);
    }

    @Override
    public String toString() {
        return "AccessoryMobEffectsComponent[" +
                "mobEffects=" + delayedMobEffects + ']';
    }
}
