package io.wispforest.accessories.api.components;

import I;
import io.wispforest.accessories.api.core.Accessory;
import io.wispforest.accessories.api.core.AccessoryRegistry;
import io.wispforest.accessories.api.events.SlotStateChange;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotPath;
import io.wispforest.accessories.api.slot.SlotPathWithStack;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.owo.serialization.CodecUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.*;
import net.minecraft.class_1799;

public final class AccessoryNestContainerContents {

    public static final AccessoryNestContainerContents EMPTY = new AccessoryNestContainerContents(List.of());

    public static final Endec<AccessoryNestContainerContents> ENDEC = StructEndecBuilder.of(
            CodecUtils.toEndec(class_1799.field_49266).listOf().fieldOf("accessories", AccessoryNestContainerContents::accessories),
            AccessoryNestContainerContents::new
    );

    private final List<class_1799> accessories;

    private final Map<Integer, SlotStateChange> slotChanges = new Int2ObjectOpenHashMap<>();

    public AccessoryNestContainerContents(List<class_1799> accessories) {
        this.accessories = accessories;
    }

    public AccessoryNestContainerContents setStack(int index, class_1799 stack) {
        var accessories = new ArrayList<>(accessories());

        accessories.set(index, stack);

        var contents = new AccessoryNestContainerContents(accessories);

        contents.slotChanges.putAll(slotChanges);
        contents.slotChanges.put(index, SlotStateChange.REPLACEMENT);

        return contents;
    }

    public AccessoryNestContainerContents addStack(class_1799 stack) {
        var accessories = new ArrayList<>(accessories());

        var index = accessories.size();

        accessories.add(stack);

        var contents = new AccessoryNestContainerContents(accessories);

        contents.slotChanges.putAll(slotChanges);
        contents.slotChanges.put(index, SlotStateChange.REPLACEMENT);

        return contents;
    }

    public Map<Integer, SlotStateChange> slotChanges() {
        return this.slotChanges;
    }

    public Map<class_1799, Accessory> getMap() {
        var map = new LinkedHashMap<class_1799, Accessory>();

        this.accessories().forEach(stack1 -> map.put(stack1, AccessoryRegistry.getAccessoryOrDefault(stack1)));

        return map;
    }

    public Map<SlotEntryReference, Accessory> getMap(SlotReference slotReference) {
        var map = new LinkedHashMap<SlotEntryReference, Accessory>();

        var innerStacks = this.accessories();

        for (int i = 0; i < innerStacks.size(); i++) {
            var innerStack = innerStacks.get(i);

            if (innerStack.method_7960()) continue;

            map.put(new SlotEntryReference(SlotPath.cloneWithInnerIndex(slotReference, i), innerStack), AccessoryRegistry.getAccessoryOrDefault(innerStack));
        }

        return map;
    }

    public Map<SlotPathWithStack, Accessory> getMapWithPaths(SlotPath slotPath) {
        var map = new LinkedHashMap<SlotPathWithStack, Accessory>();

        var innerStacks = this.accessories();

        for (int i = 0; i < innerStacks.size(); i++) {
            var innerStack = innerStacks.get(i);

            if (innerStack.method_7960()) continue;

            map.put(SlotPathWithStack.of(SlotPath.cloneWithInnerIndex(slotPath, i), innerStack), AccessoryRegistry.getAccessoryOrDefault(innerStack));
        }

        return map;
    }

    public List<class_1799> accessories() {
        return accessories;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (obj == null || obj.getClass() != this.getClass()) return false;
        var that = (AccessoryNestContainerContents) obj;
        return Objects.equals(this.accessories, that.accessories);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accessories);
    }

    @Override
    public String toString() {
        return "AccessoryNestContainerContents[" +
                "accessories=" + accessories + ']';
    }

}
