package io.wispforest.accessories.api.data;

import io.wispforest.accessories.Accessories;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;

import static io.wispforest.accessories.api.data.AccessoriesBaseData.*;

public class AccessoriesTags {

    /**
     * Below are tags for the base implemented slots acting as common slots for people to use.
     */
    public static final class_6862<class_1792> ANKLET_TAG = itemTag(ANKLET_SLOT);
    public static final class_6862<class_1792> BACK_TAG = itemTag(BACK_SLOT);
    public static final class_6862<class_1792> BELT_TAG = itemTag(BELT_SLOT);
    public static final class_6862<class_1792> CAPE_TAG = itemTag(CAPE_SLOT);
    public static final class_6862<class_1792> CHARM_TAG = itemTag(CHARM_SLOT);
    public static final class_6862<class_1792> FACE_TAG = itemTag(FACE_SLOT);
    public static final class_6862<class_1792> HAND_TAG = itemTag(HAND_SLOT);
    public static final class_6862<class_1792> HAT_TAG = itemTag(HAT_SLOT);
    public static final class_6862<class_1792> NECKLACE_TAG = itemTag(NECKLACE_SLOT);
    public static final class_6862<class_1792> RING_TAG = itemTag(RING_SLOT);
    public static final class_6862<class_1792> SHOES_TAG = itemTag(SHOES_SLOT);
    public static final class_6862<class_1792> WRIST_TAG = itemTag(WRIST_SLOT);

    /**
     * @deprecated Use {@link #ANY_TAG} instead!
     */
    @Deprecated(forRemoval = true)
    public static final class_6862<class_1792> ALL_TAG = itemTag("all");

    /**
     * Slot tag used to allow for this given items contained inside to be
     * equipped to any slot if the such has the {@link AccessoriesBaseData#TAG_PREDICATE_ID}
     */
    public static final class_6862<class_1792> ANY_TAG = itemTag("any");

    public static final class_6862<class_1792> VALID_GLIDER_EQUIP = itemTag("valid_glider_equip");

    public static final class_6862<class_1792> VALID_TOTEM_EQUIP = itemTag("valid_totem_equip");

    /**
     * Tag used to add to the default binding added by Accessories
     */
    public static final class_6862<class_1299<?>> DEFAULTED_TARGETS_BINDING = entityTag("defaulted_targets");

    public static final class_6862<class_1299<?>> EQUIPMENT_MANAGEABLE = class_6862.method_40092(class_7924.field_41266, Accessories.of("equipment_manageable"));

    public static final class_6862<class_1299<?>> MODIFIABLE_ENTITY_BLACKLIST = entityTag("modifiable_entity_accessories_blacklist");
    public static final class_6862<class_1299<?>> MODIFIABLE_ENTITY_WHITELIST = entityTag("modifiable_entity_accessories_whitelist");

    public static final class_6862<class_1299<?>> GAZE_DISGUISED_BLACKLIST = entityTag("gaze_disguised_blacklist");

    public static final class_6862<class_1299<?>> COSMETIC_ARMOR_TARGETS = entityTag("cosmetic_armor_targets");

    public static final class_6862<class_1299<?>> COSMETIC_ANIMAL_ARMOR_TARGETS = entityTag("cosmetic_animal_armor_targets");

    /**
     * Tag used to disallow the given {@link class_1887}'s within the tag to be
     * redirected to an Accessory {@link class_1799} when iterated
     */
    public static final class_6862<class_1887> INVALID_FOR_REDIRECTION = of(class_7924.field_41265, "invalid_for_redirection");

    public static class_6862<class_1792> itemTag(String path) {
        return of(class_7924.field_41197, path);
    }

    public static class_6862<class_1299<?>> entityTag(String path) {
        return of(class_7924.field_41266, path);
    }

    public static <T> class_6862<T> of(class_5321<? extends class_2378<T>> key, String path) {
        return class_6862.method_40092(key, Accessories.of(path));
    }
}
